/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.module;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.addons.oddities.client.screen.BackpackInventoryScreen;
import vazkii.quark.addons.oddities.container.BackpackContainer;
import vazkii.quark.addons.oddities.item.BackpackItem;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.HandleBackpackMessage;

@LoadModule(category=ModuleCategory.ODDITIES, hasSubscriptions=true)
public class BackpackModule
extends QuarkModule {
    @Config(description="Set this to true to allow the backpacks to be unequipped even with items in them")
    public static boolean superOpMode = false;
    @Config(flag="ravager_hide")
    public static boolean enableRavagerHide = true;
    @Config
    public static boolean itemsInBackpackTick = true;
    @Config
    public static int baseRavagerHideDrop = 1;
    @Config
    public static double extraChancePerLooting = 0.5;
    public static Item backpack;
    public static Item ravager_hide;
    public static Block bonded_ravager_hide;
    public static ContainerType<BackpackContainer> container;
    private static ItemStack heldStack;
    @OnlyIn(value=Dist.CLIENT)
    private static boolean backpackRequested;

    @Override
    public void construct() {
        backpack = new BackpackItem(this);
        ravager_hide = new QuarkItem("ravager_hide", this, new Item.Properties().func_208103_a(Rarity.RARE).func_200916_a(ItemGroup.field_78035_l)).setCondition(() -> enableRavagerHide);
        container = IForgeContainerType.create(BackpackContainer::fromNetwork);
        RegistryHelper.register(container, (String)"backpack");
        bonded_ravager_hide = new QuarkBlock("bonded_ravager_hide", this, ItemGroup.field_78030_b, AbstractBlock.Properties.func_200952_a((Material)Material.field_151580_n, (DyeColor)DyeColor.BLACK).func_200943_b(1.0f).func_200947_a(SoundType.field_185854_g)).setCondition(() -> enableRavagerHide);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        ScreenManager.func_216911_a(container, BackpackInventoryScreen::new);
        this.enqueue(() -> ItemModelsProperties.func_239418_a_((Item)backpack, (ResourceLocation)new ResourceLocation("has_items"), (stack, world, entity) -> !superOpMode && BackpackItem.doesBackpackHaveItems(stack) ? 1.0f : 0.0f));
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (enableRavagerHide && entity.func_200600_R() == EntityType.field_220352_aU) {
            int amount = baseRavagerHideDrop;
            double chance = (double)event.getLootingLevel() * extraChancePerLooting;
            while (chance > (double)baseRavagerHideDrop) {
                chance -= 1.0;
                ++amount;
            }
            if (chance > 0.0 && entity.field_70170_p.field_73012_v.nextDouble() < chance) {
                ++amount;
            }
            event.getDrops().add(new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), new ItemStack((IItemProvider)ravager_hide, amount)));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onOpenGUI(GuiOpenEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && BackpackModule.isInventoryGUI(event.getGui()) && !player.func_184812_l_() && BackpackModule.isEntityWearingBackpack((Entity)player)) {
            this.requestBackpack();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (BackpackModule.isInventoryGUI(mc.field_71462_r) && !backpackRequested && BackpackModule.isEntityWearingBackpack((Entity)mc.field_71439_g)) {
            this.requestBackpack();
            backpackRequested = true;
        } else if (mc.field_71462_r instanceof BackpackInventoryScreen) {
            if (heldStack != null) {
                mc.field_71439_g.field_71071_by.func_70437_b(heldStack);
                heldStack = null;
            }
            backpackRequested = false;
        }
    }

    private void requestBackpack() {
        heldStack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        QuarkNetwork.sendToServer(new HandleBackpackMessage(true));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void removeCurseTooltip(ItemTooltipEvent event) {
        if (!superOpMode && event.getItemStack().func_77973_b() instanceof BackpackItem) {
            for (ITextComponent s : event.getToolTip()) {
                if (!s.getString().equals(Enchantments.field_190941_k.func_200305_d(1).getString())) continue;
                event.getToolTip().remove(s);
                return;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean isInventoryGUI(Screen gui) {
        return gui != null && gui.getClass() == InventoryScreen.class;
    }

    public static boolean isEntityWearingBackpack(Entity e) {
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            ItemStack chestArmor = living.func_184582_a(EquipmentSlotType.CHEST);
            return chestArmor.func_77973_b() instanceof BackpackItem;
        }
        return false;
    }

    public static boolean isEntityWearingBackpack(Entity e, ItemStack stack) {
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            ItemStack chestArmor = living.func_184582_a(EquipmentSlotType.CHEST);
            return chestArmor == stack;
        }
        return false;
    }

    static {
        heldStack = null;
    }
}

