/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import vazkii.quark.base.handler.BrewingHandler;

public class PotionIngredient
extends Ingredient {
    private final Item item;
    private final Potion potion;

    public PotionIngredient(Item item, Potion potion) {
        super(Stream.of(new Ingredient.SingleItemList(BrewingHandler.of(item, potion))));
        this.item = item;
        this.potion = potion;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.item == input.func_77973_b() && PotionUtils.func_185191_c((ItemStack)input) == this.potion;
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Objects.toString(CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE)));
        json.addProperty("item", Objects.toString(this.item.getRegistryName()));
        json.addProperty("potion", Objects.toString(this.potion.getRegistryName()));
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<PotionIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Nonnull
        public PotionIngredient parse(@Nonnull PacketBuffer buffer) {
            Item item = (Item)Registry.field_212630_s.func_241873_b(buffer.func_192575_l()).get();
            Potion potion = (Potion)Registry.field_212621_j.func_241873_b(buffer.func_192575_l()).get();
            return new PotionIngredient(item, potion);
        }

        @Nonnull
        public PotionIngredient parse(@Nonnull JsonObject json) {
            Item item = (Item)Registry.field_212630_s.func_241873_b(new ResourceLocation(json.getAsJsonPrimitive("item").getAsString())).get();
            Potion potion = (Potion)Registry.field_212621_j.func_241873_b(new ResourceLocation(json.getAsJsonPrimitive("item").getAsString())).get();
            return new PotionIngredient(item, potion);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull PotionIngredient ingredient) {
            buffer.func_180714_a(Objects.toString(Registry.field_212630_s.func_148757_b((Object)ingredient.item)));
            buffer.func_180714_a(Objects.toString(Registry.field_212621_j.func_148757_b((Object)ingredient.potion)));
        }
    }
}

