/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.automation.tile.FeedingTroughTileEntity;

public class FeedingTroughBlock
extends QuarkBlock {
    private static final SoundType WOOD_WITH_PLANT_STEP = new SoundType(1.0f, 1.0f, SoundEvents.field_187881_gQ, SoundEvents.field_187579_bV, SoundEvents.field_187891_gV, SoundEvents.field_187889_gU, SoundEvents.field_187887_gT);
    public static BooleanProperty FULL = BooleanProperty.func_177716_a((String)"full");
    public static final VoxelShape CUBOID_SHAPE = FeedingTroughBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape EMPTY_SHAPE = VoxelShapes.func_197878_a((VoxelShape)CUBOID_SHAPE, (VoxelShape)FeedingTroughBlock.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    public static final VoxelShape FULL_SHAPE = VoxelShapes.func_197878_a((VoxelShape)CUBOID_SHAPE, (VoxelShape)FeedingTroughBlock.func_208617_a((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);

    public FeedingTroughBlock(String regname, QuarkModule module, ItemGroup creativeTab, AbstractBlock.Properties properties) {
        super(regname, module, creativeTab, properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)FULL, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, ISelectionContext context) {
        return EMPTY_SHAPE;
    }

    @Nonnull
    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        return CUBOID_SHAPE;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)FULL) != false ? FULL_SHAPE : EMPTY_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FULL});
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        if (((Boolean)state.func_177229_b((Property)FULL)).booleanValue()) {
            return WOOD_WITH_PLANT_STEP;
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        if (((Boolean)world.func_180495_p(pos).func_177229_b((Property)FULL)).booleanValue()) {
            entity.func_225503_b_(distance, 0.2f);
        } else {
            super.func_180658_a(world, pos, entity, distance);
        }
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof FeedingTroughTileEntity) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((FeedingTroughTileEntity)tile));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FeedingTroughTileEntity();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        INamedContainerProvider container = this.func_220052_b(state, world, pos);
        if (container != null) {
            player.func_213829_a(container);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && tile.func_145842_c(id, param);
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof INamedContainerProvider ? (INamedContainerProvider)tile : null;
    }
}

