/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.LeashKnotModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.LightType;
import vazkii.quark.content.building.entity.LeashKnot2Entity;

public class LeashKnot2Renderer
extends EntityRenderer<LeashKnot2Entity> {
    private static final ResourceLocation LEASH_KNOT_TEXTURES = new ResourceLocation("textures/entity/lead_knot.png");
    private final LeashKnotModel<LeashKnotEntity> leashKnotModel = new LeashKnotModel();

    public LeashKnot2Renderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public boolean shouldRender(LeashKnot2Entity livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        if (super.func_225626_a_((Entity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.func_110167_bD()) {
            Entity entity = livingEntityIn.func_110166_bE();
            return camera.func_228957_a_(entity.func_184177_bl());
        }
        return false;
    }

    public void render(LeashKnot2Entity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(this.leashKnotModel.func_228282_a_(LEASH_KNOT_TEXTURES));
        matrixStackIn.func_227861_a_(0.0, -0.125, 0.0);
        this.leashKnotModel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
        Entity entity = entityIn.func_110166_bE();
        if (entity != null) {
            this.renderLeash(entityIn, partialTicks, matrixStackIn, bufferIn, entity);
        }
    }

    private <E extends Entity> void renderLeash(LeashKnot2Entity entityLivingIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, E leashHolder) {
        matrixStackIn.func_227860_a_();
        double d0 = MathHelper.func_219799_g((float)(partialTicks * 0.5f), (float)leashHolder.field_70177_z, (float)leashHolder.field_70126_B) * ((float)Math.PI / 180);
        double d1 = MathHelper.func_219799_g((float)(partialTicks * 0.5f), (float)leashHolder.field_70125_A, (float)leashHolder.field_70127_C) * ((float)Math.PI / 180);
        double d2 = Math.cos(d0);
        double d3 = Math.sin(d0);
        double d4 = Math.sin(d1);
        if (leashHolder instanceof HangingEntity) {
            d2 = 0.0;
            d3 = 0.0;
            d4 = -1.0;
        }
        double d5 = Math.cos(d1);
        double d6 = MathHelper.func_219803_d((double)partialTicks, (double)leashHolder.field_70169_q, (double)leashHolder.func_226277_ct_()) - d2 * 0.7 - d3 * 0.5 * d5;
        double d7 = MathHelper.func_219803_d((double)partialTicks, (double)(leashHolder.field_70167_r + (double)leashHolder.func_70047_e() * 0.7), (double)(leashHolder.func_226278_cu_() + (double)leashHolder.func_70047_e() * 0.7)) - d4 * 0.5 - 0.25;
        double d8 = MathHelper.func_219803_d((double)partialTicks, (double)leashHolder.field_70166_s, (double)leashHolder.func_226281_cx_()) - d3 * 0.7 + d2 * 0.5 * d5;
        double d9 = (double)(MathHelper.func_219799_g((float)partialTicks, (float)entityLivingIn.field_70761_aq, (float)entityLivingIn.field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vector3d vector3d = new Vector3d(0.0, (double)0.32f, 0.0);
        d2 = Math.cos(d9) * vector3d.field_72449_c + Math.sin(d9) * vector3d.field_72450_a;
        d3 = Math.sin(d9) * vector3d.field_72449_c - Math.cos(d9) * vector3d.field_72450_a;
        double d10 = MathHelper.func_219803_d((double)partialTicks, (double)entityLivingIn.field_70169_q, (double)entityLivingIn.func_226277_ct_()) + d2;
        double d11 = MathHelper.func_219803_d((double)partialTicks, (double)entityLivingIn.field_70167_r, (double)entityLivingIn.func_226278_cu_()) + vector3d.field_72448_b;
        double d12 = MathHelper.func_219803_d((double)partialTicks, (double)entityLivingIn.field_70166_s, (double)entityLivingIn.func_226281_cx_()) + d3;
        matrixStackIn.func_227861_a_(d2, vector3d.field_72448_b, d3);
        float f = (float)(d6 - d10);
        float f1 = (float)(d7 - d11);
        float f2 = (float)(d8 - d12);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        float f4 = MathHelper.func_226165_i_((float)(f * f + f2 * f2)) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = new BlockPos(entityLivingIn.func_174824_e(partialTicks));
        BlockPos blockpos1 = new BlockPos(leashHolder.func_174824_e(partialTicks));
        int i = this.func_225624_a_((Entity)entityLivingIn, blockpos);
        int j = 0;
        int k = entityLivingIn.field_70170_p.func_226658_a_(LightType.SKY, blockpos);
        int l = entityLivingIn.field_70170_p.func_226658_a_(LightType.SKY, blockpos1);
        LeashKnot2Renderer.renderSide(ivertexbuilder, matrix4f, f, f1, f2, i, j, k, l, 0.025f, 0.025f, f5, f6);
        LeashKnot2Renderer.renderSide(ivertexbuilder, matrix4f, f, f1, f2, i, j, k, l, 0.025f, 0.0f, f5, f6);
        matrixStackIn.func_227865_b_();
    }

    public static void renderSide(IVertexBuilder bufferIn, Matrix4f matrixIn, float p_229119_2_, float p_229119_3_, float p_229119_4_, int blockLight, int holderBlockLight, int skyLight, int holderSkyLight, float p_229119_9_, float p_229119_10_, float p_229119_11_, float p_229119_12_) {
        int i = 24;
        for (int j = 0; j < 24; ++j) {
            float f = (float)j / 23.0f;
            int k = (int)MathHelper.func_219799_g((float)f, (float)blockLight, (float)holderBlockLight);
            int l = (int)MathHelper.func_219799_g((float)f, (float)skyLight, (float)holderSkyLight);
            int i1 = LightTexture.func_228451_a_((int)k, (int)l);
            LeashKnot2Renderer.addVertexPair(bufferIn, matrixIn, i1, p_229119_2_, p_229119_3_, p_229119_4_, p_229119_9_, p_229119_10_, 24, j, false, p_229119_11_, p_229119_12_);
            LeashKnot2Renderer.addVertexPair(bufferIn, matrixIn, i1, p_229119_2_, p_229119_3_, p_229119_4_, p_229119_9_, p_229119_10_, 24, j + 1, true, p_229119_11_, p_229119_12_);
        }
    }

    public static void addVertexPair(IVertexBuilder bufferIn, Matrix4f matrixIn, int packedLight, float p_229120_3_, float p_229120_4_, float p_229120_5_, float p_229120_6_, float p_229120_7_, int p_229120_8_, int p_229120_9_, boolean p_229120_10_, float p_229120_11_, float p_229120_12_) {
        float f = 0.5f;
        float f1 = 0.4f;
        float f2 = 0.3f;
        if (p_229120_9_ % 2 == 0) {
            f *= 0.7f;
            f1 *= 0.7f;
            f2 *= 0.7f;
        }
        float f3 = (float)p_229120_9_ / (float)p_229120_8_;
        float f4 = p_229120_3_ * f3;
        float f5 = p_229120_4_ > 0.0f ? p_229120_4_ * f3 * f3 : p_229120_4_ - p_229120_4_ * (1.0f - f3) * (1.0f - f3);
        float f6 = p_229120_5_ * f3;
        if (!p_229120_10_) {
            bufferIn.func_227888_a_(matrixIn, f4 + p_229120_11_, f5 + p_229120_6_ - p_229120_7_, f6 - p_229120_12_).func_227885_a_(f, f1, f2, 1.0f).func_227886_a_(packedLight).func_181675_d();
        }
        bufferIn.func_227888_a_(matrixIn, f4 - p_229120_11_, f5 + p_229120_7_, f6 + p_229120_12_).func_227885_a_(f, f1, f2, 1.0f).func_227886_a_(packedLight).func_181675_d();
        if (p_229120_10_) {
            bufferIn.func_227888_a_(matrixIn, f4 + p_229120_11_, f5 + p_229120_6_ - p_229120_7_, f6 - p_229120_12_).func_227885_a_(f, f1, f2, 1.0f).func_227886_a_(packedLight).func_181675_d();
        }
    }

    public ResourceLocation getEntityTexture(LeashKnot2Entity entity) {
        return LEASH_KNOT_TEXTURES;
    }
}

