/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.building.block.CandleBlock;

@LoadModule(category=ModuleCategory.BUILDING, hasSubscriptions=true)
public class TallowAndCandlesModule
extends QuarkModule {
    @Config
    public static boolean candlesFall = true;
    @Config
    @Config.Min(value=0.0)
    public static int minDrop = 1;
    @Config
    @Config.Min(value=0.0)
    public static int maxDrop = 3;
    @Config
    @Config.Min(value=0.0)
    public static int tallowBurnTime = 200;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=15.0)
    public static double enchantPower = 1.0;
    public static Item tallow;
    public static Block tallow_block;

    @Override
    public void construct() {
        tallow = new QuarkItem("tallow", this, new Item.Properties().func_200916_a(ItemGroup.field_78035_l));
        for (DyeColor dye : DyeColor.values()) {
            new CandleBlock(dye.func_176762_d() + "_candle", this, dye);
        }
        tallow_block = new QuarkBlock("tallow_block", this, ItemGroup.field_78030_b, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_226908_md_));
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        int drops;
        LivingEntity e = event.getEntityLiving();
        if (e instanceof PigEntity && !((PigEntity)e).func_70631_g_() && maxDrop > 0 && e.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g) && (drops = minDrop + e.field_70170_p.field_73012_v.nextInt(maxDrop - minDrop + 1)) > 0) {
            Vector3d pos = e.func_213303_ch();
            event.getDrops().add(new ItemEntity(e.field_70170_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, new ItemStack((IItemProvider)tallow, drops)));
        }
    }

    @SubscribeEvent
    public void onFurnaceTimeCheck(FurnaceFuelBurnTimeEvent event) {
        if (tallowBurnTime <= 0) {
            return;
        }
        Item item = event.getItemStack().func_77973_b();
        if (item == tallow) {
            event.setBurnTime(tallowBurnTime);
        } else if (item == tallow_block.func_199767_j()) {
            event.setBurnTime(tallowBurnTime * 9);
        }
    }
}

