/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.experimental.shiba.entity;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.quark.content.experimental.module.ShibaModule;
import vazkii.quark.content.experimental.shiba.ai.DeliverFetchedItemGoal;
import vazkii.quark.content.experimental.shiba.ai.FetchArrowGoal;
import vazkii.quark.content.tweaks.ai.NuzzleGoal;
import vazkii.quark.content.tweaks.ai.WantLoveGoal;

public class ShibaEntity
extends TameableEntity {
    private static final DataParameter<Integer> COLLAR_COLOR = EntityDataManager.func_187226_a(ShibaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> MOUTH_ITEM = EntityDataManager.func_187226_a(ShibaEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> FETCHING = EntityDataManager.func_187226_a(ShibaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public ShibaEntity(EntityType<? extends ShibaEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_70903_f(false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FetchArrowGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new DeliverFetchedItemGoal(this, 1.1, -1.0f, 32.0f, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151103_aS}), false));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new NuzzleGoal(this, 0.5, 16.0f, 2.0f, SoundEvents.field_187871_gL));
        this.field_70714_bg.func_75776_a(9, (Goal)new WantLoveGoal(this, 0.2f));
        this.field_70714_bg.func_75776_a(10, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public void func_70071_h_() {
        AxisAlignedBB check;
        List arrows;
        LivingEntity owner;
        super.func_70071_h_();
        AbstractArrowEntity fetching = this.getFetching();
        if (fetching != null && (this.func_233684_eK_() || fetching.field_70170_p != this.field_70170_p || !fetching.func_70089_S() || fetching.field_70251_a == AbstractArrowEntity.PickupStatus.DISALLOWED)) {
            this.setFetching(null);
        }
        if (!this.func_233684_eK_() && !this.field_70170_p.field_72995_K && fetching == null && this.getMouthItem().func_190926_b() && (owner = this.func_70902_q()) != null && (arrows = this.field_70170_p.func_175647_a(AbstractArrowEntity.class, check = owner.func_174813_aQ().func_186662_g(2.0), a -> a.func_234616_v_() == owner && a.field_70251_a != AbstractArrowEntity.PickupStatus.DISALLOWED)).size() > 0) {
            AbstractArrowEntity arrow = (AbstractArrowEntity)arrows.get(this.field_70170_p.field_73012_v.nextInt(arrows.size()));
            this.setFetching(arrow);
        }
    }

    public AbstractArrowEntity getFetching() {
        int id = (Integer)this.field_70180_af.func_187225_a(FETCHING);
        if (id == -1) {
            return null;
        }
        Entity e = this.field_70170_p.func_73045_a(id);
        if (e == null || !(e instanceof AbstractArrowEntity)) {
            return null;
        }
        return (AbstractArrowEntity)e;
    }

    public void setFetching(AbstractArrowEntity e) {
        this.field_70180_af.func_187227_b(FETCHING, (Object)(e == null ? -1 : e.func_145782_y()));
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item.func_219971_r() && item.func_219967_s().func_221467_c();
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLLAR_COLOR, (Object)DyeColor.RED.func_196059_a());
        this.field_70180_af.func_187214_a(MOUTH_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(FETCHING, (Object)-1);
    }

    public DyeColor getCollarColor() {
        return DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor collarcolor) {
        this.field_70180_af.func_187227_b(COLLAR_COLOR, (Object)collarcolor.func_196059_a());
    }

    public ItemStack getMouthItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(MOUTH_ITEM);
    }

    public void setMouthItem(ItemStack stack) {
        this.field_70180_af.func_187227_b(MOUTH_ITEM, (Object)stack);
    }

    public int func_70641_bl() {
        return 8;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof ShibaEntity)) {
            return false;
        }
        ShibaEntity wolfentity = (ShibaEntity)otherAnimal;
        if (!wolfentity.func_70909_n()) {
            return false;
        }
        if (wolfentity.func_233684_eK_()) {
            return false;
        }
        return this.func_70880_s() && wolfentity.func_70880_s();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("CollarColor", (byte)this.getCollarColor().func_196059_a());
        CompoundNBT itemcmp = new CompoundNBT();
        ItemStack holding = this.getMouthItem();
        if (!holding.func_190926_b()) {
            holding.func_77955_b(itemcmp);
        }
        compound.func_218657_a("MouthItem", (INBT)itemcmp);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("CollarColor", 99)) {
            this.setCollarColor(DyeColor.func_196056_a((int)compound.func_74762_e("CollarColor")));
        }
        if (compound.func_74764_b("MouthItem")) {
            CompoundNBT itemcmp = compound.func_74775_l("MouthItem");
            this.setMouthItem(ItemStack.func_199557_a((CompoundNBT)itemcmp));
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (player.func_226273_bm_() && player.func_184614_ca().func_190926_b()) {
            if (hand == Hand.MAIN_HAND && WantLoveGoal.canPet(this)) {
                if (player.field_70170_p instanceof ServerWorld) {
                    Vector3d pos = this.func_213303_ch();
                    ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, pos.field_72450_a, pos.field_72448_b + 0.5, pos.field_72449_c, 1, 0.0, 0.0, 0.0, 0.1);
                    this.func_184185_a(SoundEvents.field_187871_gL, 0.6f, 0.5f + (float)Math.random() * 0.5f);
                } else {
                    player.func_184609_a(Hand.MAIN_HAND);
                }
                WantLoveGoal.setPetTime(this);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.field_70170_p.field_72995_K) {
            boolean flag = this.func_152114_e((LivingEntity)player) || this.func_70909_n() || item == Items.field_151103_aS && !this.func_70909_n();
            return flag ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        if (this.func_70909_n()) {
            ItemStack mouthItem = this.getMouthItem();
            if (!mouthItem.func_190926_b()) {
                ItemStack copy = mouthItem.func_77946_l();
                if (!player.func_191521_c(copy)) {
                    this.func_199701_a_(copy);
                }
                if (player.field_70170_p instanceof ServerWorld) {
                    Vector3d pos = this.func_213303_ch();
                    ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, pos.field_72450_a, pos.field_72448_b + 0.5, pos.field_72449_c, 1, 0.0, 0.0, 0.0, 0.1);
                    this.func_184185_a(SoundEvents.field_187871_gL, 0.6f, 0.5f + (float)Math.random() * 0.5f);
                }
                this.setMouthItem(ItemStack.field_190927_a);
                return ActionResultType.SUCCESS;
            }
            if (this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(item.func_219967_s().func_221466_a());
                return ActionResultType.SUCCESS;
            }
            if (!(item instanceof DyeItem)) {
                if (!itemstack.func_190926_b() && mouthItem.func_190926_b() && itemstack.func_77973_b() instanceof SwordItem) {
                    ItemStack copy = itemstack.func_77946_l();
                    copy.func_190920_e(1);
                    itemstack.func_190920_e(itemstack.func_190916_E() - 1);
                    this.setMouthItem(copy);
                    return ActionResultType.SUCCESS;
                }
                ActionResultType actionresulttype = super.func_230254_b_(player, hand);
                if ((!actionresulttype.func_226246_a_() || this.func_70631_g_()) && this.func_152114_e((LivingEntity)player)) {
                    this.func_233687_w_(!this.func_233685_eM_());
                    this.field_70703_bu = false;
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    return ActionResultType.SUCCESS;
                }
                return actionresulttype;
            }
            DyeColor dyecolor = ((DyeItem)item).func_195962_g();
            if (dyecolor != this.getCollarColor()) {
                this.setCollarColor(dyecolor);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        } else if (item == Items.field_151103_aS) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                WantLoveGoal.setPetTime(this);
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
            this.func_70606_j(20.0f);
        }
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(8.0);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(4.0);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_110143_aJ() < 10.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        ShibaEntity wolfentity = (ShibaEntity)ShibaModule.shibaType.func_200721_a((World)world);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            wolfentity.func_184754_b(uuid);
            wolfentity.func_70903_f(true);
        }
        return wolfentity;
    }
}

