/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.ai;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tags.Tag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class FavorBlockGoal
extends Goal {
    private final CreatureEntity creature;
    private final double movementSpeed;
    private final Predicate<BlockState> targetBlock;
    protected int runDelay;
    private int timeoutCounter;
    private int maxStayTicks;
    protected BlockPos destinationBlock = BlockPos.field_177992_a;

    public FavorBlockGoal(CreatureEntity creature, double speed, Predicate<BlockState> predicate) {
        this.creature = creature;
        this.movementSpeed = speed;
        this.targetBlock = predicate;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public FavorBlockGoal(CreatureEntity creature, double speed, Tag<Block> tag) {
        this(creature, speed, (BlockState state) -> tag.func_230235_a_((Object)state.func_177230_c()));
    }

    public FavorBlockGoal(CreatureEntity creature, double speed, Block block) {
        this(creature, speed, (BlockState state) -> state.func_177230_c() == block);
    }

    public boolean func_75250_a() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = 200 + this.creature.func_70681_au().nextInt(200);
        return this.searchForDestination();
    }

    public boolean func_75253_b() {
        return this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.targetBlock.test(this.creature.field_70170_p.func_180495_p(this.destinationBlock));
    }

    public void func_75249_e() {
        this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
        this.timeoutCounter = 0;
        this.maxStayTicks = this.creature.func_70681_au().nextInt(this.creature.func_70681_au().nextInt(1200) + 1200) + 1200;
    }

    public void func_75246_d() {
        Vector3d vector3d = new Vector3d((double)this.destinationBlock.func_177958_n(), (double)this.destinationBlock.func_177956_o(), (double)this.destinationBlock.func_177952_p());
        if (this.creature.func_195048_a(vector3d.func_72441_c(0.5, 1.5, 0.5)) > 1.0) {
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
            }
        } else {
            --this.timeoutCounter;
        }
    }

    private boolean searchForDestination() {
        double followRange = this.creature.func_110148_a(Attributes.field_233819_b_).func_111126_e();
        Vector3d cpos = this.creature.func_213303_ch();
        double xBase = cpos.field_72450_a;
        double yBase = cpos.field_72448_b;
        double zBase = cpos.field_72449_c;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int yShift = 0;
        while (yShift <= 1) {
            int seekDist = 0;
            while ((double)seekDist < followRange) {
                int xShift = 0;
                while (xShift <= seekDist) {
                    int zShift;
                    int n = zShift = xShift < seekDist && xShift > -seekDist ? seekDist : 0;
                    while (zShift <= seekDist) {
                        pos.func_189532_c(xBase + (double)xShift, yBase + (double)yShift - 1.0, zBase + (double)zShift);
                        if (this.creature.func_213389_a((BlockPos)pos) && this.targetBlock.test(this.creature.field_70170_p.func_180495_p((BlockPos)pos))) {
                            this.destinationBlock = pos;
                            return true;
                        }
                        zShift = zShift > 0 ? -zShift : 1 - zShift;
                    }
                    xShift = xShift > 0 ? -xShift : 1 - xShift;
                }
                ++seekDist;
            }
            yShift = yShift > 0 ? -yShift : 1 - yShift;
        }
        return false;
    }
}

