/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.tileentity.TileDryingBasin;

public class RenderTileEntityDryingBasin
extends TileEntityRenderer<TileDryingBasin> {
    public RenderTileEntityDryingBasin(TileEntityRendererDispatcher tileEntityRendererDispatcher) {
        super(tileEntityRendererDispatcher);
    }

    public void render(TileDryingBasin tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay) {
        if (tile != null) {
            if (!tile.getInventory().func_70301_a(0).func_190926_b()) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
                this.renderItem(matrixStack, renderTypeBuffer, tile.getInventory().func_70301_a(0), tile.getRandomRotation());
                matrixStack.func_227865_b_();
            }
            FluidStack fluid = tile.getTank().getFluid();
            RenderHelpers.renderFluidContext((FluidStack)fluid, (MatrixStack)matrixStack, () -> {
                float height = (float)((double)fluid.getAmount() * 0.7 / 1000.0 + 0.23 + 0.01);
                int brightness = Math.max(combinedLight, fluid.getFluid().getAttributes().getLuminosity(fluid));
                int l2 = brightness >> 16 & 0xFFFF;
                int i3 = brightness & 0xFFFF;
                TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)fluid, (Direction)Direction.UP);
                Triple color = Helpers.intToRGB((int)fluid.getFluid().getAttributes().getColor((IBlockDisplayReader)tile.func_145831_w(), tile.func_174877_v()));
                IVertexBuilder vb = renderTypeBuffer.getBuffer(RenderType.func_228658_l_((ResourceLocation)icon.func_229241_m_().func_229223_g_()));
                Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                vb.func_227888_a_(matrix, 0.0625f, height, 0.0625f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94209_e(), icon.func_94210_h()).func_225587_b_(l2, i3).func_181675_d();
                vb.func_227888_a_(matrix, 0.0625f, height, 0.9375f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94209_e(), icon.func_94206_g()).func_225587_b_(l2, i3).func_181675_d();
                vb.func_227888_a_(matrix, 0.9375f, height, 0.9375f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94212_f(), icon.func_94206_g()).func_225587_b_(l2, i3).func_181675_d();
                vb.func_227888_a_(matrix, 0.9375f, height, 0.0625f).func_227885_a_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).func_225583_a_(icon.func_94212_f(), icon.func_94210_h()).func_225587_b_(l2, i3).func_181675_d();
            });
        }
    }

    private void renderItem(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, ItemStack itemStack, float rotation) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(itemStack, null, null);
        if (model.func_177556_c()) {
            matrixStack.func_227861_a_(1.0, (double)1.2f, 1.0);
            matrixStack.func_227862_a_(1.2f, 1.2f, 1.2f);
        } else {
            matrixStack.func_227861_a_(1.0, (double)1.2f, 1.0);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(25.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(25.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        }
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemStack, ItemCameraTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.field_229196_a_, matrixStack, renderTypeBuffer);
    }
}

