/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.block;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;

public class VoxelShapeComponents
extends VoxelShape
implements Iterable<VoxelShape> {
    private final Collection<Pair<VoxelShape, IComponent>> entries;
    private final String stateId;

    protected VoxelShapeComponents(Collection<Pair<VoxelShape, IComponent>> entries, String stateId) {
        super(VoxelShapeComponents.createInnerPart(entries));
        this.entries = entries;
        this.stateId = stateId;
    }

    protected static VoxelShapePart createInnerPart(Collection<Pair<VoxelShape, IComponent>> entries) {
        return new Part(entries.stream().map(pair -> ((VoxelShape)pair.getLeft()).field_197768_g).collect(Collectors.toList()));
    }

    public static VoxelShapeComponents create(BlockState blockState, IBlockReader world, BlockPos blockPos, ISelectionContext selectionContext, List<IComponent> components) {
        ArrayList entries = Lists.newArrayList();
        for (IComponent component : components) {
            VoxelShape shape = component.getShape(blockState, world, blockPos, selectionContext);
            entries.add(Pair.of((Object)shape, (Object)component));
        }
        StringBuilder stateIdBuilder = new StringBuilder();
        for (IComponent component : components) {
            stateIdBuilder.append(component.getStateId(blockState, world, blockPos));
            stateIdBuilder.append(";");
        }
        return new VoxelShapeComponents(entries, stateIdBuilder.toString());
    }

    public String getStateId() {
        return this.stateId;
    }

    @Override
    public Iterator<VoxelShape> iterator() {
        return this.entries.stream().map(Pair::getLeft).iterator();
    }

    public double func_197762_b(Direction.Axis axis) {
        boolean first = true;
        double startMin = 0.0;
        for (VoxelShape shape : this) {
            double start = shape.func_197762_b(axis);
            if (!first && !(start < startMin)) continue;
            startMin = start;
            first = false;
        }
        return startMin;
    }

    public double func_197758_c(Direction.Axis axis) {
        boolean first = true;
        double endMax = 0.0;
        for (VoxelShape shape : this) {
            double end = shape.func_197758_c(axis);
            if (!first && !(end > endMax)) continue;
            endMax = end;
            first = false;
        }
        return endMax;
    }

    public DoubleList func_197757_a(Direction.Axis axis) {
        DoubleArrayList values = new DoubleArrayList();
        for (VoxelShape shape : this) {
            values.addAll(shape.func_197757_a(axis));
        }
        return values;
    }

    public boolean func_197766_b() {
        for (VoxelShape shape : this) {
            if (shape.func_197766_b()) continue;
            return false;
        }
        return true;
    }

    public VoxelShape func_197751_a(double x, double y, double z) {
        ArrayList entries = Lists.newArrayList();
        for (Pair<VoxelShape, IComponent> entry : this.entries) {
            entries.add(Pair.of((Object)((VoxelShape)entry.getLeft()).func_197751_a(x, y, z), (Object)entry.getRight()));
        }
        return new VoxelShapeComponents(entries, this.stateId);
    }

    public void func_197754_a(VoxelShapes.ILineConsumer consumer) {
        for (VoxelShape shape : this) {
            shape.func_197754_a(consumer);
        }
    }

    public void func_197755_b(VoxelShapes.ILineConsumer consumer) {
        for (VoxelShape shape : this) {
            shape.func_197755_b(consumer);
        }
    }

    public double func_197760_b(Direction.Axis axis, double a, double b) {
        boolean first = true;
        double valueMax = 0.0;
        for (VoxelShape shape : this) {
            double value = shape.func_197760_b(axis, a, b);
            if (!first && !(value > valueMax)) continue;
            valueMax = value;
            first = false;
        }
        return valueMax;
    }

    public boolean func_211542_b(double x, double y, double z) {
        for (VoxelShape shape : this) {
            if (!shape.func_211542_b(x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public BlockRayTraceResultComponent rayTrace(Vector3d startVec, Vector3d endVec, BlockPos pos) {
        double distanceMin = Double.POSITIVE_INFINITY;
        IComponent componentMin = null;
        BlockRayTraceResult resultMin = null;
        for (Pair<VoxelShape, IComponent> entry : this.entries) {
            double distance;
            VoxelShape shape = (VoxelShape)entry.getLeft();
            BlockRayTraceResult result = shape.func_212433_a(startVec, endVec, pos);
            if (result == null || !((distance = result.func_216347_e().func_72436_e(startVec)) < distanceMin) || resultMin != null && ((IComponent)entry.getRight()).isRaytraceLastForFace() && componentMin.getRaytraceDirection() == result.func_216354_b()) continue;
            distanceMin = distance;
            componentMin = (IComponent)entry.getRight();
            resultMin = result;
        }
        if (resultMin != null) {
            return new BlockRayTraceResultComponent(resultMin, componentMin);
        }
        return null;
    }

    @Nullable
    public BlockRayTraceResultComponent rayTrace(BlockPos pos, @Nullable Entity entity) {
        if (entity == null) {
            return null;
        }
        ModifiableAttributeInstance reachDistanceAttribute = entity instanceof LivingEntity ? ((LivingEntity)entity).func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()) : null;
        double reachDistance = reachDistanceAttribute == null ? 5.0 : reachDistanceAttribute.func_111126_e();
        double eyeHeight = entity.func_130014_f_().func_201670_d() ? (double)entity.func_70047_e() : (double)entity.func_70047_e();
        Vector3d lookVec = entity.func_70040_Z();
        Vector3d origin = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + eyeHeight, entity.func_226281_cx_());
        Vector3d direction = origin.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
        return this.rayTrace(origin, direction, pos);
    }

    public double func_212431_a(AxisRotation rotation, AxisAlignedBB axisAlignedBB, double range) {
        boolean first = true;
        double valueBest = 0.0;
        for (VoxelShape shape : this) {
            double value = shape.func_212431_a(rotation, axisAlignedBB, range);
            if (range > 0.0) {
                if (!first && !(value < valueBest)) continue;
                valueBest = value;
                first = false;
                continue;
            }
            if (!first && !(value > valueBest)) continue;
            valueBest = value;
            first = false;
        }
        return valueBest;
    }

    public static interface IComponent {
        public String getStateId(BlockState var1, IBlockReader var2, BlockPos var3);

        public VoxelShape getShape(BlockState var1, IBlockReader var2, BlockPos var3, ISelectionContext var4);

        public ItemStack getPickBlock(World var1, BlockPos var2);

        public boolean destroy(World var1, BlockPos var2, PlayerEntity var3, boolean var4);

        @OnlyIn(value=Dist.CLIENT)
        @Nullable
        public IBakedModel getBreakingBaseModel(World var1, BlockPos var2);

        public ActionResultType onBlockActivated(BlockState var1, World var2, BlockPos var3, PlayerEntity var4, Hand var5, BlockRayTraceResultComponent var6);

        @Nullable
        public Direction getRaytraceDirection();

        public boolean isRaytraceLastForFace();
    }

    public static class Part
    extends VoxelShapePart
    implements Iterable<VoxelShapePart> {
        private final Collection<VoxelShapePart> entries;

        public Part(Collection<VoxelShapePart> entries) {
            super(0, 0, 0);
            this.entries = entries;
        }

        @Override
        public Iterator<VoxelShapePart> iterator() {
            return this.entries.iterator();
        }

        public boolean func_197818_c(int x, int y, int z) {
            for (VoxelShapePart part : this) {
                if (!part.func_197818_c(x, y, z)) continue;
                return true;
            }
            return false;
        }

        public boolean func_197835_b(int x, int y, int z) {
            for (VoxelShapePart part : this) {
                if (!part.func_197835_b(x, y, z)) continue;
                return true;
            }
            return false;
        }

        public void func_199625_a(int x, int y, int z, boolean b, boolean b1) {
            for (VoxelShapePart part : this) {
                part.func_199625_a(x, y, z, b, b1);
            }
        }

        public int func_199623_a(Direction.Axis axis) {
            boolean first = true;
            int startMin = 0;
            for (VoxelShapePart part : this) {
                int start = part.func_199623_a(axis);
                if (!first && start >= startMin) continue;
                startMin = start;
                first = false;
            }
            return startMin;
        }

        public int func_199624_b(Direction.Axis axis) {
            boolean first = true;
            int endMax = 0;
            for (VoxelShapePart part : this) {
                int end = part.func_199624_b(axis);
                if (!first && end <= endMax) continue;
                endMax = end;
                first = false;
            }
            return endMax;
        }

        public int func_197819_a(Direction.Axis axis) {
            boolean first = true;
            int sizeMax = 0;
            for (VoxelShapePart part : this) {
                int size = part.func_197819_a(axis);
                if (!first && size <= sizeMax) continue;
                sizeMax = size;
                first = false;
            }
            return sizeMax;
        }

        public void func_197831_b(VoxelShapePart.ILineConsumer consumer, boolean p_197831_2_) {
            for (VoxelShapePart part : this) {
                part.func_197831_b(consumer, p_197831_2_);
            }
        }
    }
}

