/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.Direction;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.PositionedOperatorRecipeHandler;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class PositionedOperatorRecipeHandlerRecipeByOutput<T extends IValueType<V>, V extends IValue>
extends PositionedOperatorRecipeHandler<T, V> {
    private static final Cache<Pair<Pair<DimPos, Direction>, ValueObjectTypeIngredients.ValueIngredients>, ValueObjectTypeRecipe.ValueRecipe> CACHE = CacheBuilder.newBuilder().expireAfterAccess(20L, TimeUnit.SECONDS).build();

    public PositionedOperatorRecipeHandlerRecipeByOutput(DimPos pos, Direction side) {
        super("recipebyoutput", new Function(), ValueTypes.OBJECT_RECIPE, pos, side);
    }

    public PositionedOperatorRecipeHandlerRecipeByOutput() {
        this(null, null);
    }

    public static class Function
    extends PositionedOperatorRecipeHandler.Function {
        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeIngredients.ValueIngredients ingredients = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            IRecipeHandler recipeHandler = (IRecipeHandler)this.getOperator().getRecipeHandler().orElse(null);
            if (recipeHandler != null && ingredients.getRawValue().isPresent()) {
                Pair key = Pair.of((Object)Pair.of((Object)this.getOperator().getPos(), (Object)this.getOperator().getSide()), (Object)ingredients);
                try {
                    return (IValue)this.getCache().get((Object)key, () -> {
                        IMixedIngredients givenIngredients = (IMixedIngredients)ingredients.getRawValue().get();
                        for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                            IMixedIngredients outputIngredients = this.getRecipeIngredients(recipe);
                            if (recipe.getInputComponents().size() <= 0 || recipe.getOutput().getComponents().size() <= 0 || !this.validateIngredients(outputIngredients, givenIngredients)) continue;
                            return ValueObjectTypeRecipe.ValueRecipe.of(recipe);
                        }
                        return ValueObjectTypeRecipe.ValueRecipe.of(null);
                    });
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_RECIPE, Collections.emptyList());
        }

        protected boolean validateIngredients(IMixedIngredients actualIngredients, IMixedIngredients givenIngredients) {
            return PositionedOperatorRecipeHandler.validateIngredientsPartial(actualIngredients, givenIngredients);
        }

        protected Cache<Pair<Pair<DimPos, Direction>, ValueObjectTypeIngredients.ValueIngredients>, ValueObjectTypeRecipe.ValueRecipe> getCache() {
            return CACHE;
        }

        protected IMixedIngredients getRecipeIngredients(IRecipeDefinition recipeDefinition) {
            return recipeDefinition.getOutput();
        }
    }
}

