/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonCheckbox;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeBoolean;
import org.cyclops.integrateddynamics.core.logicprogrammer.IRenderPatternValueTypeTooltip;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeBooleanValueChangedPacket;

@OnlyIn(value=Dist.CLIENT)
public class GuiElementValueTypeBooleanRenderPattern<S extends ISubGuiBox, G extends AbstractGui, C extends Container>
extends RenderPattern<GuiElementValueTypeBoolean<G, C>, G, C>
implements IRenderPatternValueTypeTooltip {
    protected final GuiElementValueTypeBoolean<G, C> element;
    private boolean renderTooltip = true;
    private ButtonCheckbox checkbox = null;

    public GuiElementValueTypeBooleanRenderPattern(GuiElementValueTypeBoolean<G, C> element, int baseX, int baseY, int maxWidth, int maxHeight, G gui, C container) {
        super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        this.element = element;
    }

    @Override
    public void init(int guiLeft, int guiTop) {
        super.init(guiLeft, guiTop);
        this.checkbox = new ButtonCheckbox(guiLeft + this.getX(), guiTop + this.getY(), ((GuiElementValueTypeBoolean)this.getElement()).getRenderPattern().getWidth(), ((GuiElementValueTypeBoolean)this.getElement()).getRenderPattern().getHeight(), (ITextComponent)new TranslationTextComponent(((GuiElementValueTypeBoolean)this.getElement()).getValueType().getTranslationKey()), entry -> this.onChecked(this.checkbox.isChecked()));
        boolean value = this.element.getInputBoolean();
        this.checkbox.setChecked(value);
    }

    @Override
    public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(matrixStack, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
        this.checkbox.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.checkbox.func_231044_a_(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isRenderTooltip() {
        return this.renderTooltip;
    }

    @Override
    public void setRenderTooltip(boolean renderTooltip) {
        this.renderTooltip = renderTooltip;
    }

    protected void onChecked(boolean checked) {
        if (this.container instanceof IDirtyMarkListener) {
            ((IDirtyMarkListener)this.container).onDirty();
        }
        ((GuiElementValueTypeBoolean)this.getElement()).setInputBoolean(checked);
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeBooleanValueChangedPacket(checked));
    }

    @Override
    public GuiElementValueTypeBoolean<G, C> getElement() {
        return this.element;
    }

    public ButtonCheckbox getCheckbox() {
        return this.checkbox;
    }
}

