/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainer;

public class ItemBlockEnergyContainerAutoSupply
extends ItemBlockEnergyContainer {
    public ItemBlockEnergyContainerAutoSupply(Block block, Item.Properties builder) {
        super(block, builder);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        L10NHelpers.addStatusInfo(list, (boolean)this.isActivated(itemStack), (String)(this.func_77658_a() + ".info.auto_supply"));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        return new ActionResult(ActionResultType.PASS, (Object)this.toggleActivation(player.func_184586_b(hand), world, player));
    }

    public static void autofill(IEnergyStorage source, World world, Entity entity) {
        int tickAmount;
        if (entity instanceof PlayerEntity && !world.func_201670_d() && (tickAmount = source.extractEnergy(Integer.MAX_VALUE, true)) > 0) {
            PlayerEntity player = (PlayerEntity)entity;
            for (Hand hand : Hand.values()) {
                ItemStack held = player.func_184586_b(hand);
                ItemStack filled = ItemBlockEnergyContainerAutoSupply.tryFillContainerForPlayer(source, held, tickAmount, player);
                if (filled.func_190926_b()) continue;
                player.func_184611_a(hand, filled);
            }
        }
    }

    public static ItemStack tryFillContainerForPlayer(IEnergyStorage source, ItemStack held, int tickAmount, PlayerEntity player) {
        return held.getCapability(CapabilityEnergy.ENERGY, null).map(target -> {
            int moved = target.receiveEnergy(source.extractEnergy(target.receiveEnergy(tickAmount, true), false), false);
            if (moved > 0) {
                return held;
            }
            return ItemStack.field_190927_a;
        }).orElse(ItemStack.field_190927_a);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean par5) {
        if (this.isActivated(itemStack)) {
            itemStack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(energyStorage -> ItemBlockEnergyContainerAutoSupply.autofill(energyStorage, world, entity));
        }
        super.func_77663_a(itemStack, world, entity, itemSlot, par5);
    }

    public ItemStack toggleActivation(ItemStack itemStack, World world, PlayerEntity player) {
        if (player.func_226563_dT_()) {
            if (!world.func_201670_d()) {
                ItemStack activated = itemStack.func_77946_l();
                activated.func_196085_b(1 - activated.func_77952_i());
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    public boolean isActivated(ItemStack itemStack) {
        return itemStack.func_77952_i() == 1;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return this.isActivated(itemStack);
    }
}

