/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class NetworkDiagnosticsPartOverlayRenderer {
    private static final NetworkDiagnosticsPartOverlayRenderer _INSTANCE = new NetworkDiagnosticsPartOverlayRenderer();
    private final Set<PartPos> partPositions = Sets.newHashSet();

    private NetworkDiagnosticsPartOverlayRenderer() {
    }

    public static NetworkDiagnosticsPartOverlayRenderer getInstance() {
        return _INSTANCE;
    }

    public synchronized void addPos(PartPos pos) {
        this.partPositions.add(pos);
    }

    public synchronized void removePos(PartPos pos) {
        this.partPositions.remove(pos);
    }

    public synchronized void clearPositions() {
        this.partPositions.clear();
    }

    public synchronized boolean hasPartPos(PartPos pos) {
        return this.partPositions.contains(pos);
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        if (!this.partPositions.isEmpty()) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            float partialTicks = event.getPartialTicks();
            double offsetX = player.field_70142_S + (player.func_226277_ct_() - player.field_70142_S) * (double)partialTicks;
            double offsetY = player.field_70137_T + (player.func_226278_cu_() - player.field_70137_T) * (double)partialTicks;
            double offsetZ = player.field_70136_U + (player.func_226281_cx_() - player.field_70136_U) * (double)partialTicks;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.lineWidth((float)6.0f);
            RenderSystem.disableTexture();
            RenderSystem.depthMask((boolean)false);
            ArrayList partList = Lists.newArrayList(this.partPositions);
            for (PartPos partPos : partList) {
                if (!partPos.getPos().getWorldKey().func_240901_a_().equals((Object)player.field_70170_p.func_234923_W_().func_240901_a_()) || !(partPos.getPos().getBlockPos().func_177951_i((Vector3i)player.func_233580_cy_()) < 10000.0)) continue;
                PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(partPos);
                VoxelShape shape = partStateHolder != null ? partStateHolder.getPart().getPartRenderPosition().getBoundingBox(partPos.getSide()) : VoxelShapes.field_197887_b;
                AxisAlignedBB bb = shape.func_197752_a().func_186670_a(partPos.getPos().getBlockPos()).func_72317_d(-offsetX, -offsetY, -offsetZ).func_72321_a(0.05, 0.05, 0.05).func_72321_a(-0.05, -0.05, -0.05);
                WorldRenderer.func_228430_a_((MatrixStack)event.getMatrixStack(), (IVertexBuilder)Minecraft.func_71410_x().func_228019_au_().func_228490_d_().getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)bb, (float)1.0f, (float)0.2f, (float)0.1f, (float)0.8f);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
        }
    }
}

