/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalDryingBasin;

public class RecipeSerializerMechanicalDryingBasin
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RecipeMechanicalDryingBasin> {
    public RecipeMechanicalDryingBasin read(ResourceLocation recipeId, JsonObject json) {
        JsonObject result = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        Ingredient inputIngredient = RecipeSerializerHelpers.getJsonIngredient((JsonObject)json, (String)"item", (boolean)false);
        FluidStack inputFluid = RecipeSerializerHelpers.getJsonFluidStack((JsonObject)json, (String)"fluid", (boolean)false);
        ItemStack outputItemStack = RecipeSerializerHelpers.getJsonItemStackOrTag((JsonObject)result, (boolean)false, GeneralConfig.recipeTagOutputModPriorities);
        FluidStack outputFluid = RecipeSerializerHelpers.getJsonFluidStack((JsonObject)result, (String)"fluid", (boolean)false);
        int duration = JSONUtils.func_151203_m((JsonObject)json, (String)"duration");
        if (inputIngredient.func_203189_d() && inputFluid.isEmpty()) {
            throw new JsonSyntaxException("An input item or fluid is required");
        }
        if (outputItemStack.func_190926_b() && outputFluid.isEmpty()) {
            throw new JsonSyntaxException("An output item or fluid is required");
        }
        if (!inputFluid.isEmpty() && !outputFluid.isEmpty()) {
            throw new JsonSyntaxException("Can't have both an input and output fluid");
        }
        if (duration <= 0) {
            throw new JsonSyntaxException("Durations must be higher than one tick");
        }
        return new RecipeMechanicalDryingBasin(recipeId, inputIngredient, inputFluid, outputItemStack, outputFluid, duration);
    }

    @Nullable
    public RecipeMechanicalDryingBasin read(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient inputIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        FluidStack inputFluid = FluidStack.readFromPacket((PacketBuffer)buffer);
        ItemStack outputItemStack = buffer.func_150791_c();
        FluidStack outputFluid = FluidStack.readFromPacket((PacketBuffer)buffer);
        int duration = buffer.func_150792_a();
        return new RecipeMechanicalDryingBasin(recipeId, inputIngredient, inputFluid, outputItemStack, outputFluid, duration);
    }

    public void write(PacketBuffer buffer, RecipeMechanicalDryingBasin recipe) {
        recipe.getInputIngredient().func_199564_a(buffer);
        recipe.getInputFluid().writeToPacket(buffer);
        buffer.func_150788_a(recipe.getOutputItem());
        recipe.getOutputFluid().writeToPacket(buffer);
        buffer.func_150787_b(recipe.getDuration());
    }
}

