/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.entity.item;

import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;

public class EntityItemTargetted
extends ItemEntity {
    private static final DataParameter<Float> TARGET_X = EntityDataManager.func_187226_a(EntityItemTargetted.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> TARGET_Y = EntityDataManager.func_187226_a(EntityItemTargetted.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> TARGET_Z = EntityDataManager.func_187226_a(EntityItemTargetted.class, (IDataSerializer)DataSerializers.field_187193_c);
    private LivingEntity targetEntity = null;

    public EntityItemTargetted(EntityType<? extends EntityItemTargetted> entityType, World world) {
        super(entityType, world);
        this.lifespan = Integer.MAX_VALUE;
    }

    public EntityItemTargetted(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.lifespan = Integer.MAX_VALUE;
    }

    public EntityItemTargetted(World world, double x, double y, double z, ItemStack itemStack) {
        super(world, x, y, z, itemStack);
        this.lifespan = Integer.MAX_VALUE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TARGET_X, (Object)Float.valueOf((float)this.func_226278_cu_()));
        this.func_184212_Q().func_187214_a(TARGET_Y, (Object)Float.valueOf((float)this.func_226278_cu_()));
        this.func_184212_Q().func_187214_a(TARGET_Z, (Object)Float.valueOf((float)this.func_226278_cu_()));
        this.func_189654_d(true);
    }

    public void setTarget(float x, float y, float z) {
        this.func_184212_Q().func_187227_b(TARGET_X, (Object)Float.valueOf(x));
        this.func_184212_Q().func_187227_b(TARGET_Y, (Object)Float.valueOf(y));
        this.func_184212_Q().func_187227_b(TARGET_Z, (Object)Float.valueOf(z));
    }

    public void setTarget(LivingEntity targetEntity) {
        this.targetEntity = targetEntity;
        this.setTarget((float)targetEntity.func_226277_ct_(), (float)targetEntity.func_226278_cu_(), (float)targetEntity.func_226281_cx_());
    }

    public float getTargetX() {
        return ((Float)this.func_184212_Q().func_187225_a(TARGET_X)).floatValue();
    }

    public float getTargetY() {
        return ((Float)this.func_184212_Q().func_187225_a(TARGET_Y)).floatValue();
    }

    public float getTargetZ() {
        return ((Float)this.func_184212_Q().func_187225_a(TARGET_Z)).floatValue();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.targetEntity != null) {
            this.setTarget((float)this.targetEntity.func_226277_ct_(), (float)this.targetEntity.func_226278_cu_(), (float)this.targetEntity.func_226281_cx_());
        }
        double dx = this.func_226277_ct_() - (double)this.getTargetX();
        double dy = this.func_226278_cu_() - (double)(this.getTargetY() + 1.0f);
        double dz = this.func_226281_cx_() - (double)this.getTargetZ();
        double strength = -0.1;
        double d = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
        if (d > 1.0) {
            double m = 1.0 / (2.0 * Math.max(1.0, d)) * strength;
            this.func_213293_j(dx *= m, dy *= m, dz *= m);
            if (this.field_70123_F) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, 0.3, this.func_213322_ci().field_72449_c);
            }
        }
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.showEntityMoved();
        }
    }

    protected void showEntityMoved() {
        Random rand = this.field_70170_p.field_73012_v;
        float scale = 0.1f;
        float red = rand.nextFloat() * 0.2f + 0.8f;
        float green = rand.nextFloat() * 0.2f + 0.8f;
        float blue = rand.nextFloat() * 0.1f + 0.1f;
        float ageMultiplier = (float)(rand.nextDouble() * 25.0 + 50.0);
        ((ServerWorld)this.func_130014_f_()).func_195598_a((IParticleData)new ParticleBlurData(red, green, blue, scale, ageMultiplier), this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 1, 0.1 - (double)rand.nextFloat() * 0.2, 0.1 - (double)rand.nextFloat() * 0.2, 0.1 - (double)rand.nextFloat() * 0.2, 0.0);
        if (rand.nextInt(5) == 0) {
            double dx = this.func_226277_ct_() - (double)(this.getTargetX() + 0.5f);
            double dy = this.func_226278_cu_() - (double)(this.getTargetY() + 1.0f);
            double dz = this.func_226281_cx_() - (double)(this.getTargetZ() + 0.5f);
            double factor = rand.nextDouble();
            double x = this.func_226277_ct_() - dx * factor;
            double y = this.func_226278_cu_() - dy * factor;
            double z = this.func_226281_cx_() - dz * factor;
            ((ServerWorld)this.func_130014_f_()).func_195598_a((IParticleData)new ParticleBlurData(red, green, blue, scale, ageMultiplier), x, y, z, 1, -0.02 * dx, -0.02 * dy, -0.02 * dz, 0.0);
        }
    }
}

