/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.part.aspect;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerAspectSettings;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;

public abstract class AspectBase<V extends IValue, T extends IValueType<V>>
implements IAspect<V, T> {
    private final IAspectProperties defaultProperties;
    private final ModBase mod;
    private String translationKey = null;

    public AspectBase(ModBase mod, IAspectProperties defaultProperties) {
        this.mod = mod;
        this.defaultProperties = defaultProperties == null ? this.createDefaultProperties() : defaultProperties;
    }

    @Override
    public ResourceLocation getUniqueName() {
        return new ResourceLocation(this.getModId(), this.getUnlocalizedType().replaceAll("\\.", "_"));
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey != null ? this.translationKey : (this.translationKey = this.getUnlocalizedPrefix());
    }

    protected String getUnlocalizedPrefix() {
        return "aspect." + this.getModId() + "." + this.getUnlocalizedType();
    }

    protected abstract String getUnlocalizedType();

    @Override
    public void loadTooltip(List<ITextComponent> lines, boolean appendOptionalInfo) {
        TranslationTextComponent aspectName = new TranslationTextComponent(this.getTranslationKey());
        TranslationTextComponent valueTypeName = new TranslationTextComponent(this.getValueType().getTranslationKey());
        lines.add((ITextComponent)new TranslationTextComponent("aspect.integrateddynamics.tooltip.aspect_name", new Object[]{aspectName}));
        lines.add((ITextComponent)new TranslationTextComponent("aspect.integrateddynamics.tooltip.value_type_name", new Object[]{valueTypeName}).func_240699_a_(this.getValueType().getDisplayColorFormat()));
        if (appendOptionalInfo) {
            L10NHelpers.addOptionalInfo(lines, (String)this.getUnlocalizedPrefix());
        }
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> boolean hasProperties() {
        return this.getDefaultProperties() != null;
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> IAspectProperties getProperties(P partType, PartTarget target, S state) {
        IAspectProperties properties = state.getAspectProperties(this);
        if (properties == null) {
            properties = this.getDefaultProperties().clone();
            this.setProperties(partType, target, state, properties);
        }
        return properties;
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> void setProperties(P partType, PartTarget target, S state, IAspectProperties properties) {
        state.setAspectProperties(this, properties);
    }

    @Override
    public final IAspectProperties getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public Collection<IAspectPropertyTypeInstance> getPropertyTypes() {
        return this.hasProperties() ? this.getDefaultProperties().getTypes() : Collections.emptyList();
    }

    @Override
    public INamedContainerProvider getPropertiesContainerProvider(final PartPos pos) {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("gui.integrateddynamics.aspect_settings");
            }

            @Nullable
            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                Triple<IPartContainer, PartTypeBase, PartTarget> data = PartHelpers.getContainerPartConstructionData(pos);
                return new ContainerAspectSettings(id, playerInventory, (IInventory)new Inventory(0), Optional.of(data.getRight()), Optional.of(data.getLeft()), Optional.of(data.getMiddle()), AspectBase.this);
            }
        };
    }

    @Deprecated
    protected IAspectProperties createDefaultProperties() {
        return null;
    }

    protected ModBase getMod() {
        return this.mod;
    }

    protected String getModId() {
        return this.getMod().getModId();
    }
}

