/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.hash;

import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import malte0811.ferritecore.mixin.blockstatecache.VSPBitSetAccess;
import malte0811.ferritecore.mixin.blockstatecache.VSPSplitAccess;
import malte0811.ferritecore.mixin.blockstatecache.VSPartAccess;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.PartSplitVoxelShape;
import net.minecraft.util.math.shapes.VoxelShapePart;

public class VoxelShapePartHash
implements Hash.Strategy<VoxelShapePart> {
    public static final VoxelShapePartHash INSTANCE = new VoxelShapePartHash();

    public int hashCode(VoxelShapePart o) {
        VSPartAccess generalAccess = (VSPartAccess)o;
        int result = generalAccess.getXSize();
        result = 31 * result + generalAccess.getYSize();
        result = 31 * result + generalAccess.getZSize();
        if (o instanceof PartSplitVoxelShape) {
            VSPSplitAccess access = VoxelShapePartHash.access((PartSplitVoxelShape)o);
            result = 31 * result + access.getStartX();
            result = 31 * result + access.getStartY();
            result = 31 * result + access.getStartZ();
            result = 31 * result + access.getEndX();
            result = 31 * result + access.getEndY();
            result = 31 * result + access.getEndZ();
            result = 31 * result + this.hashCode(access.getParent());
            return result;
        }
        if (o instanceof BitSetVoxelShapePart) {
            VSPBitSetAccess access = VoxelShapePartHash.access((BitSetVoxelShapePart)o);
            result = 31 * result + access.getXMin();
            result = 31 * result + access.getYMin();
            result = 31 * result + access.getZMin();
            result = 31 * result + access.getXMax();
            result = 31 * result + access.getYMax();
            result = 31 * result + access.getZMax();
            result = 31 * result + Objects.hashCode(access.getStorage());
            return result;
        }
        return 31 * result + Objects.hashCode(o);
    }

    public boolean equals(VoxelShapePart a, VoxelShapePart b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        VSPartAccess genAccessA = (VSPartAccess)a;
        VSPartAccess genAccessB = (VSPartAccess)b;
        if (genAccessA.getXSize() != genAccessB.getXSize() || genAccessA.getYSize() != genAccessB.getYSize() || genAccessA.getZSize() != genAccessB.getZSize()) {
            return false;
        }
        if (a instanceof PartSplitVoxelShape) {
            VSPSplitAccess accessA = VoxelShapePartHash.access((PartSplitVoxelShape)a);
            VSPSplitAccess accessB = VoxelShapePartHash.access((PartSplitVoxelShape)b);
            return accessA.getEndX() == accessB.getEndX() && accessA.getEndY() == accessB.getEndY() && accessA.getEndZ() == accessB.getEndZ() && accessA.getStartX() == accessB.getStartX() && accessA.getStartY() == accessB.getStartY() && accessA.getStartZ() == accessB.getStartZ() && this.equals(accessA.getParent(), accessB.getParent());
        }
        if (a instanceof BitSetVoxelShapePart) {
            VSPBitSetAccess accessA = VoxelShapePartHash.access((BitSetVoxelShapePart)a);
            VSPBitSetAccess accessB = VoxelShapePartHash.access((BitSetVoxelShapePart)b);
            return accessA.getXMax() == accessB.getXMax() && accessA.getYMax() == accessB.getYMax() && accessA.getZMax() == accessB.getZMax() && accessA.getXMin() == accessB.getXMin() && accessA.getYMin() == accessB.getYMin() && accessA.getZMin() == accessB.getZMin() && accessA.getStorage().equals(accessB.getStorage());
        }
        return a.equals(b);
    }

    private static VSPSplitAccess access(PartSplitVoxelShape part) {
        return (VSPSplitAccess)part;
    }

    private static VSPBitSetAccess access(BitSetVoxelShapePart part) {
        return (VSPBitSetAccess)part;
    }
}

