/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei;

import com.buuz135.industrial.api.recipe.ore.OreFluidEntryFermenter;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntryRaw;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntrySieve;
import com.buuz135.industrial.block.generator.MycelialGeneratorBlock;
import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.block.generator.tile.BioReactorTile;
import com.buuz135.industrial.block.resourceproduction.tile.MaterialStoneWorkFactoryTile;
import com.buuz135.industrial.fluid.OreTitaniumFluidAttributes;
import com.buuz135.industrial.gui.conveyor.GuiConveyor;
import com.buuz135.industrial.gui.transporter.GuiTransporter;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.plugin.jei.category.BioReactorRecipeCategory;
import com.buuz135.industrial.plugin.jei.category.DissolutionChamberCategory;
import com.buuz135.industrial.plugin.jei.category.FermentationStationCategory;
import com.buuz135.industrial.plugin.jei.category.FluidExtractorCategory;
import com.buuz135.industrial.plugin.jei.category.FluidSieveCategory;
import com.buuz135.industrial.plugin.jei.category.LaserDrillFluidCategory;
import com.buuz135.industrial.plugin.jei.category.LaserDrillOreCategory;
import com.buuz135.industrial.plugin.jei.category.OreWasherCategory;
import com.buuz135.industrial.plugin.jei.category.StoneWorkCategory;
import com.buuz135.industrial.plugin.jei.category.StoneWorkGeneratorCategory;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorCategory;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.plugin.jei.machineproduce.MachineProduceCategory;
import com.buuz135.industrial.plugin.jei.machineproduce.MachineProduceWrapper;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.recipe.FluidExtractorRecipe;
import com.buuz135.industrial.recipe.LaserDrillFluidRecipe;
import com.buuz135.industrial.recipe.LaserDrillOreRecipe;
import com.buuz135.industrial.recipe.StoneWorkGenerateRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.util.RecipeUtil;
import com.hrznstudio.titanium.util.TagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

@JeiPlugin
public class JEICustomPlugin
implements IModPlugin {
    private static IRecipesGui recipesGui;
    private BioReactorRecipeCategory bioReactorRecipeCategory;
    private LaserDrillOreCategory laserRecipeOreCategory;
    private LaserDrillFluidCategory laserDrillFluidCategory;
    private FluidExtractorCategory fluidExtractorCategory;
    private DissolutionChamberCategory dissolutionChamberJEICategory;
    private List<MycelialGeneratorCategory> mycelialGeneratorCategories;
    private StoneWorkCategory stoneWorkCategory;
    private MachineProduceCategory machineProduceCategory;
    private StoneWorkGeneratorCategory stoneWorkGeneratorCategory;
    private OreWasherCategory oreWasherCategory;
    private FermentationStationCategory fermentationStationCategory;
    private FluidSieveCategory fluidSieveCategory;

    public static void showUses(ItemStack stack) {
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{ModuleTool.INFINITY_DRILL, ModuleTool.INFINITY_SAW, ModuleTool.INFINITY_HAMMER, ModuleTool.INFINITY_TRIDENT, ModuleTool.INFINITY_BACKPACK, ModuleTool.INFINITY_LAUNCHER, ModuleTool.INFINITY_NUKE, ModuleCore.EFFICIENCY_ADDON_1, ModuleCore.EFFICIENCY_ADDON_2, ModuleCore.SPEED_ADDON_1, ModuleCore.SPEED_ADDON_2, ModuleCore.PROCESSING_ADDON_1, ModuleCore.PROCESSING_ADDON_2});
        registration.useNbtForSubtypes((Item[])ModuleCore.RANGE_ADDONS);
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(GuiConveyor.class, (IGhostIngredientHandler)new IGhostIngredientHandler<GuiConveyor>(){

            public <I> List<IGhostIngredientHandler.Target<I>> getTargets(GuiConveyor guiConveyor, I i, boolean b) {
                if (i instanceof ItemStack) {
                    return guiConveyor.getGhostSlots().stream().map(ghostSlot -> new IGhostIngredientHandler.Target<I>((IFilter.GhostSlot)ghostSlot){
                        final /* synthetic */ IFilter.GhostSlot val$ghostSlot;
                        {
                            this.val$ghostSlot = ghostSlot;
                        }

                        public Rectangle2d getArea() {
                            return this.val$ghostSlot.getArea();
                        }

                        public void accept(I stack) {
                            this.val$ghostSlot.accept((ItemStack)stack);
                        }
                    }).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }

            public void onComplete() {
            }
        });
        registration.addGhostIngredientHandler(GuiTransporter.class, (IGhostIngredientHandler)new IGhostIngredientHandler<GuiTransporter>(){

            public <I> List<IGhostIngredientHandler.Target<I>> getTargets(GuiTransporter guiConveyor, I i, boolean b) {
                if (i instanceof ItemStack) {
                    return guiConveyor.getGhostSlots().stream().map(ghostSlot -> new IGhostIngredientHandler.Target<I>((IFilter.GhostSlot)ghostSlot){
                        final /* synthetic */ IFilter.GhostSlot val$ghostSlot;
                        {
                            this.val$ghostSlot = ghostSlot;
                        }

                        public Rectangle2d getArea() {
                            return this.val$ghostSlot.getArea();
                        }

                        public void accept(I stack) {
                            this.val$ghostSlot.accept((ItemStack)stack);
                        }
                    }).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }

            public void onComplete() {
            }
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.bioReactorRecipeCategory = new BioReactorRecipeCategory(registry.getJeiHelpers().getGuiHelper(), "Bioreactor accepted items");
        registry.addRecipeCategories(new IRecipeCategory[]{this.bioReactorRecipeCategory});
        this.fluidExtractorCategory = new FluidExtractorCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.fluidExtractorCategory});
        this.dissolutionChamberJEICategory = new DissolutionChamberCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.dissolutionChamberJEICategory});
        this.laserRecipeOreCategory = new LaserDrillOreCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.laserRecipeOreCategory});
        this.laserDrillFluidCategory = new LaserDrillFluidCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.laserDrillFluidCategory});
        this.mycelialGeneratorCategories = new ArrayList<MycelialGeneratorCategory>();
        for (IMycelialGeneratorType type : IMycelialGeneratorType.TYPES) {
            MycelialGeneratorCategory category = new MycelialGeneratorCategory(type, registry.getJeiHelpers().getGuiHelper());
            this.mycelialGeneratorCategories.add(category);
            registry.addRecipeCategories(new IRecipeCategory[]{category});
        }
        this.stoneWorkCategory = new StoneWorkCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.stoneWorkCategory});
        this.machineProduceCategory = new MachineProduceCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.machineProduceCategory});
        this.stoneWorkGeneratorCategory = new StoneWorkGeneratorCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.stoneWorkGeneratorCategory});
        this.oreWasherCategory = new OreWasherCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.oreWasherCategory});
        this.fermentationStationCategory = new FermentationStationCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.fermentationStationCategory});
        this.fluidSieveCategory = new FluidSieveCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.fluidSieveCategory});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeUtil.getRecipes((World)Minecraft.func_71410_x().field_71441_e, (IRecipeType)FluidExtractorRecipe.SERIALIZER.getRecipeType()), this.fluidExtractorCategory.getUid());
        registration.addRecipes(RecipeUtil.getRecipes((World)Minecraft.func_71410_x().field_71441_e, (IRecipeType)DissolutionChamberRecipe.SERIALIZER.getRecipeType()), this.dissolutionChamberJEICategory.getUid());
        registration.addRecipes(this.generateBioreactorRecipes(), this.bioReactorRecipeCategory.getUid());
        registration.addRecipes((Collection)RecipeUtil.getRecipes((World)Minecraft.func_71410_x().field_71441_e, (IRecipeType)LaserDrillOreRecipe.SERIALIZER.getRecipeType()).stream().filter(laserDrillOreRecipe -> !laserDrillOreRecipe.output.func_203189_d()).collect(Collectors.toList()), this.laserRecipeOreCategory.getUid());
        registration.addRecipes(RecipeUtil.getRecipes((World)Minecraft.func_71410_x().field_71441_e, (IRecipeType)LaserDrillFluidRecipe.SERIALIZER.getRecipeType()), this.laserDrillFluidCategory.getUid());
        for (int i = 0; i < IMycelialGeneratorType.TYPES.size(); ++i) {
            registration.addRecipes((Collection)IMycelialGeneratorType.TYPES.get(i).getRecipes().stream().sorted(Comparator.comparingInt(value -> ((MycelialGeneratorRecipe)value).getTicks() * ((MycelialGeneratorRecipe)value).getPowerTick()).reversed()).collect(Collectors.toList()), this.mycelialGeneratorCategories.get(i).getUid());
        }
        ArrayList<StoneWorkCategory.Wrapper> perfectStoneWorkWrappers = new ArrayList<StoneWorkCategory.Wrapper>();
        for (StoneWorkGenerateRecipe generatorRecipe : RecipeUtil.getRecipes((World)Minecraft.func_71410_x().field_71441_e, (IRecipeType)StoneWorkGenerateRecipe.SERIALIZER.getRecipeType())) {
            List<StoneWorkCategory.Wrapper> wrappers = this.findAllStoneWorkOutputs(generatorRecipe.output, new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>());
            for (StoneWorkCategory.Wrapper workWrapper : new ArrayList<StoneWorkCategory.Wrapper>(wrappers)) {
                if (!perfectStoneWorkWrappers.stream().noneMatch(stoneWorkWrapper -> workWrapper.getOutput().func_77969_a(stoneWorkWrapper.getOutput()))) continue;
                boolean isSomoneShorter = false;
                for (StoneWorkCategory.Wrapper workWrapperCompare : new ArrayList<StoneWorkCategory.Wrapper>(wrappers)) {
                    if (!workWrapper.getOutput().func_77969_a(workWrapperCompare.getOutput())) continue;
                    ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction> workWrapperCompareModes = new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(workWrapperCompare.getModes());
                    workWrapperCompareModes.removeIf(mode -> mode.getAction().equalsIgnoreCase("none"));
                    ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction> workWrapperModes = new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(workWrapper.getModes());
                    workWrapperModes.removeIf(mode -> mode.getAction().equalsIgnoreCase("none"));
                    if (workWrapperModes.size() <= workWrapperCompareModes.size()) continue;
                    isSomoneShorter = true;
                    break;
                }
                if (isSomoneShorter) continue;
                perfectStoneWorkWrappers.add(workWrapper);
            }
        }
        registration.addRecipes(perfectStoneWorkWrappers, this.stoneWorkCategory.getUid());
        registration.addRecipes(Arrays.asList(new MachineProduceWrapper((Block)ModuleCore.LATEX_PROCESSING, new ItemStack((IItemProvider)ModuleCore.TINY_DRY_RUBBER)), new MachineProduceWrapper((Block)ModuleResourceProduction.SLUDGE_REFINER, IndustrialTags.Items.SLUDGE_OUTPUT), new MachineProduceWrapper((Block)ModuleAgricultureHusbandry.SEWAGE_COMPOSTER, new ItemStack((IItemProvider)ModuleCore.FERTILIZER)), new MachineProduceWrapper((Block)ModuleResourceProduction.DYE_MIXER, (ITag<Item>)Tags.Items.DYES), new MachineProduceWrapper((Block)ModuleResourceProduction.SPORES_RECREATOR, (ITag<Item>)Tags.Items.MUSHROOMS), new MachineProduceWrapper((Block)ModuleResourceProduction.SPORES_RECREATOR, new ItemStack((IItemProvider)Items.field_234722_bw_), new ItemStack((IItemProvider)Items.field_234723_bx_)), new MachineProduceWrapper((Block)ModuleAgricultureHusbandry.MOB_CRUSHER, new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid(), 1000)), new MachineProduceWrapper((Block)ModuleAgricultureHusbandry.SLAUGHTER_FACTORY, new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid(), 1000)), new MachineProduceWrapper((Block)ModuleAgricultureHusbandry.SLAUGHTER_FACTORY, new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid(), 1000)), new MachineProduceWrapper((Block)ModuleAgricultureHusbandry.ANIMAL_RANCHER, new FluidStack((Fluid)ForgeMod.MILK.get(), 1000)), new MachineProduceWrapper((Block)ModuleAgricultureHusbandry.SEWER, new FluidStack((Fluid)ModuleCore.SEWAGE.getSourceFluid(), 1000)), new MachineProduceWrapper((Block)ModuleAgricultureHusbandry.PLANT_GATHERER, new FluidStack((Fluid)ModuleCore.SLUDGE.getSourceFluid(), 1000)), new MachineProduceWrapper((Block)ModuleResourceProduction.WATER_CONDENSATOR, new FluidStack((Fluid)Fluids.field_204546_a, 1000))), this.machineProduceCategory.getUid());
        registration.addRecipes(RecipeUtil.getRecipes((World)Minecraft.func_71410_x().field_71441_e, (IRecipeType)StoneWorkGenerateRecipe.SERIALIZER.getRecipeType()), this.stoneWorkGeneratorCategory.getUid());
        ArrayList washer = new ArrayList();
        ArrayList fluidEntryFermenters = new ArrayList();
        ArrayList fluidSieve = new ArrayList();
        TagCollectionManager.func_242178_a().func_241836_b().func_199908_a().stream().filter(resourceLocation -> resourceLocation.toString().startsWith("forge:ores/") && OreTitaniumFluidAttributes.isValid(resourceLocation)).forEach(resourceLocation -> {
            ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_241834_b(resourceLocation);
            ITag dust = TagCollectionManager.func_242178_a().func_241836_b().func_241834_b(new ResourceLocation(resourceLocation.toString().replace("forge:ores/", "forge:dusts/")));
            washer.add(new OreFluidEntryRaw((ITag<Item>)tag, new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid(), 100), OreTitaniumFluidAttributes.getFluidWithTag(ModuleCore.RAW_ORE_MEAT, 100, resourceLocation)));
            fluidEntryFermenters.add(new OreFluidEntryFermenter(OreTitaniumFluidAttributes.getFluidWithTag(ModuleCore.RAW_ORE_MEAT, 100, resourceLocation), OreTitaniumFluidAttributes.getFluidWithTag(ModuleCore.FERMENTED_ORE_MEAT, 200, resourceLocation)));
            fluidSieve.add(new OreFluidEntrySieve(OreTitaniumFluidAttributes.getFluidWithTag(ModuleCore.FERMENTED_ORE_MEAT, 100, resourceLocation), TagUtil.getItemWithPreference((ITag)dust), (ITag<Item>)ItemTags.field_203440_u));
        });
        registration.addRecipes(washer, this.oreWasherCategory.getUid());
        registration.addRecipes(fluidEntryFermenters, this.fermentationStationCategory.getUid());
        registration.addRecipes(fluidSieve, this.fluidSieveCategory.getUid());
    }

    private List<BioReactorRecipeCategory.ReactorRecipeWrapper> generateBioreactorRecipes() {
        ArrayList<BioReactorRecipeCategory.ReactorRecipeWrapper> recipes = new ArrayList<BioReactorRecipeCategory.ReactorRecipeWrapper>();
        for (ITag<Item> itemTag : BioReactorTile.VALID) {
            recipes.add(new BioReactorRecipeCategory.ReactorRecipeWrapper(itemTag, new FluidStack((Fluid)ModuleCore.BIOFUEL.getSourceFluid(), 80)));
        }
        return recipes;
    }

    public ItemStack getStoneWorkOutputFrom(ItemStack stack, MaterialStoneWorkFactoryTile.StoneWorkAction mode) {
        return mode.getWork().apply((World)Minecraft.func_71410_x().field_71441_e, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)9));
    }

    public ItemStack getStoneWorkOutputFrom(ItemStack stack, List<MaterialStoneWorkFactoryTile.StoneWorkAction> modes) {
        for (MaterialStoneWorkFactoryTile.StoneWorkAction mode : modes) {
            if (!(stack = this.getStoneWorkOutputFrom(stack.func_77946_l(), mode)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public List<StoneWorkCategory.Wrapper> findAllStoneWorkOutputs(ItemStack parent, List<MaterialStoneWorkFactoryTile.StoneWorkAction> usedModes) {
        ArrayList<StoneWorkCategory.Wrapper> wrappers = new ArrayList<StoneWorkCategory.Wrapper>();
        if (usedModes.size() >= 4) {
            return wrappers;
        }
        for (MaterialStoneWorkFactoryTile.StoneWorkAction mode : MaterialStoneWorkFactoryTile.ACTION_RECIPES) {
            if (mode.getAction().equals("none")) continue;
            ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction> usedModesInternal = new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(usedModes);
            usedModesInternal.add(mode);
            ItemStack output = this.getStoneWorkOutputFrom(parent, new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(usedModesInternal));
            if (output.func_190926_b()) continue;
            wrappers.add(new StoneWorkCategory.Wrapper(parent, new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(usedModesInternal), output.func_77946_l()));
            wrappers.addAll(this.findAllStoneWorkOutputs(parent, new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(usedModesInternal)));
        }
        return wrappers;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleCore.FLUID_EXTRACTOR), new ResourceLocation[]{FluidExtractorCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleCore.DISSOLUTION_CHAMBER), new ResourceLocation[]{DissolutionChamberCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleGenerator.BIOREACTOR), new ResourceLocation[]{BioReactorRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.ORE_LASER_BASE), new ResourceLocation[]{LaserDrillOreCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.LASER_DRILL), new ResourceLocation[]{LaserDrillOreCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.FLUID_LASER_BASE), new ResourceLocation[]{LaserDrillFluidCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.LASER_DRILL), new ResourceLocation[]{LaserDrillFluidCategory.ID});
        for (MycelialGeneratorBlock mycelialGenerator : ModuleGenerator.MYCELIAL_GENERATORS) {
            for (MycelialGeneratorCategory mycelialGeneratorCategory : this.mycelialGeneratorCategories) {
                if (!mycelialGenerator.getType().equals(mycelialGeneratorCategory.getType())) continue;
                registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)mycelialGenerator), new ResourceLocation[]{mycelialGeneratorCategory.getUid()});
            }
        }
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.MATERIAL_STONEWORK_FACTORY), new ResourceLocation[]{this.stoneWorkCategory.getUid(), this.stoneWorkGeneratorCategory.getUid()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.POTION_BREWER), new ResourceLocation[]{VanillaRecipeCategoryUid.BREWING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleMisc.ENCHANTMENT_APPLICATOR), new ResourceLocation[]{VanillaRecipeCategoryUid.ANVIL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.RESOURCEFUL_FURNACE), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.WASHING_FACTORY), new ResourceLocation[]{OreWasherCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.FERMENTATION_STATION), new ResourceLocation[]{FermentationStationCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModuleResourceProduction.FLUID_SIEVING_MACHINE), new ResourceLocation[]{FluidSieveCategory.ID});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("industrialforegoing", "default");
    }
}

