/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.apihandlers.plant.ChorusCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ChorusFruitRecollectable
extends PlantRecollectable {
    private final HashMap<BlockPos, ChorusCache> chorusCacheHashMap = new HashMap();

    public ChorusFruitRecollectable() {
        super("chorus_fruit");
    }

    @Override
    public boolean canBeHarvested(World world, BlockPos pos, BlockState blockState) {
        ChorusCache chorusCache;
        if (this.chorusCacheHashMap.containsKey(pos)) {
            return true;
        }
        if (BlockUtils.isChorus(world, pos) && (chorusCache = new ChorusCache(world, pos)).isFullyGrown()) {
            this.chorusCacheHashMap.put(pos, chorusCache);
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> doHarvestOperation(World world, BlockPos pos, BlockState blockState) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.chorusCacheHashMap.containsKey(pos)) {
            ChorusCache chorusCache = this.chorusCacheHashMap.get(pos);
            stacks.addAll(chorusCache.chop());
            if (chorusCache.getChorus().isEmpty()) {
                this.chorusCacheHashMap.remove(pos);
            }
        }
        return stacks;
    }

    @Override
    public boolean shouldCheckNextPlant(World world, BlockPos pos, BlockState blockState) {
        return !this.canBeHarvested(world, pos, blockState);
    }

    @Override
    public List<String> getRecollectablesNames() {
        return Arrays.asList("text.industrialforegoing.plant.chorus");
    }
}

