/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.explosion;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.explosion.ExplosionTickHandler;
import com.buuz135.industrial.utils.explosion.ShortPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;

public class ExplosionHelper {
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private final ServerWorld serverWorld;
    public LinkedList<HashSet<Integer>> toRemove = new LinkedList();
    private BlockPos start;
    private ShortPos shortPos;
    private HashSet<Integer> blocksToUpdate = new HashSet();
    private HashSet<Integer> lightUpdates = new HashSet();
    private HashSet<Integer> tilesToRemove = new HashSet();
    private HashMap<ChunkPos, Chunk> chunkCache = new HashMap();

    public ExplosionHelper(ServerWorld serverWorld, BlockPos start, ShortPos shortPos) {
        this.serverWorld = serverWorld;
        this.start = start;
        this.shortPos = shortPos;
    }

    public void setBlocksForRemoval(LinkedList<HashSet<Integer>> list) {
        this.toRemove = list;
    }

    public void addBlocksForUpdate(Collection<Integer> blocksToUpdate) {
        this.blocksToUpdate.addAll(blocksToUpdate);
    }

    private Chunk removeBlock(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        BlockState oldState = chunk.func_180495_p(pos);
        if (oldState.func_177230_c().hasTileEntity(oldState)) {
            this.serverWorld.func_217377_a(pos, false);
            this.serverWorld.func_225524_e_().func_215568_a(pos);
            return chunk;
        }
        ChunkSection storage = this.getBlockStorage(pos);
        if (storage != null) {
            storage.func_222629_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, AIR);
        }
        this.setChunkModified(pos);
        this.serverWorld.func_225524_e_().func_215568_a(pos);
        return chunk;
    }

    public void setChunkModified(BlockPos blockPos) {
        Chunk chunk = this.getChunk(blockPos);
        this.setChunkModified(chunk);
    }

    public void setChunkModified(Chunk chunk) {
    }

    private Chunk getChunk(BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        if (!this.chunkCache.containsKey(cp)) {
            this.chunkCache.put(cp, this.serverWorld.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4));
        }
        return this.chunkCache.get(cp);
    }

    private ChunkSection getBlockStorage(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        return chunk.func_76587_i()[pos.func_177956_o() >> 4];
    }

    public void finish() {
        IndustrialForegoing.LOGGER.debug("EH: finish");
        RemovalProcess process = new RemovalProcess(this);
        ExplosionTickHandler.removalProcessList.add(process);
    }

    public boolean isAirBlock(BlockPos pos) {
        return this.serverWorld.func_175623_d(pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        ChunkSection storage = this.getBlockStorage(pos);
        if (storage == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return storage.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
    }

    public static class RemovalProcess {
        public boolean isDead = false;
        int index = 0;
        private ExplosionHelper helper;
        private MinecraftServer server;
        private int blocksToUpdatePointer = 0;
        private List<Integer> blocksToRmv = new ArrayList<Integer>();
        private long start;

        public RemovalProcess(ExplosionHelper helper) {
            this.helper = helper;
            this.server = helper.serverWorld.func_73046_m();
            this.start = System.currentTimeMillis();
        }

        public void updateProcess() {
            long startTime = Util.func_211177_b();
            HashSet<Chunk> chunks = new HashSet<Chunk>();
            while (Util.func_211177_b() - startTime < 40L && this.helper.toRemove.size() > 0) {
                IndustrialForegoing.LOGGER.debug("Processing chunks at rad: " + this.index);
                HashSet<Integer> set = this.helper.toRemove.removeFirst();
                for (int pos : set) {
                    BlockPos blockPos = this.helper.shortPos.getActualPos(pos);
                    if (!BlockUtils.canBlockBeBrokenPlugin((World)this.helper.serverWorld, blockPos)) continue;
                    chunks.add(this.helper.removeBlock(this.helper.shortPos.getActualPos(pos)));
                }
                ++this.index;
            }
            this.finishChunks(chunks);
            if (this.helper.toRemove.isEmpty()) {
                if (this.blocksToRmv.isEmpty()) {
                    this.blocksToRmv = new ArrayList<Integer>(this.helper.blocksToUpdate);
                }
                if (this.blocksToUpdatePointer < this.helper.blocksToUpdate.size()) {
                    this.updateBlocks();
                } else {
                    IndustrialForegoing.LOGGER.info("Explosion Completed in " + (System.currentTimeMillis() - this.start) / 1000L + "s");
                    this.isDead = true;
                    IndustrialForegoing.LOGGER.info("Explosion done");
                }
            }
        }

        public void finishChunks(HashSet<Chunk> chunks) {
            for (Chunk chunk : chunks) {
                chunk.func_177427_f(true);
                ServerWorldLightManager lightManager = (ServerWorldLightManager)this.helper.serverWorld.func_225524_e_();
                lightManager.func_215593_a((IChunk)chunk, false).thenRun(() -> ((ExplosionHelper)this.helper).serverWorld.func_72863_F().field_217237_a.func_219097_a(chunk.func_76632_l(), false).forEach(e -> e.field_71135_a.func_147359_a((IPacket)new SUpdateLightPacket(chunk.func_76632_l(), this.helper.serverWorld.func_225524_e_(), true))));
                SChunkDataPacket packet = new SChunkDataPacket(chunk, 65535);
                ((ExplosionHelper)this.helper).serverWorld.func_72863_F().field_217237_a.func_219097_a(chunk.func_76632_l(), false).forEach(e -> e.field_71135_a.func_147359_a((IPacket)packet));
            }
        }

        private void updateBlocks() {
            IndustrialForegoing.LOGGER.debug("Updating Blocks");
            int amount = 1000;
            for (int i = 0; i < amount; ++i) {
                if (this.blocksToUpdatePointer + i >= this.helper.blocksToUpdate.size()) continue;
                try {
                    int pos = this.blocksToRmv.get(this.blocksToUpdatePointer + i);
                    BlockState state = this.helper.serverWorld.func_180495_p(this.helper.shortPos.getActualPos(pos));
                    if (state.func_177230_c() instanceof FallingBlock) {
                        state.func_177230_c().func_225534_a_(state, this.helper.serverWorld, this.helper.shortPos.getActualPos(pos), ((ExplosionHelper)this.helper).serverWorld.field_73012_v);
                    }
                    state.func_215697_a((World)this.helper.serverWorld, this.helper.shortPos.getActualPos(pos), Blocks.field_150350_a, this.helper.shortPos.getActualPos(pos).func_177984_a(), false);
                    continue;
                }
                catch (Throwable e) {
                    IndustrialForegoing.LOGGER.error((Object)e);
                }
            }
            this.blocksToUpdatePointer += amount;
        }

        public boolean isDead() {
            return this.isDead;
        }
    }
}

