/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class ResourceHelper {
    public static final ResourceLocation TEX_TAMED_WOLF = new ResourceLocation("textures/entity/wolf/wolf_tame.png");
    public static final ResourceLocation TEX_WOLF_COLLAR = new ResourceLocation("textures/entity/wolf/wolf_collar.png");
    public static final ResourceLocation TEX_PIG = new ResourceLocation("textures/entity/pig/pig.png");
    public static final ResourceLocation TEX_RESOURCE_PACKS = new ResourceLocation("textures/gui/resource_packs.png");
    public static final ResourceLocation TEX_SPECTATOR_WIDGETS = new ResourceLocation("textures/gui/spectator_widgets.png");
    private static Path workingDir;
    private static Path themesDir;
    private static boolean init;

    public static void init() {
        block10: {
            if (!init) {
                init = true;
                try {
                    File defaultTheme;
                    workingDir = FMLPaths.CONFIGDIR.get().resolve("ichunutil");
                    if (!Files.exists(workingDir, new LinkOption[0])) {
                        Files.createDirectory(workingDir, new FileAttribute[0]);
                    }
                    if (!Files.exists(themesDir = workingDir.resolve("themes"), new LinkOption[0])) {
                        Files.createDirectory(themesDir, new FileAttribute[0]);
                    }
                    if ((defaultTheme = new File(themesDir.toFile(), "default.json")).exists()) break block10;
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    String jsonOutput = gson.toJson((Object)new Theme());
                    try {
                        FileUtils.writeStringToFile((File)defaultTheme, (String)jsonOutput, (Charset)StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    InputStream in = iChunUtil.class.getResourceAsStream("/themes.zip");
                    if (in != null) {
                        ZipInputStream zipStream = new ZipInputStream(in);
                        ZipEntry entry = null;
                        while ((entry = zipStream.getNextEntry()) != null) {
                            int len;
                            File file = new File(themesDir.toFile(), entry.getName());
                            if (file.exists() && file.length() > 3L) continue;
                            FileOutputStream out = new FileOutputStream(file);
                            byte[] buffer = new byte[8192];
                            while ((len = zipStream.read(buffer)) != -1) {
                                out.write(buffer, 0, len);
                            }
                            out.close();
                        }
                        zipStream.close();
                    }
                }
                catch (IOException e) {
                    iChunUtil.LOGGER.fatal("Error initialising resources!");
                    e.printStackTrace();
                }
            }
        }
    }

    public static Path getThemesDir() {
        return themesDir;
    }
}

