/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.config;

import com.google.common.collect.Ordering;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowDock;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowPopup;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementDropdownContextMenu;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementNumberInput;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextField;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementToggle;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementToggleTextable;
import me.ichun.mods.ichunutil.client.gui.config.window.WindowConfigs;
import me.ichun.mods.ichunutil.client.gui.config.window.WindowValues;
import me.ichun.mods.ichunutil.client.gui.config.window.view.ViewValues;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class WorkspaceConfigs
extends Workspace {
    public TreeMap<String, TreeSet<ConfigInfo>> configs = new TreeMap(Ordering.natural());

    public WorkspaceConfigs(Screen lastScreen) {
        super(lastScreen, (ITextComponent)new TranslationTextComponent("gui.ichunutil.configs.title"), iChunUtil.configClient.guiMinecraftStyle);
        ConfigBase.CONFIGS.forEach(configBase -> {
            TreeSet confs = this.configs.computeIfAbsent(configBase.getConfigName(), v -> new TreeSet(Ordering.natural()));
            confs.add(new ConfigInfo((ConfigBase)configBase));
        });
        this.addToDock(new WindowConfigs(this), Constraint.Property.Type.LEFT);
    }

    public void selectItem(ElementList.Item<?> item) {
        if (item.selected) {
            for (ElementList.Item<?> item1 : ((ElementList)item.parentFragment).items) {
                if (item1 == item) continue;
                item1.selected = false;
            }
            this.destroyWindowValues();
            ConfigInfo config = (ConfigInfo)item.getObject();
            if (config.config.getConfigType().equals((Object)ModConfig.Type.SERVER) && (Minecraft.func_71410_x().field_71439_g == null || !ServerLifecycleHooks.getCurrentServer().func_71264_H() || ServerLifecycleHooks.getCurrentServer().func_184103_al().func_72394_k() > 1)) {
                WindowPopup.popup((Workspace)this, 0.6, 140.0, null, I18n.func_135052_a((String)"gui.ichunutil.configs.noEditingServerConfig", (Object[])new Object[0]));
            } else {
                WindowValues window = new WindowValues(this, config, item.id);
                this.addToDock(window, Constraint.Property.Type.LEFT);
                window.constraint.right(this.getDock(), Constraint.Property.Type.RIGHT, -((Integer)window.borderSize.get()).intValue() + 1 + (Integer)this.getDock().borderSize.get());
                window.constraint.apply();
                if (this.hasInit()) {
                    window.init();
                    window.resize(Minecraft.func_71410_x(), this.field_230708_k_, this.field_230709_l_);
                }
            }
        }
    }

    public void destroyWindowValues() {
        WindowDock<? extends Workspace> dock = this.getDock();
        Iterator<Map.Entry<WindowDock.ArrayListHolder, Constraint.Property.Type>> ite = dock.docked.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry<WindowDock.ArrayListHolder, Constraint.Property.Type> e = ite.next();
            ArrayList<Window<?>> windows = e.getKey().windows;
            for (int i = windows.size() - 1; i >= 0; --i) {
                Window<?> window = windows.get(i);
                if (!(window instanceof WindowValues)) continue;
                this.saveConfig((ViewValues)((WindowValues)window).currentView);
                dock.dockedOriSize.remove(window);
                if (windows.size() == 1) {
                    ite.remove();
                    continue;
                }
                windows.remove(i);
            }
        }
    }

    private void saveConfig(ViewValues view) {
        block2: for (ElementList.Item<?> item : view.list.items) {
            Element<?> e = view.getControlElement(item);
            if (e == null) continue;
            ConfigBase.ValueWrapper<?> valueWrapper = ((ConfigInfo.ValueWrapperLocalised)item.getObject()).value;
            Field field = valueWrapper.field;
            field.setAccessible(true);
            Class<?> clz = field.getType();
            try {
                Object o = field.get(valueWrapper.parent);
                if (clz == Integer.TYPE && e instanceof ElementNumberInput) {
                    field.set(valueWrapper.parent, ((ElementNumberInput)e).getInt());
                    continue;
                }
                if (clz == Double.TYPE && e instanceof ElementNumberInput) {
                    field.set(valueWrapper.parent, ((ElementNumberInput)e).getDouble());
                    continue;
                }
                if (clz == Boolean.TYPE && e instanceof ElementToggleTextable) {
                    field.set(valueWrapper.parent, ((ElementToggle)e).toggleState);
                    continue;
                }
                if (clz == String.class && e instanceof ElementTextField) {
                    field.set(valueWrapper.parent, ((ElementTextField)e).getText());
                    continue;
                }
                if (clz.isEnum() && e instanceof ElementDropdownContextMenu) {
                    ?[] enums;
                    for (Object en : enums = clz.getEnumConstants()) {
                        if (!en.toString().equals(((ElementDropdownContextMenu)e).text)) continue;
                        field.set(valueWrapper.parent, en);
                        continue block2;
                    }
                    continue;
                }
                if (!(o instanceof List)) continue;
            }
            catch (IllegalAccessException e1) {}
        }
        view.info.config.save();
    }

    @Override
    public void func_231175_as__() {
        this.destroyWindowValues();
        super.func_231175_as__();
    }

    public static String getLocalizedCategory(ConfigInfo info, String cat, String suffix) {
        if (cat.isEmpty()) {
            return I18n.func_135052_a((String)("config.ichunutil.cat.general." + suffix), (Object[])new Object[0]);
        }
        if (cat.equals("general") || cat.equals("gameplay") || cat.equals("global") || cat.equals("serverOnly") || cat.equals("clientOnly") || cat.equals("block")) {
            return I18n.func_135052_a((String)("config.ichunutil.cat." + cat + "." + suffix), (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)("config." + info.config.getModId() + ".cat." + cat + "." + suffix), (Object[])new Object[0]);
    }

    public static class ConfigInfo
    implements Comparable<ConfigInfo> {
        public final ConfigBase config;
        public final TreeMap<String, TreeSet<ValueWrapperLocalised>> categories = new TreeMap(Ordering.natural());

        public ConfigInfo(ConfigBase config) {
            this.config = config;
            for (Map.Entry<String, HashSet<ConfigBase.ValueWrapper<?>>> e : config.values.entrySet()) {
                TreeSet set = this.categories.computeIfAbsent(e.getKey(), v -> new TreeSet(Ordering.natural()));
                for (ConfigBase.ValueWrapper<?> valueWrapper : e.getValue()) {
                    set.add(new ValueWrapperLocalised(valueWrapper, I18n.func_135052_a((String)("config." + config.getModId() + ".prop." + valueWrapper.field.getName() + ".name"), (Object[])new Object[0]), I18n.func_135052_a((String)("config." + config.getModId() + ".prop." + valueWrapper.field.getName() + ".desc"), (Object[])new Object[0])));
                }
            }
        }

        @Override
        public int compareTo(ConfigInfo o) {
            return this.config.compareTo(o.config);
        }

        public static class ValueWrapperLocalised
        implements Comparable<ValueWrapperLocalised> {
            public final ConfigBase.ValueWrapper<?> value;
            public final String name;
            public final String desc;

            public ValueWrapperLocalised(ConfigBase.ValueWrapper<?> value, String name, String desc) {
                this.value = value;
                this.name = name;
                this.desc = desc;
            }

            @Override
            public int compareTo(ValueWrapperLocalised o) {
                return this.name.compareTo(o.name);
            }
        }
    }
}

