/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.module.tabula.legacy.project;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.commons.lang3.RandomStringUtils;

@Deprecated
public class ProjectInfo {
    public static final int IDENTIFIER_LENGTH = 20;
    public String modelName = "";
    public String authorName = "";
    public int projVersion;
    public ArrayList<String> metadata;
    public int textureWidth = 64;
    public int textureHeight = 32;
    public double[] scale = new double[]{1.0, 1.0, 1.0};
    public ArrayList<CubeGroup> cubeGroups;
    public ArrayList<CubeInfo> cubes;
    public ArrayList<Animation> anims;
    public int cubeCount;
    public transient byte[] textureBytes;

    public ProjectInfo() {
        this.metadata = new ArrayList();
        this.cubeGroups = new ArrayList();
        this.cubes = new ArrayList();
        this.anims = new ArrayList();
    }

    public ProjectInfo(String name, String author) {
        this();
        this.modelName = name;
        this.authorName = author;
        this.cubeGroups = new ArrayList();
        this.cubes = new ArrayList();
    }

    public ProjectInfo repair() {
        while (this.projVersion < 4) {
            if (this.projVersion == 1) {
                this.scale = new double[]{1.0, 1.0, 1.0};
                for (CubeInfo info : this.getAllCubes()) {
                    info.opacity = 100.0;
                }
            } else if (this.projVersion == 2) {
                this.metadata = new ArrayList();
            } else if (this.projVersion == 3) {
                for (CubeGroup group : this.cubeGroups) {
                    group.metadata = new ArrayList();
                }
                ArrayList<CubeInfo> cubes = this.getAllCubes();
                for (CubeInfo info : cubes) {
                    info.metadata = new ArrayList();
                }
            }
            ++this.projVersion;
        }
        return this;
    }

    public ArrayList<CubeInfo> getAllCubes() {
        ArrayList<CubeInfo> cubes = new ArrayList<CubeInfo>();
        this.addAllCubes(cubes, this.cubes);
        this.addAllCubesFromGroups(cubes, this.cubeGroups);
        return cubes;
    }

    public void addAllCubes(ArrayList<CubeInfo> list, ArrayList<CubeInfo> cubes) {
        list.addAll(cubes);
        for (CubeInfo cube : cubes) {
            this.addAllCubes(list, cube.getChildren());
        }
    }

    public void addAllCubesFromGroups(ArrayList<CubeInfo> list, ArrayList<CubeGroup> groups) {
        for (CubeGroup group : groups) {
            this.addAllCubes(list, group.cubes);
            this.addAllCubesFromGroups(list, group.cubeGroups);
        }
    }

    @Deprecated
    public static class Animation {
        public String name;
        public String identifier;
        public boolean loops;
        public TreeMap<String, ArrayList<AnimationComponent>> sets = new TreeMap(Ordering.natural());
        public transient int playTime;
        public transient boolean playing;

        public Animation(String name) {
            this.name = name;
            this.identifier = RandomStringUtils.randomAscii((int)20);
        }

        @Deprecated
        public static class AnimationComponent {
            public double[] posChange = new double[3];
            public double[] rotChange = new double[3];
            public double[] scaleChange = new double[3];
            public double opacityChange = 0.0;
            public double[] posOffset = new double[3];
            public double[] rotOffset = new double[3];
            public double[] scaleOffset = new double[3];
            public double opacityOffset = 0.0;
            public ArrayList<double[]> progressionCoords;
            public String name;
            public int length;
            public int startKey;
            public boolean hidden;
            public String identifier;

            public AnimationComponent(String name, int length, int startKey) {
                this.name = name;
                this.length = length;
                this.startKey = startKey;
                this.identifier = RandomStringUtils.randomAscii((int)20);
            }
        }
    }

    @Deprecated
    public static class CubeGroup {
        public ArrayList<CubeInfo> cubes = new ArrayList();
        public ArrayList<CubeGroup> cubeGroups = new ArrayList();
        public String name;
        public boolean txMirror = false;
        public boolean hidden = false;
        public ArrayList<String> metadata = new ArrayList();
        public String identifier;

        public CubeGroup(String name) {
            this.name = name;
            this.identifier = RandomStringUtils.randomAscii((int)20);
        }
    }

    @Deprecated
    public static class CubeInfo {
        public String name;
        public int[] dimensions = new int[3];
        public double[] position = new double[3];
        public double[] offset = new double[3];
        public double[] rotation = new double[3];
        public double[] scale = new double[3];
        public int[] txOffset = new int[2];
        public boolean txMirror = false;
        public double mcScale = 0.0;
        public double opacity = 100.0;
        public boolean hidden = false;
        public ArrayList<String> metadata = new ArrayList();
        public ArrayList<CubeInfo> children = new ArrayList();
        public String parentIdentifier;
        public String identifier;

        public CubeInfo(String name) {
            this.name = name;
            this.dimensions = new int[]{1, 1, 1};
            this.scale = new double[]{1.0, 1.0, 1.0};
            this.opacity = 100.0;
            this.identifier = RandomStringUtils.randomAscii((int)20);
        }

        public ArrayList<CubeInfo> getChildren() {
            return this.children;
        }
    }
}

