/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.berry_good.core;

import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.abnormals_core.core.util.registry.RegistryHelper;
import com.minecraftabnormals.berry_good.core.BGConfig;
import com.minecraftabnormals.berry_good.core.data.BlockModelGenerator;
import com.minecraftabnormals.berry_good.core.data.BlockTagGenerator;
import com.minecraftabnormals.berry_good.core.data.ItemModelGenerator;
import com.minecraftabnormals.berry_good.core.data.ItemTagGenerator;
import com.minecraftabnormals.berry_good.core.data.LanguageGenerator;
import com.minecraftabnormals.berry_good.core.data.LootTableGenerator;
import com.minecraftabnormals.berry_good.core.data.RecipeGenerator;
import com.minecraftabnormals.berry_good.core.data.SoundDefinitionGenerator;
import com.minecraftabnormals.berry_good.core.registry.BGBlocks;
import com.minecraftabnormals.berry_good.core.registry.BGItems;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="berry_good")
public class BerryGood {
    public static final String MOD_ID = "berry_good";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("berry_good");

    public BerryGood() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        REGISTRY_HELPER.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, BGConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> DataUtil.registerCompostable((IItemProvider)((IItemProvider)BGItems.SWEET_BERRY_PIPS.get()), (float)0.3f));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> RenderTypeLookup.setRenderLayer((Block)((Block)BGBlocks.SWEET_BERRY_BUSH_PIPS.get()), (RenderType)RenderType.func_228643_e_()));
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            BlockTagGenerator blockTagGen = new BlockTagGenerator(dataGenerator, existingFileHelper);
            dataGenerator.func_200390_a((IDataProvider)blockTagGen);
            dataGenerator.func_200390_a((IDataProvider)new ItemTagGenerator(dataGenerator, blockTagGen, existingFileHelper));
            dataGenerator.func_200390_a((IDataProvider)new LootTableGenerator(dataGenerator));
            dataGenerator.func_200390_a((IDataProvider)new RecipeGenerator(dataGenerator));
        }
        if (event.includeClient()) {
            dataGenerator.func_200390_a((IDataProvider)new ItemModelGenerator(dataGenerator, existingFileHelper));
            dataGenerator.func_200390_a((IDataProvider)new BlockModelGenerator(dataGenerator, existingFileHelper));
            dataGenerator.func_200390_a((IDataProvider)new LanguageGenerator(dataGenerator));
            dataGenerator.func_200390_a((IDataProvider)new SoundDefinitionGenerator(dataGenerator, existingFileHelper));
        }
    }
}

