/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.forge;

import java.util.UUID;
import java.util.function.Supplier;
import journeymap.client.JourneymapClient;
import journeymap.common.network.data.model.PlayerLocation;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ServerPlayerLocationPacket
implements PlayerLocation {
    private int entityId;
    private UUID uniqueId;
    private double x;
    private double y;
    private double z;
    private byte yaw;
    private byte pitch;
    private boolean visible;

    public ServerPlayerLocationPacket() {
    }

    public ServerPlayerLocationPacket(PlayerEntity player, boolean visible) {
        this.uniqueId = player.func_146103_bH().getId();
        this.visible = visible;
        if (visible) {
            this.entityId = player.func_145782_y();
            this.x = player.func_226277_ct_();
            this.y = player.func_226278_cu_();
            this.z = player.func_226281_cx_();
            this.yaw = (byte)(player.field_70177_z * 256.0f / 360.0f);
            this.pitch = (byte)(player.field_70125_A * 256.0f / 360.0f);
        }
    }

    public ServerPlayerLocationPacket(PacketBuffer buf) {
        this.visible = buf.readBoolean();
        this.uniqueId = buf.func_179253_g();
        if (this.visible) {
            this.entityId = buf.func_150792_a();
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
            this.yaw = buf.readByte();
            this.pitch = buf.readByte();
        }
    }

    public void encode(PacketBuffer buf) {
        buf.writeBoolean(this.visible);
        buf.func_179252_a(this.uniqueId);
        if (this.visible) {
            buf.func_150787_b(this.entityId);
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeByte((int)this.yaw);
            buf.writeByte((int)this.pitch);
        }
    }

    public static void handle(ServerPlayerLocationPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                JourneymapClient.getInstance().getPacketHandler().onPlayerLocationPacket(packet);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public byte getYaw() {
        return this.yaw;
    }

    @Override
    public byte getPitch() {
        return this.pitch;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

