/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.DataInput;
import java.io.IOException;
import javax.imageio.IIOException;

final class PSDHeader {
    private static final int PSD_MAX_SIZE = 30000;
    private static final int PSB_MAX_SIZE = 300000;
    final short channels;
    final int width;
    final int height;
    final short bits;
    final short mode;
    final boolean largeFormat;

    PSDHeader(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n != 943870035) {
            throw new IIOException("Not a PSD document, expected signature \"8BPS\": \"" + PSDUtil.intToStr(n) + "\" (0x" + Integer.toHexString(n) + ")");
        }
        int n2 = dataInput.readUnsignedShort();
        switch (n2) {
            case 1: {
                this.largeFormat = false;
                break;
            }
            case 2: {
                this.largeFormat = true;
                break;
            }
            default: {
                throw new IIOException(String.format("Unknown PSD version, expected 1 or 2: 0x%08x", n2));
            }
        }
        byte[] byArray = new byte[6];
        dataInput.readFully(byArray);
        this.channels = dataInput.readShort();
        if (this.channels < 1 || this.channels > 56) {
            throw new IIOException(String.format("Unsupported number of channels for PSD: %d", this.channels));
        }
        this.height = dataInput.readInt();
        this.width = dataInput.readInt();
        this.bits = dataInput.readShort();
        switch (this.bits) {
            case 1: 
            case 8: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new IIOException(String.format("Unsupported bit depth for PSD: %d bits", this.bits));
            }
        }
        this.mode = dataInput.readShort();
        switch (this.mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new IIOException(String.format("Unsupported color mode for PSD: %d", this.mode));
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[version: " + (this.largeFormat ? "2" : "1") + ", channels: " + this.channels + ", width: " + this.width + ", height: " + this.height + ", depth: " + this.bits + ", mode: " + this.mode + " (" + this.modeAsString() + ")]";
    }

    int getMaxSize() {
        return this.largeFormat ? 300000 : 30000;
    }

    boolean hasValidDimensions() {
        return this.width <= this.getMaxSize() && this.height <= this.getMaxSize();
    }

    private String modeAsString() {
        switch (this.mode) {
            case 0: {
                return "Monochrome";
            }
            case 1: {
                return "Grayscale";
            }
            case 2: {
                return "Indexed";
            }
            case 3: {
                return "RGB";
            }
            case 4: {
                return "CMYK";
            }
            case 7: {
                return "Multi channel";
            }
            case 8: {
                return "Duotone";
            }
            case 9: {
                return "Lab color";
            }
        }
        return "Unkown mode";
    }
}

