/*
 * Decompiled with CFR 0.152.
 */
package observable.server;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import observable.Observable;
import observable.Props;
import observable.server.Profiler;
import observable.server.ServerSettingsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lobservable/server/TaggedSampler;", "Ljava/lang/Runnable;", "thread", "Ljava/lang/Thread;", "(Ljava/lang/Thread;)V", "entries", "Lkotlin/collections/ArrayDeque;", "Lobservable/server/TaggedSampler$Sample;", "getEntries", "()Lkotlin/collections/ArrayDeque;", "setEntries", "(Lkotlin/collections/ArrayDeque;)V", "getThread", "()Ljava/lang/Thread;", "run", "", "Sample", "SamplerProcessor", "observable"})
public final class TaggedSampler
implements Runnable {
    @NotNull
    private final Thread thread;
    @NotNull
    private ArrayDeque<Sample> entries;

    public TaggedSampler(@NotNull Thread thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.thread = thread;
        this.entries = new ArrayDeque();
    }

    @NotNull
    public final Thread getThread() {
        return this.thread;
    }

    @NotNull
    public final ArrayDeque<Sample> getEntries() {
        return this.entries;
    }

    public final void setEntries(@NotNull ArrayDeque<Sample> arrayDeque) {
        Intrinsics.checkNotNullParameter(arrayDeque, (String)"<set-?>");
        this.entries = arrayDeque;
    }

    @Override
    public void run() {
        Observable.INSTANCE.getLOGGER().info("Started sampler thread");
        long interval = ServerSettingsKt.getServerSettings().getTraceInterval();
        long deviation = ServerSettingsKt.getServerSettings().getDeviation();
        Object[] trace = null;
        Object[] target = null;
        if (interval > 0L) {
            while (!Props.notProcessing) {
                Object[] objectArray = Props.currentTarget.get();
                if (objectArray == null) continue;
                target = objectArray;
                objectArray = this.thread.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"thread.stackTrace");
                trace = objectArray;
                target.getTraces().add(ArraysKt.toList((Object[])trace));
                Thread.sleep(interval + Random.Default.nextLong(-deviation, deviation));
            }
        } else {
            while (!Props.notProcessing) {
                StackTraceElement[] stackTraceElementArray = Props.currentTarget.get();
                if (stackTraceElementArray == null) continue;
                target = stackTraceElementArray;
                stackTraceElementArray = this.thread.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"thread.stackTrace");
                trace = stackTraceElementArray;
                target.getTraces().add(ArraysKt.toList((Object[])trace));
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ*\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lobservable/server/TaggedSampler$Sample;", "", "target", "Lobservable/server/Profiler$TimingData;", "trace", "", "Ljava/lang/StackTraceElement;", "(Lobservable/server/Profiler$TimingData;[Ljava/lang/StackTraceElement;)V", "getTarget", "()Lobservable/server/Profiler$TimingData;", "getTrace", "()[Ljava/lang/StackTraceElement;", "[Ljava/lang/StackTraceElement;", "component1", "component2", "copy", "(Lobservable/server/Profiler$TimingData;[Ljava/lang/StackTraceElement;)Lobservable/server/TaggedSampler$Sample;", "equals", "", "other", "hashCode", "", "toString", "", "observable"})
    public static final class Sample {
        @Nullable
        private final Profiler.TimingData target;
        @NotNull
        private final StackTraceElement[] trace;

        public Sample(@Nullable Profiler.TimingData target, @NotNull StackTraceElement[] trace) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            this.target = target;
            this.trace = trace;
        }

        @Nullable
        public final Profiler.TimingData getTarget() {
            return this.target;
        }

        @NotNull
        public final StackTraceElement[] getTrace() {
            return this.trace;
        }

        @Nullable
        public final Profiler.TimingData component1() {
            return this.target;
        }

        @NotNull
        public final StackTraceElement[] component2() {
            return this.trace;
        }

        @NotNull
        public final Sample copy(@Nullable Profiler.TimingData target, @NotNull StackTraceElement[] trace) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            return new Sample(target, trace);
        }

        public static /* synthetic */ Sample copy$default(Sample sample, Profiler.TimingData timingData, StackTraceElement[] stackTraceElementArray, int n, Object object) {
            if ((n & 1) != 0) {
                timingData = sample.target;
            }
            if ((n & 2) != 0) {
                stackTraceElementArray = sample.trace;
            }
            return sample.copy(timingData, stackTraceElementArray);
        }

        @NotNull
        public String toString() {
            return "Sample(target=" + this.target + ", trace=" + Arrays.toString(this.trace) + ')';
        }

        public int hashCode() {
            int result2 = this.target == null ? 0 : this.target.hashCode();
            result2 = result2 * 31 + Arrays.hashCode(this.trace);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Sample)) {
                return false;
            }
            Sample sample = (Sample)other;
            if (!Intrinsics.areEqual((Object)this.target, (Object)sample.target)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.trace, (Object)sample.trace);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lobservable/server/TaggedSampler$SamplerProcessor;", "Ljava/lang/Runnable;", "entries", "Lkotlin/collections/ArrayDeque;", "Lobservable/server/TaggedSampler$Sample;", "(Lkotlin/collections/ArrayDeque;)V", "getEntries", "()Lkotlin/collections/ArrayDeque;", "running", "", "getRunning", "()Z", "setRunning", "(Z)V", "run", "", "observable"})
    public static final class SamplerProcessor
    implements Runnable {
        @NotNull
        private final ArrayDeque<Sample> entries;
        private volatile boolean running;

        public SamplerProcessor(@NotNull ArrayDeque<Sample> entries) {
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            this.entries = entries;
            this.running = true;
        }

        @NotNull
        public final ArrayDeque<Sample> getEntries() {
            return this.entries;
        }

        public final boolean getRunning() {
            return this.running;
        }

        public final void setRunning(boolean bl) {
            this.running = bl;
        }

        @Override
        public void run() {
            Object sample = null;
            while (this.running) {
                Sample sample2 = (Sample)this.entries.removeLastOrNull();
                if (sample2 == null) continue;
                Sample sample3 = sample2;
                Profiler.TimingData target = sample3.component1();
                StackTraceElement[] trace = sample3.component2();
                if (target == null) continue;
            }
        }
    }
}

