/*
 * Decompiled with CFR 0.152.
 */
package codechicken.asm;

import codechicken.asm.InsnComparator;
import codechicken.asm.InsnListSection;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class ASMBlock {
    public InsnListSection list;
    public BiMap<String, LabelNode> labels;

    public ASMBlock(InsnListSection list, BiMap<String, LabelNode> labels) {
        this.list = list;
        this.labels = labels;
    }

    public ASMBlock(InsnListSection list) {
        this(list, (BiMap<String, LabelNode>)HashBiMap.create());
    }

    public ASMBlock(InsnList list) {
        this(new InsnListSection(list));
    }

    public ASMBlock() {
        this(new InsnListSection());
    }

    public LabelNode getOrAdd(String s) {
        LabelNode l = this.get(s);
        if (l == null) {
            l = new LabelNode();
            this.labels.put((Object)s, (Object)l);
        }
        return l;
    }

    public LabelNode get(String s) {
        return (LabelNode)this.labels.get((Object)s);
    }

    public void replaceLabels(Map<LabelNode, LabelNode> labelMap, Set<LabelNode> usedLabels) {
        for (AbstractInsnNode abstractInsnNode : this.list) {
            switch (abstractInsnNode.getType()) {
                case 8: {
                    AbstractInsnNode insn2 = abstractInsnNode.clone(labelMap);
                    if (insn2 == abstractInsnNode) break;
                    if (usedLabels.contains(insn2)) {
                        throw new IllegalStateException("LabelNode cannot be a part of two InsnLists");
                    }
                    this.list.replace(abstractInsnNode, insn2);
                    break;
                }
                case 7: 
                case 11: 
                case 12: 
                case 14: {
                    this.list.replace(abstractInsnNode, abstractInsnNode.clone(labelMap));
                }
            }
        }
        for (Map.Entry entry : labelMap.entrySet()) {
            String key = (String)this.labels.inverse().get(entry.getKey());
            if (key == null) continue;
            this.labels.put((Object)key, entry.getValue());
        }
    }

    public void replaceLabels(Map<LabelNode, LabelNode> labelMap) {
        this.replaceLabels(labelMap, Collections.emptySet());
    }

    public void replaceLabel(String s, LabelNode l) {
        LabelNode old = this.get(s);
        if (old != null) {
            this.replaceLabels((Map<LabelNode, LabelNode>)ImmutableMap.of((Object)old, (Object)l));
        }
    }

    public ASMBlock mergeLabels(ASMBlock other) {
        if (this.labels.isEmpty() || other.labels.isEmpty()) {
            return this;
        }
        HashMap<LabelNode, LabelNode> labelMap = this.list.identityLabelMap();
        for (Map.Entry entry : other.labels.entrySet()) {
            LabelNode old = (LabelNode)this.labels.get(entry.getKey());
            if (old == null) continue;
            labelMap.put(old, (LabelNode)entry.getValue());
        }
        HashSet<LabelNode> usedLabels = new HashSet<LabelNode>();
        for (AbstractInsnNode insn = other.list.list.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getType() != 8) continue;
            usedLabels.add((LabelNode)insn);
        }
        this.replaceLabels(labelMap, usedLabels);
        return this;
    }

    public ASMBlock pullLabels(ASMBlock other) {
        other.list.remove();
        return this.mergeLabels(other);
    }

    public ASMBlock copy() {
        HashBiMap labels = HashBiMap.create();
        Map<LabelNode, LabelNode> labelMap = this.list.cloneLabels();
        for (Map.Entry entry : this.labels.entrySet()) {
            labels.put(entry.getKey(), (Object)labelMap.get(entry.getValue()));
        }
        return new ASMBlock(this.list.copy(labelMap), (BiMap<String, LabelNode>)labels);
    }

    public ASMBlock applyLabels(InsnListSection list2) {
        if (this.labels.isEmpty()) {
            return new ASMBlock(list2);
        }
        Set cFlowLabels1 = this.labels.values();
        Set<LabelNode> cFlowLabels2 = InsnComparator.getControlFlowLabels(list2);
        ASMBlock block = new ASMBlock(list2);
        HashMap<LabelNode, LabelNode> labelMap = new HashMap<LabelNode, LabelNode>();
        int i = 0;
        int k = 0;
        while (i < this.list.size() && k < list2.size()) {
            AbstractInsnNode insn1 = this.list.get(i);
            if (!InsnComparator.insnImportant(insn1, cFlowLabels1)) {
                ++i;
                continue;
            }
            AbstractInsnNode insn2 = list2.get(k);
            if (!InsnComparator.insnImportant(insn2, cFlowLabels2)) {
                ++k;
                continue;
            }
            if (insn1.getOpcode() != insn2.getOpcode()) {
                throw new IllegalArgumentException("Lists do not match:\n" + this.list + "\n\n" + list2);
            }
            switch (insn1.getType()) {
                case 8: {
                    labelMap.put((LabelNode)insn1, (LabelNode)insn2);
                    break;
                }
                case 7: {
                    labelMap.put(((JumpInsnNode)insn1).label, ((JumpInsnNode)insn2).label);
                }
            }
            ++i;
            ++k;
        }
        for (Map.Entry entry : this.labels.entrySet()) {
            block.labels.put(entry.getKey(), labelMap.get(entry.getValue()));
        }
        return block;
    }

    public InsnList rawListCopy() {
        return this.list.copy().list;
    }
}

