/*
 * Decompiled with CFR 0.152.
 */
package codechicken.asm.transformers;

import codechicken.asm.ASMBlock;
import codechicken.asm.InsnComparator;
import codechicken.asm.InsnListSection;
import codechicken.asm.ModularASMTransformer;
import codechicken.asm.ObfMapping;
import codechicken.asm.transformers.MethodTransformer;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class MethodReplacer
extends MethodTransformer {
    private static final Logger logger = LogManager.getLogger();
    public ASMBlock needle;
    public ASMBlock replacement;

    public MethodReplacer(@Nonnull ObfMapping method, @Nonnull ASMBlock needle, @Nonnull ASMBlock replacement) {
        super(method);
        this.needle = needle;
        this.replacement = replacement;
    }

    public MethodReplacer(@Nonnull ObfMapping method, @Nonnull InsnList needle, @Nonnull InsnList replacement) {
        this(method, new ASMBlock(needle), new ASMBlock(replacement));
    }

    @Override
    public void addMethodsToSort(Set<ObfMapping> set) {
        set.add(this.method);
    }

    @Override
    public void transform(MethodNode mv) {
        for (InsnListSection key : InsnComparator.findN(mv.instructions, this.needle.list)) {
            logger.log(ModularASMTransformer.LEVEL, "Replacing method '{}' @ {} - {}.", (Object)this.method, (Object)key.start, (Object)key.end);
            ASMBlock replaceBlock = this.replacement.copy().pullLabels(this.needle.applyLabels(key));
            key.insert(replaceBlock.list.list);
        }
    }
}

