/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock;

import codechicken.lib.util.SneakyUtils;
import codechicken.microblock.MicroMaterialRegistry$;
import codechicken.microblock.api.BlockMicroMaterial$;
import codechicken.microblock.api.MicroMaterial;
import java.io.BufferedReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;

public final class ConfigContent$ {
    public static final ConfigContent$ MODULE$ = new ConfigContent$();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<String> DEFAULT_FILE = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"# Configuration file for adding microblock materials for aesthetic blocks added by mods", "# The '#' character defines a comment, everything after this character on a given line will be ignored.", "# Each line needs to be of the form <registry_name>[property=value,otherProperty=value]", "# <registry_name> being the registry name of the block. E.G: 'minecraft:stone'", "# This can optionally be followed by Key-Value pairs describing any block state properties.", "# If no properties are defined, the default state of the block will be used.", "# Examples:", "#  'minecraft:stone'", "#  'minecraft:grass_block[snowy=true]'"}));

    private Logger LOGGER() {
        return LOGGER;
    }

    private List<String> DEFAULT_FILE() {
        return DEFAULT_FILE;
    }

    public void parse(Path file) {
        if (Files.notExists(file, new LinkOption[0])) {
            Files.write(file, (Iterable<? extends CharSequence>)CollectionConverters$.MODULE$.SeqHasAsJava(this.DEFAULT_FILE()).asJava(), StandardCharsets.UTF_8, new OpenOption[0]);
            return;
        }
        ForgeRegistry<MicroMaterial> registry = MicroMaterialRegistry$.MODULE$.MICRO_MATERIALS();
        registry.unfreeze();
        Using$.MODULE$.apply((Function0 & Serializable)() -> Files.newBufferedReader(file, StandardCharsets.UTF_8), (Function1 & Serializable)reader -> {
            ConfigContent$.$anonfun$parse$2(registry, reader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        registry.freeze();
    }

    public void parseLine(int lineNumber, String _line, IForgeRegistry<MicroMaterial> r) {
        Object object = new Object();
        try {
            if (_line.startsWith("#")) {
                return;
            }
            String line = _line.trim();
            int hashIdx = line.lastIndexOf("#");
            if (hashIdx != -1) {
                line = line.substring(0, hashIdx).trim();
            }
            if (line.isEmpty()) {
                return;
            }
            int openBracketIdx = line.indexOf(91);
            ResourceLocation resourceLocation = new ResourceLocation(openBracketIdx == -1 ? line : line.substring(0, openBracketIdx));
            if (!ForgeRegistries.BLOCKS.containsKey(resourceLocation)) {
                this.LOGGER().error(new StringBuilder(56).append("Error reading microblock config line ").append(lineNumber).append(", Missing block: '").append(line).append("'").toString());
                return;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
            ObjectRef state = ObjectRef.create((Object)block.func_176223_P());
            if (openBracketIdx != -1) {
                int closeBracketIdx = line.indexOf(93);
                if (closeBracketIdx == -1) {
                    this.LOGGER().error(new StringBuilder(65).append("Error reading microblock config line ").append(lineNumber).append(": '").append(line).append("', Missing closing brace.").toString());
                    return;
                }
                String rawProps = line.substring(openBracketIdx + 1, closeBracketIdx);
                ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(rawProps), ',')))), (Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigContent$.$anonfun$parseLine$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
                    ConfigContent$.$anonfun$parseLine$2(lineNumber, object, block, resourceLocation, state, x$1);
                    return BoxedUnit.UNIT;
                });
            }
            if (r.containsKey(BlockMicroMaterial$.MODULE$.makeMaterialKey((BlockState)state.elem))) {
                this.LOGGER().warn(new StringBuilder(68).append("Skipping microblock config line ").append(lineNumber).append(". Micro material already registered.").toString());
                return;
            }
            r.register((IForgeRegistryEntry)BlockMicroMaterial$.MODULE$.apply((BlockState)state.elem));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$parse$2(ForgeRegistry registry$1, BufferedReader reader) {
        IntRef lineNumber = IntRef.create((int)0);
        reader.lines().forEach(line -> {
            try {
                ++lineNumber$1.elem;
                MODULE$.parseLine(lineNumber$1.elem, (String)line, (IForgeRegistry<MicroMaterial>)registry$1);
            }
            catch (Throwable e) {
                MODULE$.LOGGER().error(new StringBuilder(51).append("Failed to read microblock config line ").append(lineNumber$1.elem).append(": '").append((String)line).append("'. Error: ").append(e.getMessage()).toString());
                MODULE$.LOGGER().debug(new StringBuilder(42).append("Failed to read microblock config line ").append(lineNumber$1.elem).append(": {}").toString(), line, (Object)e);
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$parseLine$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$parseLine$2(int lineNumber$2, Object nonLocalReturnKey1$1, Block block$1, ResourceLocation resourceLocation$1, ObjectRef state$1, Tuple2 x$1) {
        Optional value;
        Property property;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String elem = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (!elem.contains("=")) {
                MODULE$.LOGGER().error(new StringBuilder(70).append("Error reading microblock config line ").append(lineNumber$2).append(". Property split ").append(i).append(" missing equals.").toString());
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
            String[] propSplit = elem.split("=");
            if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])propSplit)) != 2) {
                MODULE$.LOGGER().error(new StringBuilder(79).append("Error reading microblock config line ").append(lineNumber$2).append(". Property split ").append(i).append(", split on equals error: ").append(elem).toString());
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
            String propName = propSplit[0];
            String propValue = propSplit[1];
            property = block$1.func_176194_O().func_185920_a(propName);
            if (property == null) {
                MODULE$.LOGGER().error(new StringBuilder(77).append("Error reading microblock config line ").append(lineNumber$2).append(". Property '").append(propName).append("' does not exist for block: ").append(resourceLocation$1).toString());
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
            value = property.func_185929_b(propValue);
            if (!value.isPresent()) {
                MODULE$.LOGGER().error(new StringBuilder(83).append("Error reading microblock config line ").append(lineNumber$2).append(". Property '").append(propName).append("' does not have value ").append(propValue).append(" for block: ").append(resourceLocation$1).toString());
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        state$1.elem = (BlockState)((BlockState)state$1.elem).func_206870_a(property, (Comparable)SneakyUtils.unsafeCast(value.get()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ConfigContent$() {
    }
}

