/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.mehvahdjukaar.supplementaries.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.BookPileHorizontalBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.BookPileBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;

public class BookPileBlockTileRenderer
extends TileEntityRenderer<BookPileBlockTile> {
    private final ModelRenderer book = new ModelRenderer(32, 32, 0, 0);
    private final ModelRenderer lock = new ModelRenderer(32, 32, 0, 0);

    public BookPileBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        this.book.func_78784_a(0, 0).func_228303_a_(-2.0f, -5.0f, -4.0f, 4.0f, 10.0f, 7.0f, 0.0f, false);
        this.book.func_78784_a(28, 6).func_228303_a_(1.0f, -5.0f, 3.0f, 1.0f, 10.0f, 1.0f, 0.0f, false);
        this.book.func_78784_a(23, 6).func_228303_a_(-2.0f, -5.0f, 3.0f, 1.0f, 10.0f, 1.0f, 0.0f, false);
        this.lock.func_78784_a(0, 0).func_228303_a_(-1.0f, -1.0f, 3.0f, 2.0f, 2.0f, 1.0f, 0.0f, false);
        this.book.func_78792_a(this.lock);
    }

    public void render(BookPileBlockTile tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int light, int overlay) {
        BlockState state = tile.func_195044_w();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        if (tile.horizontal) {
            this.renderHorizontal(tile.books, state, matrixStack, bufferIn, light, overlay);
        } else {
            this.renderVertical(tile, state, matrixStack, bufferIn, light, overlay);
        }
    }

    private void renderHorizontal(List<BookPileBlockTile.VisualBook> visualBooks, BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        int books = Math.min((Integer)state.func_177229_b((Property)BookPileBlock.BOOKS), visualBooks.size());
        Direction dir = (Direction)state.func_177229_b((Property)BookPileHorizontalBlock.FACING);
        matrixStack.func_227863_a_(Const.rot(dir));
        matrixStack.func_227863_a_(Const.X90);
        matrixStack.func_227861_a_(0.0, 0.1875, 0.0);
        float angle = -0.19634955f;
        switch (books) {
            default: {
                break;
            }
            case 4: {
                matrixStack.func_227861_a_(-0.375, 0.0, 0.0);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(0));
                matrixStack.func_227861_a_(0.25, 0.0, -0.0625);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(1));
                matrixStack.func_227861_a_(0.25, 0.0, 0.0625);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(2));
                matrixStack.func_227861_a_(0.25, 0.0, -0.0625);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(3));
                break;
            }
            case 3: {
                matrixStack.func_227861_a_(-0.3125, 0.0, 0.0);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(0));
                matrixStack.func_227861_a_(0.25, 0.0, -0.0625);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(1));
                matrixStack.func_227861_a_(0.3125, 0.0, 0.0625);
                this.book.field_78808_h = angle;
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(2));
                this.book.field_78808_h = 0.0f;
                break;
            }
            case 2: {
                matrixStack.func_227861_a_(-0.1875, 0.0, 0.0);
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(0));
                matrixStack.func_227861_a_(0.3125, 0.0, 0.0625);
                this.book.field_78808_h = angle;
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(1));
                this.book.field_78808_h = 0.0f;
                break;
            }
            case 1: {
                this.renderBook(matrixStack, buffer, light, overlay, visualBooks.get(0));
            }
        }
    }

    private void renderVertical(BookPileBlockTile tile, BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        int books = Math.min((Integer)state.func_177229_b((Property)BookPileBlock.BOOKS), tile.books.size());
        matrixStack.func_227861_a_(0.0, -0.375, 0.0);
        this.book.field_78808_h = 1.5707964f;
        for (int i = 0; i < books; ++i) {
            BookPileBlockTile.VisualBook b = tile.books.get(i);
            this.book.field_78795_f = b.getAngle();
            this.renderBook(matrixStack, buffer, light, overlay, b);
            matrixStack.func_227861_a_(0.0, 0.25, 0.0);
        }
        this.book.field_78795_f = 0.0f;
        this.book.field_78808_h = 0.0f;
    }

    private void renderBook(MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, BookPileBlockTile.VisualBook b) {
        IVertexBuilder builder = b.getBuilder(buffer);
        this.lock.field_78806_j = b.isEnchanted();
        this.book.func_228308_a_(matrixStack, builder, light, overlay);
    }
}

