/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.mehvahdjukaar.supplementaries.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.client.renderers.GlobeTextureManager;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class GlobeBlockTileRenderer
extends TileEntityRenderer<GlobeBlockTile> {
    private final ModelRenderer globe = new ModelRenderer(32, 16, 0, 0);
    private final ModelRenderer flat = new ModelRenderer(32, 32, 0, 0);
    private final ModelRenderer sheared = new ModelRenderer(32, 32, 0, 0);
    private final ModelRenderer snow = new ModelRenderer(32, 32, 0, 0);

    public GlobeBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        this.globe.func_228303_a_(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.0f, false);
        this.globe.func_78793_a(0.0f, 24.0f, 0.0f);
        this.flat.func_78793_a(0.0f, 24.0f, 0.0f);
        this.flat.func_78784_a(0, 0).func_228303_a_(-4.0f, -28.0f, -4.0f, 8.0f, 4.0f, 8.0f, 0.0f, false);
        this.flat.func_78784_a(0, 13).func_228303_a_(-4.0f, -24.0f, -4.0f, 8.0f, 2.0f, 8.0f, 0.0f, false);
        this.flat.func_78784_a(4, 23).func_228303_a_(-3.0f, -22.0f, -3.0f, 6.0f, 1.0f, 6.0f, 0.0f, false);
        this.flat.func_78784_a(8, 24).func_228303_a_(-2.0f, -21.0f, -2.0f, 4.0f, 1.0f, 4.0f, 0.0f, false);
        this.sheared.func_78793_a(0.0f, 24.0f, 0.0f);
        this.sheared.func_78784_a(0, 0).func_228303_a_(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 4.0f, 0.0f, false);
        this.sheared.func_78784_a(0, 12).func_228303_a_(0.0f, -28.0f, 0.0f, 4.0f, 8.0f, 4.0f, 0.0f, false);
        this.snow.func_78793_a(0.0f, 24.0f, 0.0f);
        this.snow.func_78784_a(0, 0).func_228303_a_(-4.0f, -28.0f, -4.0f, 8.0f, 5.0f, 8.0f, 0.0f, false);
        this.snow.func_78784_a(0, 14).func_228303_a_(-4.0f, -23.0f, -4.0f, 8.0f, 1.0f, 8.0f, 0.0f, false);
        this.snow.func_78784_a(4, 16).func_228303_a_(-3.0f, -22.0f, -3.0f, 6.0f, 1.0f, 6.0f, 0.0f, false);
        this.snow.func_78784_a(0, 17).func_228303_a_(-2.0f, -24.0f, -2.0f, 4.0f, 1.0f, 4.0f, 0.0f, false);
        this.snow.func_78784_a(0, 28).func_228303_a_(-1.0f, -25.975f, -1.0f, 2.0f, 2.0f, 2.0f, -0.05f, false);
        this.snow.func_78784_a(12, 20).func_228303_a_(-1.0f, -21.0f, -1.0f, 2.0f, 1.0f, 2.0f, 0.0f, false);
        ModelRenderer roof = new ModelRenderer(32, 32, 0, 0);
        roof.func_78793_a(0.0f, -25.9f, 0.0f);
        this.snow.func_78792_a(roof);
        ModelRenderer flat_r1 = new ModelRenderer(32, 32, 0, 0);
        flat_r1.func_78793_a(0.0f, 0.0f, 0.0f);
        roof.func_78792_a(flat_r1);
        flat_r1.field_78808_h = 0.7854f;
        flat_r1.func_78784_a(11, 27).func_228303_a_(0.0f, -1.0f, -1.0f, 2.0f, 1.0f, 2.0f, 0.0f, false);
        ModelRenderer flat_r2 = new ModelRenderer(32, 32, 0, 0);
        flat_r2.func_78793_a(0.0f, 0.0f, 0.0f);
        roof.func_78792_a(flat_r2);
        flat_r2.field_78808_h = -0.7854f;
        flat_r2.func_78784_a(0, 27).func_228303_a_(-2.0f, -1.0f, -1.0f, 3.0f, 1.0f, 2.0f, 0.0f, false);
    }

    public void render(GlobeBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ModelRenderer selected;
        ResourceLocation texture;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        matrixStackIn.func_227863_a_(Const.rot(tile.getDirection()));
        matrixStackIn.func_227863_a_(Const.XN90);
        matrixStackIn.func_227861_a_(0.0, 0.0625, 0.0);
        matrixStackIn.func_227863_a_(Const.XN22);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)(tile.prevYaw + (float)tile.face), (float)(tile.yaw + (float)tile.face))));
        matrixStackIn.func_227863_a_(Const.X180);
        ResourceLocation resourceLocation = texture = ClientConfigs.cached.GLOBE_RANDOM ? tile.texture : GlobeBlockTile.GlobeType.EARTH.texture;
        if (tile.sheared) {
            selected = this.sheared;
            texture = Textures.GLOBE_SHEARED_TEXTURE;
        } else if (tile.isFlat) {
            selected = this.flat;
            texture = Textures.GLOBE_FLAT_TEXTURE;
        } else {
            selected = tile.isSnow ? this.snow : this.globe;
        }
        IVertexBuilder builder = texture == null ? bufferIn.getBuffer(GlobeTextureManager.INSTANCE.getRenderType(tile.func_145831_w())) : bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)texture));
        selected.func_228309_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }
}

