/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BannerBlock;
import net.minecraft.item.BannerPatternItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class SupplementariesJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = Supplementaries.res("jei_plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(SupplementariesJEIPlugin.createTippedBambooSpikesRecipes(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createBlackboardDuplicate(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createRopeArrowCreateRecipe(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createRopeArrowAddRecipe(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createFlagFromBanner(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.makePresentCloringRecipes(), VanillaRecipeCategoryUid.CRAFTING);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModRegistry.BAMBOO_SPIKES_TIPPED_ITEM.get(), (ISubtypeInterpreter)SpikesSubtypeInterpreter.INSTANCE);
    }

    public static List<IRecipe<?>> makePresentCloringRecipes() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.presents";
        Ingredient baseShulkerIngredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModRegistry.PRESENTS_ITEMS.get(null).get()});
        for (DyeColor color : DyeColor.values()) {
            DyeItem dye = DyeItem.func_195961_a((DyeColor)color);
            ItemStack output = ((Item)ModRegistry.PRESENTS_ITEMS.get(color).get()).func_190903_i();
            NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{baseShulkerIngredient, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{dye})});
            ResourceLocation id = Supplementaries.res("jei_present_" + color.func_176762_d());
            recipes.add((IRecipe<?>)new ShapelessRecipe(id, group, output, inputs));
        }
        return recipes;
    }

    public static List<IRecipe<?>> createRopeArrowCreateRecipe() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.rope_arrow";
        ItemStack ropeArrow = new ItemStack((IItemProvider)ModRegistry.ROPE_ARROW_ITEM.get());
        ropeArrow.func_196085_b(ropeArrow.func_77958_k() - 4);
        Ingredient arrow = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151032_g)});
        Ingredient rope = Ingredient.func_199805_a(ModTags.ROPES);
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{arrow, rope, rope, rope, rope});
        ResourceLocation id = new ResourceLocation("supplementaries", "rope_arrow_create");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, ropeArrow, inputs);
        recipes.add((IRecipe<?>)recipe);
        return recipes;
    }

    public static List<IRecipe<?>> createRopeArrowAddRecipe() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.rope_arrow";
        ItemStack ropeArrow = new ItemStack((IItemProvider)ModRegistry.ROPE_ARROW_ITEM.get());
        ItemStack ropeArrow2 = ropeArrow.func_77946_l();
        ropeArrow2.func_196085_b(8);
        Ingredient arrow = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ropeArrow2});
        Ingredient rope = Ingredient.func_199805_a(ModTags.ROPES);
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{rope, rope, rope, rope, arrow, rope, rope, rope, rope});
        ResourceLocation id = new ResourceLocation("supplementaries", "rope_arrow_add");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, ropeArrow, inputs);
        recipes.add((IRecipe<?>)recipe);
        return recipes;
    }

    public static List<IRecipe<?>> createTippedBambooSpikesRecipes() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.tipped_spikes";
        for (Potion potionType : ForgeRegistries.POTION_TYPES.getValues()) {
            if (potionType.func_185170_a().isEmpty()) continue;
            recipes.add((IRecipe<?>)SupplementariesJEIPlugin.makeSpikeRecipe(potionType, group));
        }
        return recipes;
    }

    private static ShapelessRecipe makeSpikeRecipe(Potion potionType, String group) {
        ItemStack spikes = new ItemStack((IItemProvider)ModRegistry.BAMBOO_SPIKES_ITEM.get());
        ItemStack lingeringPotion = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)potionType);
        Ingredient spikeIngredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{spikes});
        Ingredient potionIngredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{lingeringPotion});
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{spikeIngredient, potionIngredient});
        ItemStack output = BambooSpikesTippedItem.makeSpikeItem(potionType);
        ResourceLocation id = new ResourceLocation("supplementaries", potionType.func_185174_b("jei.tipped_spikes."));
        return new ShapelessRecipe(id, group, output, inputs);
    }

    public static List<IRecipe<?>> createFlagFromBanner() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.flag_from_banner";
        for (DyeColor color : DyeColor.values()) {
            ItemStack banner = new ItemStack((IItemProvider)BannerBlock.func_196287_a((DyeColor)color).func_199767_j());
            ItemStack fullFlag = new ItemStack((IItemProvider)ModRegistry.FLAGS.get(color).get());
            ListNBT list = new ListNBT();
            CompoundNBT compoundnbt1 = new CompoundNBT();
            compoundnbt1.func_74778_a("Pattern", ((BannerPatternItem)Items.field_222098_pE).func_219980_b().func_190993_b());
            compoundnbt1.func_74768_a("Color", color == DyeColor.WHITE ? DyeColor.BLACK.func_196059_a() : DyeColor.WHITE.func_196059_a());
            list.add((Object)compoundnbt1);
            CompoundNBT com = banner.func_190925_c("BlockEntityTag");
            com.func_218657_a("Patterns", (INBT)list);
            CompoundNBT com2 = fullFlag.func_190925_c("BlockEntityTag");
            com2.func_218657_a("Patterns", (INBT)list);
            Ingredient emptyFlag = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModRegistry.FLAGS.get(color).get())});
            NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{emptyFlag, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{banner})});
            ResourceLocation id = new ResourceLocation("supplementaries", "flag_from_banner");
            ShapelessRecipe recipe = new ShapelessRecipe(id, group, fullFlag, inputs);
            recipes.add((IRecipe<?>)recipe);
        }
        return recipes;
    }

    public static List<IRecipe<?>> createBlackboardDuplicate() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.blackboard_duplicate";
        ItemStack blackboard = new ItemStack((IItemProvider)ModRegistry.BLACKBOARD_ITEM.get());
        CompoundNBT com = new CompoundNBT();
        byte[][] pixels = new byte[][]{{0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0}};
        com.func_197644_a("Pixels", BlackboardBlockTile.packPixels(pixels));
        blackboard.func_77983_a("BlockEntityTag", (INBT)com);
        Ingredient emptyBoard = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModRegistry.BLACKBOARD_ITEM.get())});
        Ingredient fullBoard = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{blackboard});
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{emptyBoard, fullBoard});
        ResourceLocation id = new ResourceLocation("supplementaries", "blackboard_duplicate");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, blackboard, inputs);
        recipes.add((IRecipe<?>)recipe);
        return recipes;
    }

    public static ItemStack getSans() {
        ItemStack blackboard = new ItemStack((IItemProvider)ModRegistry.BLACKBOARD_ITEM.get());
        CompoundNBT com = new CompoundNBT();
        byte[][] pixels = new byte[][]{{0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 3, 0, 0, 0, 1, 1, 1, 0, 1}, {0, 1, 0, 0, 0, 3, 3, 3, 3, 0, 0, 1, 0, 1, 0, 1}, {0, 1, 0, 0, 3, 0, 3, 0, 3, 0, 0, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 0, 0, 3, 3, 3, 0, 1, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0}};
        com.func_197644_a("Pixels", BlackboardBlockTile.packPixels(pixels));
        blackboard.func_77983_a("BlockEntityTag", (INBT)com);
        return blackboard;
    }

    public static List<IRecipe<?>> createBlackboardClear() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.blackboard_clear";
        ItemStack blackboard = SupplementariesJEIPlugin.getSans();
        Ingredient emptyBoard = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151131_as)});
        Ingredient fullBoard = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{blackboard});
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{emptyBoard, fullBoard});
        ResourceLocation id = new ResourceLocation("supplementaries", "blackboard_clear");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, new ItemStack((IItemProvider)ModRegistry.BLACKBOARD_ITEM.get()), inputs);
        recipes.add((IRecipe<?>)recipe);
        return recipes;
    }

    public static class SpikesSubtypeInterpreter
    implements ISubtypeInterpreter {
        public static final SpikesSubtypeInterpreter INSTANCE = new SpikesSubtypeInterpreter();

        private SpikesSubtypeInterpreter() {
        }

        public String apply(ItemStack itemStack) {
            Potion potionType = PotionUtils.func_185191_c((ItemStack)itemStack);
            String potionTypeString = potionType.func_185174_b("");
            StringBuilder stringBuilder = new StringBuilder(potionTypeString);
            List effects = PotionUtils.func_185189_a((ItemStack)itemStack);
            for (EffectInstance effect : effects) {
                stringBuilder.append(";").append(effect);
            }
            return stringBuilder.toString();
        }
    }
}

