/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client;

import java.util.Optional;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.widgets.TextField;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.Reloadable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public interface REIRuntime
extends Reloadable<REIClientPlugin> {
    public static REIRuntime getInstance() {
        return PluginManager.getClientInstance().get(REIRuntime.class);
    }

    public boolean isOverlayVisible();

    public void toggleOverlayVisible();

    default public Optional<ScreenOverlay> getOverlay() {
        return this.getOverlay(false, false);
    }

    default public Optional<ScreenOverlay> getOverlay(boolean reset) {
        return this.getOverlay(reset, true);
    }

    public Optional<ScreenOverlay> getOverlay(boolean var1, boolean var2);

    @Nullable
    public ContainerScreen<?> getPreviousContainerScreen();

    @Nullable
    public Screen getPreviousScreen();

    public boolean isDarkThemeEnabled();

    @Nullable
    public TextField getSearchTextField();

    public void queueTooltip(@Nullable Tooltip var1);

    public ResourceLocation getDefaultDisplayTexture();

    public ResourceLocation getDefaultDisplayTexture(boolean var1);

    public SearchFieldLocation getContextualSearchFieldLocation();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    default public Rectangle calculateEntryListArea() {
        return this.calculateEntryListArea(ScreenRegistry.getInstance().getOverlayBounds(ConfigObject.getInstance().getDisplayPanelLocation(), Minecraft.func_71410_x().field_71462_r));
    }

    public Rectangle calculateEntryListArea(Rectangle var1);

    public Rectangle calculateFavoritesListArea();
}

