/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.widgets;

import com.google.common.collect.AbstractIterator;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.shedaniel.math.Dimension;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetHolder;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.impl.ClientInternals;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class Widgets {
    private Widgets() {
    }

    public static Widget createDrawableWidget(DrawableConsumer drawable) {
        return ClientInternals.getWidgetsProvider().createDrawableWidget(drawable);
    }

    public static Widget wrapVanillaWidget(IGuiEventListener element) {
        return new VanillaWrappedWidget(element);
    }

    public static WidgetWithBounds withTranslate(Widget widget, double x, double y, double z) {
        return Widgets.withTranslate(widget, Matrix4f.func_226599_b_((float)((float)x), (float)((float)y), (float)((float)z)));
    }

    public static WidgetWithBounds withTranslate(Widget widget, Matrix4f translate) {
        WidgetWithBounds widgetWithBounds = Widgets.wrapWidgetWithBounds(widget);
        return new WidgetWithBoundsWithTranslate(widgetWithBounds, () -> translate);
    }

    public static <T extends Widget> WidgetWithBounds withTranslate(T widget, Function<T, Matrix4f> translate) {
        WidgetWithBounds widgetWithBounds = Widgets.wrapWidgetWithBounds(widget);
        return new WidgetWithBoundsWithTranslate(widgetWithBounds, () -> (Matrix4f)translate.apply(widget));
    }

    public static WidgetWithBounds withTranslate(Widget widget, Supplier<Matrix4f> translate) {
        WidgetWithBounds widgetWithBounds = Widgets.wrapWidgetWithBounds(widget);
        return new WidgetWithBoundsWithTranslate(widgetWithBounds, translate);
    }

    public static WidgetWithBounds wrapRenderer(Rectangle bounds, Renderer renderer) {
        if (renderer instanceof Widget) {
            return Widgets.wrapWidgetWithBounds((Widget)renderer, bounds);
        }
        return new RendererWrappedWidget(renderer, bounds);
    }

    public static WidgetWithBounds wrapWidgetWithBounds(Widget widget) {
        return Widgets.wrapWidgetWithBounds(widget, null);
    }

    public static WidgetWithBounds wrapWidgetWithBounds(Widget widget, Rectangle bounds) {
        if (widget instanceof WidgetWithBounds) {
            return (WidgetWithBounds)widget;
        }
        if (bounds == null) {
            return new DelegateWidget(widget);
        }
        return new DelegateWidgetWithBounds(widget, bounds);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, Rectangle bounds) {
        return Widgets.createTexturedWidget(identifier, bounds, 0.0f, 0.0f);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, int x, int y, int width, int height) {
        return Widgets.createTexturedWidget(identifier, x, y, 0.0f, 0.0f, width, height);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, Rectangle bounds, float u, float v) {
        return Widgets.createTexturedWidget(identifier, bounds, u, v, 256, 256);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, int x, int y, float u, float v, int width, int height) {
        return Widgets.createTexturedWidget(identifier, x, y, u, v, width, height, 256, 256);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, Rectangle bounds, float u, float v, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, bounds.x, bounds.y, u, v, bounds.width, bounds.height, bounds.width, bounds.height, textureWidth, textureHeight);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, x, y, u, v, width, height, width, height, textureWidth, textureHeight);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, Rectangle bounds, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, bounds.x, bounds.y, u, v, bounds.width, bounds.height, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, int x, int y, float u, float v, int width, int height, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        return Widgets.createDrawableWidget(ClientInternals.getWidgetsProvider().createTexturedConsumer(identifier, x, y, width, height, u, v, uWidth, vHeight, textureWidth, textureHeight));
    }

    public static Widget createFilledRectangle(Rectangle rectangle, int color) {
        return Widgets.createDrawableWidget(ClientInternals.getWidgetsProvider().createFillRectangleConsumer(rectangle, color));
    }

    public static Label createLabel(Point point, ITextComponent text) {
        return ClientInternals.getWidgetsProvider().createLabel(point, (ITextProperties)text);
    }

    public static Label createClickableLabel(Point point, ITextComponent text, @Nullable Consumer<Label> onClick) {
        return Widgets.createLabel(point, text).clickable().onClick(onClick);
    }

    public static Arrow createArrow(Point point) {
        return ClientInternals.getWidgetsProvider().createArrow(new Rectangle(point, new Dimension(24, 17)));
    }

    public static BurningFire createBurningFire(Point point) {
        return ClientInternals.getWidgetsProvider().createBurningFire(new Rectangle(point, new Dimension(14, 14)));
    }

    public static Widget createSlotBackground(Point point) {
        return Widgets.createSlotBase(new Rectangle(point.x - 1, point.y - 1, 18, 18));
    }

    public static Widget createResultSlotBackground(Point point) {
        return Widgets.createSlotBase(new Rectangle(point.x - 5, point.y - 5, 26, 26));
    }

    public static Panel createCategoryBase(Rectangle rectangle) {
        return ClientInternals.getWidgetsProvider().createPanelWidget(rectangle);
    }

    public static Panel createCategoryBase(Rectangle rectangle, int color) {
        return Widgets.createCategoryBase(rectangle).color(color);
    }

    public static Panel createRecipeBase(Rectangle rectangle) {
        return ClientInternals.getWidgetsProvider().createPanelWidget(rectangle).yTextureOffset(ConfigObject.getInstance().getRecipeBorderType().getYOffset()).rendering(Widgets::shouldRecipeBaseRender);
    }

    public static Panel createRecipeBase(Rectangle rectangle, int color) {
        return Widgets.createRecipeBase(rectangle).color(color);
    }

    private static boolean shouldRecipeBaseRender(Panel panel) {
        return ConfigObject.getInstance().getRecipeBorderType().isRendering() && ClientInternals.getWidgetsProvider().isRenderingPanel(panel);
    }

    public static Panel createSlotBase(Rectangle rectangle) {
        return ClientInternals.getWidgetsProvider().createPanelWidget(rectangle).yTextureOffset(-66).rendering(Widgets::shouldSlotBaseRender);
    }

    private static boolean shouldSlotBaseRender(Panel panel) {
        return true;
    }

    public static Panel createSlotBase(Rectangle rectangle, int color) {
        return Widgets.createSlotBase(rectangle).color(color);
    }

    public static Slot createSlot(Point point) {
        return ClientInternals.getWidgetsProvider().createSlot(point);
    }

    public static Slot createSlot(Rectangle bounds) {
        return ClientInternals.getWidgetsProvider().createSlot(bounds);
    }

    public static Button createButton(Rectangle bounds, ITextComponent text) {
        return ClientInternals.getWidgetsProvider().createButton(bounds, text);
    }

    public static void produceClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public static <T> Iterable<T> walk(final Iterable<? extends IGuiEventListener> listeners, final Predicate<IGuiEventListener> predicate) {
        return () -> new AbstractIterator<T>(){
            Stack<Iterator<? extends IGuiEventListener>> stack = new Stack();
            {
                this.stack.push(listeners.iterator());
            }

            protected T computeNext() {
                while (!this.stack.empty()) {
                    List<? extends IGuiEventListener> children;
                    Iterator<? extends IGuiEventListener> peek = this.stack.peek();
                    if (!peek.hasNext()) {
                        this.stack.pop();
                    }
                    if (this.stack.isEmpty()) break;
                    IGuiEventListener listener = peek.next();
                    if (!peek.hasNext()) {
                        this.stack.pop();
                    }
                    if (predicate.test(listener)) {
                        return listener;
                    }
                    if (listener instanceof INestedGuiEventHandler) {
                        children = ((INestedGuiEventHandler)listener).func_231039_at__();
                        if (children.isEmpty()) continue;
                        this.stack.push(children.iterator());
                        continue;
                    }
                    if (!(listener instanceof WidgetHolder) || (children = ((WidgetHolder)listener).children()).isEmpty()) continue;
                    this.stack.push(children.iterator());
                }
                return this.endOfData();
            }
        };
    }

    private static class VanillaWrappedWidget
    extends Widget {
        private IGuiEventListener element;

        public VanillaWrappedWidget(IGuiEventListener element) {
            this.element = Objects.requireNonNull(element);
            this.func_231035_a_(element);
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            if (this.element instanceof AbstractGui) {
                ((AbstractGui)this.element).func_230926_e_(this.getZ());
            }
            if (this.element instanceof IRenderable) {
                ((IRenderable)this.element).func_230430_a_(matrices, mouseX, mouseY, delta);
            }
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.singletonList(this.element);
        }

        @Override
        @Nullable
        public IGuiEventListener func_241217_q_() {
            return this.element;
        }

        @Override
        public void func_231035_a_(@Nullable IGuiEventListener guiEventListener) {
            if (guiEventListener == this.element) {
                super.func_231035_a_(this.element);
            } else if (this.element instanceof INestedGuiEventHandler) {
                ((INestedGuiEventHandler)this.element).func_231035_a_(guiEventListener);
            }
        }

        @Override
        public boolean func_231041_ay__() {
            return true;
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return this.element.func_231047_b_(mouseX, mouseY);
        }
    }

    private static class WidgetWithBoundsWithTranslate
    extends DelegateWidget {
        private final Supplier<Matrix4f> translate;

        private WidgetWithBoundsWithTranslate(WidgetWithBounds widget, Supplier<Matrix4f> translate) {
            super(widget);
            this.translate = translate;
        }

        @Override
        public void func_230430_a_(MatrixStack poseStack, int i, int j, float f) {
            poseStack.func_227860_a_();
            poseStack.func_227866_c_().func_227870_a_().func_226595_a_(this.translate.get());
            Vector4f mouse = this.transformMouse(i, j);
            super.func_230430_a_(poseStack, (int)mouse.func_195910_a(), (int)mouse.func_195913_b(), f);
            poseStack.func_227865_b_();
        }

        private Vector4f transformMouse(double mouseX, double mouseY) {
            Vector4f mouse = new Vector4f((float)mouseX, (float)mouseY, 0.0f, 1.0f);
            mouse.func_229372_a_(this.translate.get());
            return mouse;
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            Vector4f mouse = this.transformMouse(mouseX, mouseY);
            return super.containsMouse(mouse.func_195910_a(), mouse.func_195913_b());
        }

        public boolean func_231044_a_(double d, double e, int i) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.func_231044_a_((double)mouse.func_195910_a(), (double)mouse.func_195913_b(), i);
        }

        public boolean func_231048_c_(double d, double e, int i) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.func_231048_c_((double)mouse.func_195910_a(), (double)mouse.func_195913_b(), i);
        }

        public boolean func_231045_a_(double d, double e, int i, double f, double g) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.func_231045_a_((double)mouse.func_195910_a(), (double)mouse.func_195913_b(), i, f, g);
        }

        public boolean func_231043_a_(double d, double e, double f) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.func_231043_a_((double)mouse.func_195910_a(), (double)mouse.func_195913_b(), f);
        }
    }

    private static class RendererWrappedWidget
    extends WidgetWithBounds {
        private final Renderer renderer;
        private final Rectangle bounds;

        public RendererWrappedWidget(Renderer renderer, Rectangle bounds) {
            this.renderer = Objects.requireNonNull(renderer);
            this.bounds = Objects.requireNonNull(bounds);
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            this.renderer.render(matrices, this.getBounds(), mouseX, mouseY, delta);
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            if (this.renderer instanceof IGuiEventListener) {
                return Collections.singletonList((IGuiEventListener)this.renderer);
            }
            return Collections.emptyList();
        }

        @Override
        public void setZ(int z) {
            this.renderer.setZ(z);
        }

        @Override
        public int getZ() {
            return this.renderer.getZ();
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }
    }

    private static class DelegateWidgetWithBounds
    extends DelegateWidget {
        private final Rectangle bounds;

        public DelegateWidgetWithBounds(Widget widget, Rectangle bounds) {
            super(widget);
            this.bounds = bounds;
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }
    }
}

