/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.screen;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.impl.ClientInternals;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
@OnlyIn(value=Dist.CLIENT)
public interface ClickArea<T extends Screen> {
    public Result handle(ClickAreaContext<T> var1);

    @ApiStatus.NonExtendable
    public static interface Result {
        public static Result success() {
            return ClientInternals.createClickAreaHandlerResult(true);
        }

        public static Result fail() {
            return ClientInternals.createClickAreaHandlerResult(false);
        }

        @ApiStatus.Experimental
        public Result executor(BooleanSupplier var1);

        public Result category(CategoryIdentifier<?> var1);

        default public Result categories(Iterable<? extends CategoryIdentifier<?>> categories) {
            for (CategoryIdentifier<?> category : categories) {
                this.category(category);
            }
            return this;
        }

        @ApiStatus.Experimental
        public Result tooltip(Supplier<ITextComponent @Nullable []> var1);

        public boolean isSuccessful();

        @ApiStatus.Experimental
        public boolean execute();

        @ApiStatus.Experimental
        public ITextComponent @Nullable [] getTooltips();

        public Stream<CategoryIdentifier<?>> getCategories();
    }

    @ApiStatus.NonExtendable
    public static interface ClickAreaContext<T extends Screen> {
        public T getScreen();

        public Point getMousePosition();
    }
}

