/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.entry.comparison;

import java.util.Objects;
import me.shedaniel.architectury.fluid.FluidStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.impl.Internals;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

@FunctionalInterface
public interface EntryComparator<T> {
    public static <T> EntryComparator<T> noop() {
        return (context, stack) -> 1L;
    }

    public static EntryComparator<ItemStack> itemNbt() {
        EntryComparator<INBT> nbtHasher = EntryComparator.nbt("Count");
        return (context, stack) -> {
            CompoundNBT tag = stack.func_77978_p();
            return tag == null ? 0L : nbtHasher.hash(context, (INBT)tag);
        };
    }

    public static EntryComparator<FluidStack> fluidNbt() {
        EntryComparator<INBT> nbtHasher = EntryComparator.nbt("Amount");
        return (context, stack) -> {
            CompoundNBT tag = stack.getTag();
            return tag == null ? 0L : nbtHasher.hash(context, (INBT)tag);
        };
    }

    public static EntryComparator<INBT> nbt(String ... ignoredKeys) {
        return Internals.getNbtHasher(ignoredKeys);
    }

    public long hash(ComparisonContext var1, T var2);

    default public EntryComparator<T> onlyExact() {
        EntryComparator self = this;
        return (context, stack) -> context.isExact() ? self.hash(context, stack) : 1L;
    }

    default public EntryComparator<T> then(EntryComparator<T> other) {
        Objects.requireNonNull(other);
        EntryComparator self = this;
        return (context, stack) -> {
            long hash = 1L;
            hash = hash * 31L + self.hash(context, stack);
            hash = hash * 31L + other.hash(context, stack);
            return hash;
        };
    }
}

