/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.forge;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsInitializer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.TriConsumer;
import org.objectweb.asm.Type;

public class AnnotationUtils {
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"REI");

    public static <A, T> void scanAnnotation(Class<A> clazz, Predicate<Class<T>> predicate, TriConsumer<List<String>, Supplier<T>, Class<T>> consumer) {
        AnnotationUtils.scanAnnotation(Type.getType(clazz), predicate, consumer);
    }

    public static <T> void scanAnnotation(Type annotationType, Predicate<Class<T>> predicate, TriConsumer<List<String>, Supplier<T>, Class<T>> consumer) {
        ArrayList instances = Lists.newArrayList();
        for (ModFileScanData data : ModList.get().getAllScanData()) {
            List modIds = data.getIModInfoData().stream().flatMap(info -> info.getMods().stream()).map(IModInfo::getModId).collect(Collectors.toList());
            block3: for (ModFileScanData.AnnotationData annotation : data.getAnnotations()) {
                Object value = annotation.getAnnotationData().get("value");
                boolean enabled = value instanceof Dist[] ? Arrays.asList((Dist[])value).contains(FMLEnvironment.dist) : true;
                if (!enabled || !annotationType.equals((Object)annotation.getAnnotationType())) continue;
                try {
                    Class<?> clazz = Class.forName(annotation.getMemberName());
                    if (!predicate.test(clazz)) continue;
                    instances.add(new ImmutableTriple(modIds, () -> {
                        try {
                            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Throwable throwable) {
                            LOGGER.error("Failed to load plugin: " + annotation.getMemberName(), throwable);
                            return null;
                        }
                    }, clazz));
                }
                catch (Throwable throwable) {
                    for (Throwable t = throwable; t != null; t = t.getCause()) {
                        if (t.getMessage() == null || !t.getMessage().contains("invalid dist DEDICATED_SERVER") || RoughlyEnoughItemsInitializer.isClient()) continue;
                        LOGGER.warn("Plugin " + annotation.getMemberName() + " is attempting to load on the server, but is not compatible with the server. The mod should declare the environments it is compatible with in the @" + annotationType.getClassName() + " annotation.");
                        continue block3;
                    }
                    LOGGER.error("Failed to load plugin: " + annotation.getMemberName(), throwable);
                }
            }
        }
        for (Triple pair : instances) {
            consumer.accept((Object)((List)pair.getLeft()), (Object)((Supplier)pair.getMiddle()), (Object)((Class)pair.getRight()));
        }
    }
}

