/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.mojang.serialization.DataResult;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ClientInternals {
    private static Supplier<ClientHelper> clientHelper = ClientInternals::throwNotSetup;
    private static Supplier<WidgetsProvider> widgetsProvider = ClientInternals::throwNotSetup;
    private static Supplier<ViewSearchBuilder> viewSearchBuilder = ClientInternals::throwNotSetup;
    private static Supplier<PluginManager<REIClientPlugin>> clientPluginManager = ClientInternals::throwNotSetup;
    private static Supplier<EntryRenderer<?>> emptyEntryRenderer = ClientInternals::throwNotSetup;
    private static BiFunction<Supplier<DataResult<FavoriteEntry>>, Supplier<CompoundNBT>, FavoriteEntry> delegateFavoriteEntry = (supplier, toJson) -> (FavoriteEntry)ClientInternals.throwNotSetup();
    private static Function<CompoundNBT, DataResult<FavoriteEntry>> favoriteEntryFromJson = object -> (DataResult)ClientInternals.throwNotSetup();
    private static Function<Boolean, ClickArea.Result> clickAreaHandlerResult = result -> (ClickArea.Result)ClientInternals.throwNotSetup();
    private static BiFunction<@Nullable Point, Collection<ITextComponent>, Tooltip> tooltipProvider = (point, texts) -> (Tooltip)ClientInternals.throwNotSetup();
    private static Supplier<List<String>> jeiCompatMods = ClientInternals::throwNotSetup;
    private static Supplier<Object> builtinClientPlugin = ClientInternals::throwNotSetup;

    private static <T> T throwNotSetup() {
        throw new AssertionError((Object)"REI Internals have not been initialized!");
    }

    @ApiStatus.Internal
    public static <T> void attachInstance(T instance, Class<T> clazz) {
        ClientInternals.attachInstanceSupplier(instance, clazz.getSimpleName());
    }

    @ApiStatus.Internal
    public static <T> void attachInstanceSupplier(T instance, String name) {
        ClientInternals.attachInstance(() -> instance, name);
    }

    public static <T> void attachInstance(T instance, String name) {
        try {
            for (Field field : ClientInternals.class.getDeclaredFields()) {
                if (!field.getName().equalsIgnoreCase(name)) continue;
                field.setAccessible(true);
                field.set(null, instance);
                return;
            }
            throw new RuntimeException("Failed to attach " + instance + " with field name: " + name);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClientHelper getClientHelper() {
        return clientHelper.get();
    }

    public static WidgetsProvider getWidgetsProvider() {
        return widgetsProvider.get();
    }

    public static ViewSearchBuilder createViewSearchBuilder() {
        return viewSearchBuilder.get();
    }

    public static Object getBuiltinPlugin() {
        return builtinClientPlugin.get();
    }

    public static ClickArea.Result createClickAreaHandlerResult(boolean applicable) {
        return clickAreaHandlerResult.apply(applicable);
    }

    public static Tooltip createTooltip(@Nullable Point point, Collection<ITextComponent> texts) {
        return tooltipProvider.apply(point, texts);
    }

    public static FavoriteEntry delegateFavoriteEntry(Supplier<DataResult<FavoriteEntry>> supplier, Supplier<CompoundNBT> toJoin) {
        return delegateFavoriteEntry.apply(supplier, toJoin);
    }

    public static DataResult<FavoriteEntry> favoriteEntryFromJson(CompoundNBT tag) {
        return favoriteEntryFromJson.apply(tag);
    }

    public static <T> EntryRenderer<T> getEmptyEntryRenderer() {
        return emptyEntryRenderer.get().cast();
    }

    public static List<String> getJeiCompatMods() {
        return jeiCompatMods.get();
    }

    public static PluginManager<REIClientPlugin> getPluginManager() {
        return clientPluginManager.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface WidgetsProvider {
        public boolean isRenderingPanel(Panel var1);

        public Widget createDrawableWidget(DrawableConsumer var1);

        public Slot createSlot(Point var1);

        public Slot createSlot(Rectangle var1);

        public Button createButton(Rectangle var1, ITextComponent var2);

        public Panel createPanelWidget(Rectangle var1);

        public Label createLabel(Point var1, ITextProperties var2);

        public Arrow createArrow(Rectangle var1);

        public BurningFire createBurningFire(Rectangle var1);

        public DrawableConsumer createTexturedConsumer(ResourceLocation var1, int var2, int var3, int var4, int var5, float var6, float var7, int var8, int var9, int var10, int var11);

        public DrawableConsumer createFillRectangleConsumer(Rectangle var1, int var2);
    }
}

