/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.changelog;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class JParseDown {
    public static final String version = "1.0.4";
    public static String regexHtmlAttribute = "[a-zA-Z_:][\\w:.-]*+(?:\\s*+=\\s*+(?:[^\"\\'=<>`\\s]+|\"[^\"]*+\"|\\'[^\\']*+\\'))?+";
    public static Pattern[] strongRegex = new Pattern[]{Pattern.compile("^[*]{2}((?:\\\\\\*|[^*]|[*][^*]*+[*])+?)[*]{2}(?![*])", 32), Pattern.compile("^__((?:\\\\_|[^_]|_[^_]*+_)+?)__(?!_)", 288)};
    public static Pattern[] emRegex = new Pattern[]{Pattern.compile("^[*]((?:\\\\\\*|[^*]|[*][*][^*]+?[*][*])+?)[*](?![*])", 32), Pattern.compile("^_((?:\\\\_|[^_]|__[^_]*__)+?)_(?!_)\\b", 288)};
    public static String specialCharacters = "\\`*_{}[]()>#+-.!|~";
    public boolean breaksEnabled = false;
    public boolean markupEscaped = false;
    public boolean urlsLinked = true;
    public boolean safeMode = false;
    public boolean strictMode = false;
    public String mdUrlReplacement = null;
    public HashMap<String, ReferenceData> referenceDefinitions = new HashMap();
    public Pattern inlineMarkerList = Pattern.compile("[!\\*_&\\[:<`~\\\\]");

    public LinkedList<Block> textElements(String text) {
        text = text.replaceAll("\\r\\n?", "\n");
        text = text.replaceAll("(^\\n+)|(\\n+$)", "");
        String[] lines = text.split("\n");
        return this.linesElements(lines);
    }

    public JParseDown setBreaksEnabled(boolean breaksEnabled) {
        this.breaksEnabled = breaksEnabled;
        return this;
    }

    public JParseDown setMarkupEscaped(boolean markupEscaped) {
        this.markupEscaped = markupEscaped;
        return this;
    }

    public JParseDown setUrlsLinked(boolean urlsLinked) {
        this.urlsLinked = urlsLinked;
        return this;
    }

    public JParseDown setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
        return this;
    }

    public JParseDown setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
        return this;
    }

    public JParseDown setMdUrlReplacement(String replacement) {
        this.mdUrlReplacement = replacement;
        return this;
    }

    public void getBlockTypes(char marker, LinkedList<BlockType<?>> types) {
        switch (marker) {
            case '#': {
                types.add(BlockHeader::startBlock);
                return;
            }
            case '+': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                types.add(BlockList::startBlock);
                return;
            }
            case '-': {
                types.add(BlockRule::startBlock);
                types.add(BlockList::startBlock);
                return;
            }
            case '>': {
                types.add(BlockQuote::startBlock);
                return;
            }
            case '[': {
                types.add(BlockReference::startBlock);
                return;
            }
            case '_': {
                types.add(BlockRule::startBlock);
                return;
            }
            case '`': 
            case '~': {
                types.add(BlockFencedCode::startBlock);
                return;
            }
        }
    }

    public void getUnmarkedBlockTypes(LinkedList<BlockType<?>> types) {
        types.add(BlockCode::startBlock);
    }

    public LinkedList<Block> linesElements(LinkedList<String> lines) {
        return this.linesElements(lines.toArray(new String[0]));
    }

    public LinkedList<Block> linesElements(String[] lines) {
        LinkedList<Block> elements = new LinkedList<Block>();
        Block currentBlock = null;
        block0: for (String line : lines) {
            int tabIndex;
            if (line.trim().isEmpty()) {
                if (currentBlock == null) continue;
                ++currentBlock.interrupted;
                continue;
            }
            while ((tabIndex = line.indexOf(9)) >= 0) {
                int shortage = 4 - tabIndex % 4;
                StringBuilder sb = new StringBuilder();
                sb.append(line.substring(0, tabIndex));
                for (int i = 0; i < shortage; ++i) {
                    sb.append(' ');
                }
                sb.append(line.substring(tabIndex + 1));
                line = sb.toString();
            }
            Line lineObj = new Line(line);
            if (currentBlock != null && currentBlock.isContinuable()) {
                Block block = currentBlock.continueBlock(lineObj);
                if (block != null) {
                    currentBlock = block;
                    continue;
                }
                if (currentBlock.isCompletable()) {
                    currentBlock = currentBlock.completeBlock();
                }
            }
            LinkedList blockTypes = new LinkedList();
            this.getUnmarkedBlockTypes(blockTypes);
            this.getBlockTypes(lineObj.text.charAt(0), blockTypes);
            for (BlockType blockType : blockTypes) {
                Block block = blockType.startBlock(this, lineObj, currentBlock);
                if (block == null) continue;
                if (!block.identified) {
                    if (currentBlock != null) {
                        elements.add(currentBlock);
                    }
                    block.identified = true;
                }
                currentBlock = block;
                continue block0;
            }
            Block block = null;
            if (currentBlock instanceof BlockParagraph) {
                block = currentBlock.continueBlock(lineObj);
            }
            if (block != null) {
                currentBlock = block;
                continue;
            }
            if (currentBlock != null) {
                elements.add(currentBlock);
            }
            currentBlock = BlockParagraph.startBlock(this, lineObj, null);
            currentBlock.identified = true;
        }
        if (currentBlock != null && currentBlock.isContinuable() && currentBlock.isCompletable()) {
            currentBlock = currentBlock.completeBlock();
        }
        if (currentBlock != null) {
            elements.add(currentBlock);
        }
        for (Block element : elements) {
            element.inlines = new LinkedList<Inline>(element.inline(this));
            if (element.autoBreak != null) continue;
            element.autoBreak = false;
        }
        return elements;
    }

    public InlineType<?>[] getInlineTypes(char marker) {
        switch (marker) {
            case '!': {
                return new InlineType[]{InlineImage::inline};
            }
            case '&': {
                return new InlineType[]{InlineSpecialCharacter::inline};
            }
            case '*': {
                return new InlineType[]{InlineBold::inline};
            }
            case ':': {
                return new InlineType[]{InlineUrl::inline};
            }
            case '<': {
                return new InlineType[]{InlineUrlTag::inline, InlineEmailTag::inline, InlineMarkup::inline};
            }
            case '[': {
                return new InlineType[]{InlineLink::inline};
            }
            case '_': {
                return new InlineType[]{InlineBold::inline};
            }
            case '`': {
                return new InlineType[]{InlineCode::inline};
            }
            case '~': {
                return new InlineType[]{InlineStrikeThrough::inline};
            }
            case '\\': {
                return new InlineType[]{(parseDown, text, context) -> {
                    if (text.length() >= 2 && text.charAt(0) == '\\' && text.charAt(1) == 'n') {
                        return new InlineLineBreak().setExtent(2);
                    }
                    return null;
                }};
            }
        }
        return new InlineType[0];
    }

    public LinkedList<Inline> lineElements(String text, HashSet<Class<?>> nonNestables) {
        Matcher m;
        text = text.replaceAll("\\r\\n?", "\n");
        LinkedList<Inline> elements = new LinkedList<Inline>();
        if (nonNestables == null) {
            nonNestables = new HashSet();
        }
        block0: while ((m = this.inlineMarkerList.matcher(text)).find()) {
            int markerPosition = m.start();
            String excerpt = text.substring(markerPosition);
            for (InlineType<?> inlineType : this.getInlineTypes(excerpt.charAt(0))) {
                Inline inline;
                if (nonNestables.contains(inlineType.getClass()) || (inline = inlineType.inline(this, excerpt, text)) == null || inline.position >= 0 && inline.position > markerPosition) continue;
                if (inline.position < 0) {
                    inline.position = markerPosition;
                }
                inline.nonNestables.addAll(nonNestables);
                String unmarkedText = text.substring(0, inline.position);
                elements.addAll(InlineText.inline(this, unmarkedText, null));
                elements.add(inline);
                text = text.substring(inline.position + inline.extent);
                continue block0;
            }
            String unmarkedText = text.substring(0, markerPosition + 1);
            elements.addAll(InlineText.inline(this, unmarkedText, null));
            text = text.substring(markerPosition + 1);
        }
        elements.addAll(InlineText.inline(this, text, null));
        return elements;
    }

    public String convertUrl(String url) {
        if (this.mdUrlReplacement == null || url.indexOf(58) >= 0) {
            return url;
        }
        Matcher m = Pattern.compile("(\\.md)(#.*)?$").matcher(url);
        if (m.find()) {
            return m.replaceFirst(this.mdUrlReplacement + "$2");
        }
        return url;
    }

    public static <C extends Component> LinkedList<C> replaceAllElements(String regex, C[] elements, String text, Function<String, C> elementFactory) {
        LinkedList<Component> newElements = new LinkedList<Component>();
        Matcher m = Pattern.compile(regex).matcher(text);
        int end = 0;
        while (m.find()) {
            String before = text.substring(end, m.start());
            newElements.add((Component)elementFactory.apply(before));
            Collections.addAll(newElements, elements);
            end = m.end();
        }
        newElements.add((Component)elementFactory.apply(text.substring(end)));
        return newElements;
    }

    public static int startSpan(String s, char c) {
        int i;
        int len = s.length();
        for (i = 0; i < len && s.charAt(i) == c; ++i) {
        }
        return i;
    }

    public static interface BlockType<B extends Block> {
        public Block startBlock(JParseDown var1, Line var2, Block var3);
    }

    public static abstract class Block
    extends Component {
        public boolean identified = false;
        public int interrupted = 0;
        public List<Inline> inlines;
        public Boolean autoBreak = null;

        public boolean isContinuable() {
            return false;
        }

        public boolean isCompletable() {
            return false;
        }

        public Block continueBlock(Line line) {
            return null;
        }

        public Block completeBlock() {
            return null;
        }

        public abstract Collection<Inline> inline(JParseDown var1);
    }

    public static class Line {
        public String body;
        public String text;
        public int indent;

        public Line(String line) {
            this.body = line;
            this.text = line.replaceFirst("^\\s+", "");
            this.indent = line.length() - this.text.length();
        }
    }

    public static class BlockParagraph
    extends Block {
        public String text;

        public BlockParagraph(String text) {
            this.text = text;
        }

        public static Block startBlock(JParseDown parseDown, Line line, Block block) {
            return new BlockParagraph(line.text);
        }

        @Override
        public boolean isContinuable() {
            return false;
        }

        @Override
        public Block continueBlock(Line line) {
            if (this.interrupted > 0) {
                return null;
            }
            this.text = this.text + "\n" + line.text;
            return this;
        }

        @Override
        public Collection<Inline> inline(JParseDown parseDown) {
            return parseDown.lineElements(this.text, this.nonNestables);
        }

        public String toString() {
            return "BlockParagraph{text='" + this.text + '\'' + '}';
        }
    }

    public static interface InlineType<L extends Inline> {
        public Inline inline(JParseDown var1, String var2, String var3);
    }

    public static abstract class Inline
    extends Component {
        public int extent;
        public int position = -1;

        public Inline setExtent(String s) {
            this.extent = s.length();
            return this;
        }

        public Inline setExtent(int len) {
            this.extent = len;
            return this;
        }
    }

    public static class InlineText
    extends Inline {
        public final String text;

        public InlineText(String text) {
            this.text = text;
        }

        public static Collection<Inline> inline(JParseDown parseDown, String text, String context) {
            return JParseDown.replaceAllElements((String)(parseDown.breaksEnabled ? "[ ]*+\\n" : "(?:[ ]*+\\\\|[ ]{2,}+)\\n"), (Component[])new Inline[]{new InlineLineBreak()}, (String)text, t -> {
                InlineText inlineText = new InlineText(text);
                inlineText.setExtent(text);
                return inlineText;
            }).stream().filter(inline -> !(inline instanceof InlineText) || !((InlineText)inline).text.isEmpty()).collect(Collectors.toList());
        }

        public String toString() {
            return "InlineText{text='" + this.text + '\'' + '}';
        }
    }

    public static abstract class Component {
        public String markup = null;
        public boolean hidden = false;
        public HashSet<Class<?>> nonNestables = new HashSet();
    }

    public static class InlineLineBreak
    extends Inline {
        public String toString() {
            return "InlineLineBreak{}";
        }
    }

    public static class InlineUrlTag {
        public static Inline inline(JParseDown parseDown, String text, String context) {
            Matcher m;
            if (text.indexOf(62) >= 0 && (m = Pattern.compile("^<(\\w+:\\/{2}[^ >]+)>", 32).matcher(text)).find()) {
                String url = parseDown.convertUrl(m.group(1));
                return new InlineLink(url, url, null).setExtent(m.group(0));
            }
            return null;
        }
    }

    public static class InlineUrl {
        public static Inline inline(JParseDown parseDown, String text, String context) {
            Matcher m;
            if (!parseDown.urlsLinked || text.length() < 3 || text.charAt(2) != '/') {
                return null;
            }
            if (context.contains("http") && (m = Pattern.compile("\\bhttps?:[\\/]{2}[^\\s<]+\\b\\/*", 258).matcher(context)).find()) {
                String url = parseDown.convertUrl(m.group(0));
                Inline inline = new InlineLink(url, url, null).setExtent(url);
                inline.position = m.start(0);
                return inline;
            }
            return null;
        }
    }

    public static class InlineStrikeThrough
    extends Inline {
        public final String text;

        public InlineStrikeThrough(String text) {
            this.text = text;
        }

        public static Inline inline(JParseDown parseDown, String text, String context) {
            Matcher m;
            if (text.length() < 2) {
                return null;
            }
            if (text.charAt(1) == '~' && (m = Pattern.compile("^~~(?=\\S)(.+?)(?<=\\S)~~").matcher(text)).find()) {
                return new InlineStrikeThrough(m.group(1)).setExtent(m.group(0));
            }
            return null;
        }

        public String toString() {
            return "InlineStrikeThrough{text='" + this.text + '\'' + '}';
        }
    }

    public static class InlineSpecialCharacter
    extends Inline {
        public final String rawHtml;

        public InlineSpecialCharacter(String rawHtml) {
            this.rawHtml = rawHtml;
        }

        public static Inline inline(JParseDown parseDown, String text, String context) {
            Matcher m;
            if (text.length() > 1 && text.charAt(1) != ' ' && text.indexOf(59) >= 0 && (m = Pattern.compile("^&(#?+[0-9a-zA-Z]++);").matcher(text)).find()) {
                return new InlineSpecialCharacter("&" + m.group(1) + ";").setExtent(m.group(0));
            }
            return null;
        }

        public String toString() {
            return "InlineSpecialCharacter{rawHtml='" + this.rawHtml + '\'' + '}';
        }
    }

    public static class InlineMarkup
    extends Inline {
        public final String rawHtml;

        public InlineMarkup(String rawHtml) {
            this.rawHtml = rawHtml;
        }

        public static Inline inline(JParseDown parseDown, String text, String context) {
            Matcher m;
            if (parseDown.markupEscaped || parseDown.safeMode || text.indexOf(62) < 0) {
                return null;
            }
            if (text.charAt(1) == '/' && (m = Pattern.compile("^<\\/\\w[\\w-]*+[ ]*+>", 32).matcher(text)).find()) {
                return new InlineMarkup(m.group(0)).setExtent(m.group(0));
            }
            if (text.charAt(1) == '!' && (m = Pattern.compile("^<!---?[^>-](?:-?+[^-])*-->", 32).matcher(text)).find()) {
                return new InlineMarkup(m.group(0)).setExtent(m.group(0));
            }
            if (text.charAt(1) != ' ' && (m = Pattern.compile("^<\\w[\\w-]*+(?:[ ]*+" + regexHtmlAttribute + ")*+[ ]*+\\/?>", 32).matcher(text)).find()) {
                return new InlineMarkup(m.group(0)).setExtent(m.group(0));
            }
            return null;
        }

        public String toString() {
            return "InlineMarkup{rawHtml='" + this.rawHtml + '\'' + '}';
        }
    }

    public static class InlineLink
    extends Inline {
        public final String text;
        public final String url;
        public final String title;

        public InlineLink(String text, String url, String title) {
            this.text = text;
            this.url = url;
            this.title = title;
        }

        public static Inline inline(JParseDown parseDown, String text, String context) {
            String url;
            String title = null;
            int extent = 0;
            String remainder = text;
            Matcher m = Pattern.compile("\\[((?:\\\\.|[^\\[\\]]|!\\[[^\\[\\]]*\\])*)\\]").matcher(remainder);
            if (!m.find()) {
                return null;
            }
            String elementText = m.group(1);
            remainder = remainder.substring(extent += m.group(0).length());
            m = Pattern.compile("^[(]\\s*+((?:[^ ()]++|[(][^ )]+[)])++)(?:[ ]+(\"[^\"]*+\"|\\'[^\\']*+'))?\\s*+[)]").matcher(remainder);
            if (m.find()) {
                url = parseDown.convertUrl(m.group(1));
                if (m.group(2) != null) {
                    title = m.group(2).substring(1, m.group(2).length() - 1);
                }
                extent += m.group(0).length();
            } else {
                String definition;
                m = Pattern.compile("^\\s*\\[(.*?)\\]").matcher(remainder);
                if (m.find()) {
                    definition = !m.group(1).isEmpty() ? m.group(1) : elementText;
                    definition = definition.toLowerCase();
                    extent += m.group(0).length();
                } else {
                    definition = elementText.toLowerCase();
                }
                ReferenceData reference = parseDown.referenceDefinitions.get(definition);
                if (reference == null) {
                    return null;
                }
                url = reference.url;
                title = reference.title;
            }
            Inline inline = new InlineLink(elementText, url, title).setExtent(extent);
            inline.nonNestables.add(InlineUrl.class);
            inline.nonNestables.add(InlineLink.class);
            return inline;
        }

        public String toString() {
            return "InlineLink{text='" + this.text + '\'' + ", url='" + this.url + '\'' + ", title='" + this.title + '\'' + '}';
        }
    }

    public static class InlineImage
    extends Inline {
        public final String src;
        public final String alternateText;

        public InlineImage(String src, String alternateText) {
            this.src = src;
            this.alternateText = alternateText;
        }

        public static Inline inline(JParseDown parseDown, String text, String context) {
            if (text.length() < 2 || text.charAt(1) != '[') {
                return null;
            }
            InlineLink link = (InlineLink)InlineLink.inline(parseDown, text = text.substring(1), context);
            if (link == null) {
                return null;
            }
            return new InlineImage(link.url, link.text).setExtent(link.extent + 1);
        }

        public String toString() {
            return "InlineImage{src='" + this.src + '\'' + ", alt='" + this.alternateText + '\'' + '}';
        }
    }

    public static class InlineEscapeSequence
    extends Inline {
        public final String rawHtml;

        public InlineEscapeSequence(String rawHtml) {
            this.rawHtml = rawHtml;
        }

        public static Inline inline(JParseDown parseDown, String text, String context) {
            if (text.length() > 1 && specialCharacters.indexOf(text.charAt(1)) >= 0) {
                return new InlineEscapeSequence(Character.toString(text.charAt(1))).setExtent(2);
            }
            return null;
        }

        public String toString() {
            return "InlineEscapeSequence{rawHtml='" + this.rawHtml + '\'' + '}';
        }
    }

    public static class InlineItalic
    extends Inline {
        public final String text;

        public InlineItalic(String text) {
            this.text = text;
        }

        public String toString() {
            return "InlineItalic{text='" + this.text + '\'' + '}';
        }
    }

    public static class InlineBold
    extends Inline {
        public final String text;

        public InlineBold(String text) {
            this.text = text;
        }

        public static Inline inline(JParseDown parseDown, String text, String context) {
            Matcher m;
            int markerIndex;
            if (text.length() < 2) {
                return null;
            }
            char marker = text.charAt(0);
            int n = markerIndex = marker == '*' ? 0 : 1;
            if (text.charAt(1) == marker && (m = strongRegex[markerIndex].matcher(text)).find()) {
                return new InlineBold(m.group(1)).setExtent(m.group(0));
            }
            m = emRegex[markerIndex].matcher(text);
            if (m.find()) {
                return new InlineItalic(m.group(1)).setExtent(m.group(0));
            }
            return null;
        }

        public String toString() {
            return "InlineBold{text='" + this.text + '\'' + '}';
        }
    }

    public static class InlineEmailTag
    extends Inline {
        public final String url;

        public InlineEmailTag(String url) {
            this.url = url;
        }

        public static Inline inline(JParseDown parseDown, String text, String context) {
            if (text.indexOf(62) < 0) {
                return null;
            }
            String hostnameLabel = "[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?";
            String commonMarkEmail = "[a-zA-Z0-9.!#$%&\\'*+\\/=?^_`{|}~-]++@" + hostnameLabel + "(?:\\." + hostnameLabel + ")*";
            Matcher m = Pattern.compile("^<((mailto:)?" + commonMarkEmail + ")>", 2).matcher(text);
            if (m.find()) {
                String url = m.group(1);
                return new InlineEmailTag(url).setExtent(m.group(0));
            }
            return null;
        }

        public String toString() {
            return "InlineEmailTag{url='" + this.url + '\'' + '}';
        }
    }

    public static class InlineCode
    extends Inline {
        public final String text;

        public InlineCode(String text) {
            this.text = text;
        }

        public static Inline inline(JParseDown parseDown, String text, String context) {
            char marker = text.charAt(0);
            Pattern regex = Pattern.compile("^([" + marker + "]++)[ ]*+(.+?)[ ]*+(?<![" + marker + "])\\1(?!" + marker + ")", 32);
            Matcher m = regex.matcher(text);
            if (m.find()) {
                text = m.group(2).replaceAll("[ ]*+\\n", " ");
                return new InlineCode(text).setExtent(m.group(0));
            }
            return null;
        }

        public String toString() {
            return "InlineCode{text='" + this.text + '\'' + '}';
        }
    }

    public static class BlockReference
    extends Block {
        public final String id;
        public final ReferenceData data;

        public BlockReference(String id, ReferenceData data) {
            this.id = id;
            this.data = data;
        }

        public static Block startBlock(JParseDown parseDown, Line line, Block block) {
            Matcher m;
            if (line.text.indexOf(93) >= 0 && (m = Pattern.compile("^\\[(.+?)\\]:[ ]*+<?(\\S+?)>?(?:[ ]+[\"\\'(](.+)[\"\\')])?[ ]*+$").matcher(line.text)).find()) {
                String id = m.group(1).toLowerCase();
                ReferenceData data = new ReferenceData(parseDown.convertUrl(m.group(2)), m.group(3));
                parseDown.referenceDefinitions.put(id, data);
                return new BlockReference(id, data);
            }
            return null;
        }

        @Override
        public Collection<Inline> inline(JParseDown parseDown) {
            return Collections.emptyList();
        }

        public String toString() {
            return "BlockReference{id='" + this.id + '\'' + '}';
        }
    }

    public static class InlineHorizontalRule
    extends Inline {
        public String toString() {
            return "InlineHorizontalRule{}";
        }
    }

    public static class BlockHorizontalRule
    extends Block {
        public BlockHorizontalRule() {
            this.autoBreak = true;
        }

        @Override
        public Collection<Inline> inline(JParseDown parseDown) {
            return Collections.singletonList(new InlineHorizontalRule());
        }

        public String toString() {
            return "BlockHorizontalRule{}";
        }
    }

    public static class BlockRule {
        public static Block startBlock(JParseDown parseDown, Line line, Block block) {
            char marker = line.text.charAt(0);
            int count = JParseDown.startSpan(line.text, marker);
            if (count >= 3 && line.text.trim().length() == count) {
                return new BlockHorizontalRule();
            }
            return null;
        }
    }

    public static class BlockQuote
    extends Block {
        public final LinkedList<String> lines = new LinkedList();

        public BlockQuote(String text) {
            if (text != null) {
                this.lines.add(text);
            }
        }

        public static Block startBlock(JParseDown parseDown, Line line, Block block) {
            Matcher m = Pattern.compile("^>[ ]?+(.*+)").matcher(line.text);
            if (m.find()) {
                return new BlockQuote(m.group(1));
            }
            return null;
        }

        @Override
        public boolean isContinuable() {
            return true;
        }

        @Override
        public Block continueBlock(Line line) {
            Matcher m;
            if (this.interrupted > 0) {
                return null;
            }
            if (line.text.charAt(0) == '>' && (m = Pattern.compile("^>[ ]?+(.*+)").matcher(line.text)).find()) {
                this.lines.add(m.group(1));
                return this;
            }
            if (this.interrupted == 0) {
                this.lines.add(line.text);
                return this;
            }
            return null;
        }

        @Override
        public Collection<Inline> inline(JParseDown parseDown) {
            LinkedList<Inline> inlines = new LinkedList<Inline>();
            for (String line : this.lines) {
                if (!inlines.isEmpty()) {
                    inlines.add(new InlineLineBreak());
                }
                inlines.addAll(parseDown.lineElements(line, this.nonNestables));
            }
            return inlines;
        }

        public String toString() {
            return "BlockQuote{lines=[" + String.join((CharSequence)", ", this.lines) + "]}";
        }
    }

    public static class BlockList
    extends Block {
        public int indent;
        public String pattern;
        public boolean loose = false;
        public boolean ordered;
        public String marker;
        public String markerType;
        public String markerTypeRegex;
        public JParseDown parseDown;
        public LinkedList<String> lines = new LinkedList();

        public BlockList() {
            this.autoBreak = true;
        }

        public static Block startBlock(JParseDown parseDown, Line line, Block block) {
            String pattern;
            boolean ordered;
            if (Character.isDigit(line.text.charAt(0))) {
                ordered = true;
                pattern = "[0-9]{1,9}+[.\\)]";
            } else {
                ordered = false;
                pattern = "[*+-]";
            }
            Matcher m = Pattern.compile("^(" + pattern + "([ ]++|$))(.*+)").matcher(line.text);
            if (m.find()) {
                String marker = m.group(1);
                String body = m.group(3);
                int contentIndent = m.group(2).length();
                if (contentIndent >= 5) {
                    marker = marker.substring(0, -(--contentIndent));
                    while (contentIndent > 0) {
                        body = " " + body;
                        --contentIndent;
                    }
                } else if (contentIndent == 0) {
                    marker = marker + " ";
                }
                String markerWithoutWhitespace = marker.substring(0, marker.indexOf(32));
                BlockList b = new BlockList();
                b.parseDown = parseDown;
                b.indent = line.indent;
                b.pattern = pattern;
                b.ordered = ordered;
                b.marker = marker;
                b.markerType = !ordered ? markerWithoutWhitespace : markerWithoutWhitespace.substring(markerWithoutWhitespace.length() - 1, markerWithoutWhitespace.length());
                b.markerTypeRegex = Pattern.quote(b.markerType);
                b.lines.add(body);
                return b;
            }
            return null;
        }

        @Override
        public boolean isContinuable() {
            return true;
        }

        @Override
        public Block continueBlock(Line line) {
            Matcher m;
            if (this.interrupted > 0 && this.lines.isEmpty()) {
                return null;
            }
            int requiredIndent = this.indent + this.marker.length();
            if (line.indent < requiredIndent && (this.ordered && (m = Pattern.compile("^[0-9]++" + this.markerTypeRegex + "(?:[ ]++(.*)|$)").matcher(line.text)).find() || !this.ordered && (m = Pattern.compile("^" + this.markerTypeRegex + "(?:[ ]++(.*)|$)").matcher(line.text)).find())) {
                if (this.interrupted > 0) {
                    this.lines.add("");
                    this.loose = true;
                    this.interrupted = 0;
                }
                String text = m.group(1) != null ? m.group(1) : "";
                this.indent = line.indent;
                this.lines.add(text);
                return this;
            }
            if (line.indent < requiredIndent && BlockList.startBlock(this.parseDown, line, null) != null) {
                return null;
            }
            if (line.text.charAt(0) == '[' && BlockReference.startBlock(this.parseDown, line, null) != null) {
                return this;
            }
            if (line.indent >= requiredIndent) {
                if (this.interrupted > 0) {
                    this.lines.add("");
                    this.loose = true;
                    this.interrupted = 0;
                }
                String text = line.body.substring(requiredIndent);
                this.lines.add(text);
                return this;
            }
            if (this.interrupted == 0) {
                String text = line.body.replaceAll("^[ ]{0," + requiredIndent + "}+", "");
                this.lines.add(text);
                return this;
            }
            return null;
        }

        @Override
        public boolean isCompletable() {
            return true;
        }

        @Override
        public Block completeBlock() {
            if (this.loose && !this.lines.getLast().isEmpty()) {
                this.lines.add("");
            }
            return this;
        }

        @Override
        public Collection<Inline> inline(JParseDown parseDown) {
            LinkedList<Inline> inlines = new LinkedList<Inline>();
            for (String line : this.lines) {
                if (!inlines.isEmpty()) {
                    inlines.add(new InlineLineBreak());
                }
                inlines.addAll(parseDown.lineElements(line, this.nonNestables));
            }
            return inlines;
        }

        public String toString() {
            return "BlockList{lines=[" + String.join((CharSequence)", ", this.lines) + "]}";
        }
    }

    public static class BlockHeader
    extends Block {
        public final int level;
        public final String line;

        public BlockHeader(int level, String line) {
            this.level = level;
            this.line = line;
            this.autoBreak = true;
        }

        public static Block startBlock(JParseDown parseDown, Line line, Block block) {
            int level = JParseDown.startSpan(line.text, '#');
            if (level > 6) {
                return null;
            }
            String text = line.text.substring(level);
            if (parseDown.strictMode && !text.isEmpty() && text.charAt(0) != ' ') {
                return null;
            }
            text = text.trim();
            return new BlockHeader(level, text);
        }

        @Override
        public Collection<Inline> inline(JParseDown parseDown) {
            return parseDown.lineElements(this.line, this.nonNestables);
        }

        public String toString() {
            return "BlockHeader{level=" + this.level + ", line='" + this.line + '\'' + '}';
        }
    }

    public static class BlockFencedCode
    extends Block {
        public final char marker;
        public final int openerLength;
        public final String infoString;
        public String text = "";
        public boolean complete = false;

        public BlockFencedCode(char marker, int openerLength, String infoString) {
            this.marker = marker;
            this.openerLength = openerLength;
            this.infoString = infoString;
        }

        public static Block startBlock(JParseDown parseDown, Line line, Block block) {
            char marker = line.text.charAt(0);
            int openerLength = JParseDown.startSpan(line.text, marker);
            if (openerLength < 3) {
                return null;
            }
            String infoString = line.text.substring(openerLength).trim();
            if (infoString.contains("`")) {
                return null;
            }
            return new BlockFencedCode(marker, openerLength, infoString);
        }

        @Override
        public boolean isContinuable() {
            return true;
        }

        @Override
        public Block continueBlock(Line line) {
            if (this.complete) {
                return null;
            }
            while (this.interrupted > 0) {
                this.text = this.text + "\n";
                --this.interrupted;
            }
            int len = JParseDown.startSpan(line.text, this.marker);
            if (len >= this.openerLength && line.text.substring(len).trim().isEmpty()) {
                if (!this.text.isEmpty()) {
                    this.text = this.text.substring(1);
                }
                this.complete = true;
                return this;
            }
            this.text = this.text + "\n" + line.body;
            return this;
        }

        @Override
        public boolean isCompletable() {
            return true;
        }

        @Override
        public Block completeBlock() {
            return this;
        }

        @Override
        public Collection<Inline> inline(JParseDown parseDown) {
            return parseDown.lineElements(this.text, this.nonNestables);
        }

        public String toString() {
            return "BlockFencedCode{infoString='" + this.infoString + '\'' + ", text='" + this.text + '\'' + '}';
        }
    }

    public static class BlockComment
    extends Block {
        public String text;
        public boolean closed = false;

        public BlockComment(String text) {
            this.text = text;
        }

        public static Block startBlock(JParseDown parseDown, Line line, Block block) {
            if (parseDown.markupEscaped || parseDown.safeMode) {
                return null;
            }
            if (line.text.indexOf("<!--") == 0) {
                BlockComment b = new BlockComment(line.body);
                if (line.text.contains("-->")) {
                    b.closed = true;
                }
                return b;
            }
            return null;
        }

        @Override
        public boolean isContinuable() {
            return true;
        }

        @Override
        public Block continueBlock(Line line) {
            if (this.closed) {
                return null;
            }
            this.text = this.text + "\n" + line.body;
            if (line.text.contains("-->")) {
                this.closed = true;
            }
            return this;
        }

        @Override
        public Collection<Inline> inline(JParseDown parseDown) {
            return parseDown.lineElements(this.text, this.nonNestables);
        }

        public String toString() {
            return "BlockComment{text='" + this.text + '\'' + '}';
        }
    }

    public static class BlockCode
    extends Block {
        public String text;

        public BlockCode(String text) {
            this.text = text;
        }

        public static Block startBlock(JParseDown parseDown, Line line, Block block) {
            if (block != null && block instanceof BlockParagraph && block.interrupted == 0) {
                return null;
            }
            if (line.indent >= 4) {
                return new BlockCode(line.body.substring(4));
            }
            return null;
        }

        @Override
        public boolean isContinuable() {
            return true;
        }

        @Override
        public Block continueBlock(Line line) {
            if (line.indent >= 4) {
                while (this.interrupted > 0) {
                    this.text = this.text + "\n";
                    --this.interrupted;
                }
                this.text = this.text + "\n";
                this.text = this.text + line.body.substring(4);
                return this;
            }
            return null;
        }

        @Override
        public boolean isCompletable() {
            return true;
        }

        @Override
        public Block completeBlock() {
            return this;
        }

        @Override
        public Collection<Inline> inline(JParseDown parseDown) {
            return parseDown.lineElements(this.text, this.nonNestables);
        }

        public String toString() {
            return "BlockCode{text='" + this.text + '\'' + '}';
        }
    }

    public static class ReferenceData {
        public String url;
        public String title;

        public ReferenceData(String url, String title) {
            this.url = url;
            this.title = title;
        }
    }
}

