/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.changelog;

import java.io.IOException;
import java.io.InputStream;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.gui.changelog.ChangelogLoader;
import me.shedaniel.rei.impl.client.gui.changelog.JParseDown;
import me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class JParseDownToMinecraft {
    public static ITextComponent toComponent(JParseDown.Inline inline) {
        if (inline instanceof JParseDown.InlineText) {
            return new StringTextComponent(((JParseDown.InlineText)inline).text.replace("\n", " "));
        }
        if (inline instanceof JParseDown.InlineBold) {
            return new StringTextComponent(((JParseDown.InlineBold)inline).text.replace("\n", " ")).func_240699_a_(TextFormatting.BOLD);
        }
        if (inline instanceof JParseDown.InlineItalic) {
            return new StringTextComponent(((JParseDown.InlineItalic)inline).text.replace("\n", " ")).func_240699_a_(TextFormatting.ITALIC);
        }
        if (inline instanceof JParseDown.InlineLink) {
            return new StringTextComponent(((JParseDown.InlineLink)inline).text.replace("\n", " ")).func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)2081791)).func_244282_c(Boolean.valueOf(true)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(((JParseDown.InlineLink)inline).url).func_240699_a_(TextFormatting.GRAY))).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, ((JParseDown.InlineLink)inline).url)));
        }
        if (inline instanceof JParseDown.InlineStrikeThrough) {
            return new StringTextComponent(((JParseDown.InlineStrikeThrough)inline).text.replace("\n", " ")).func_240699_a_(TextFormatting.STRIKETHROUGH);
        }
        return null;
    }

    public static void build(ChangelogLoader.Builder builder, JParseDown.Block block) {
        ImmutableTextComponent lastComponent = ImmutableTextComponent.EMPTY;
        ChangelogLoader.Builder finalBuilder = builder;
        for (JParseDown.Inline inline : block.inlines) {
            InputStream stream;
            ITextComponent component = JParseDownToMinecraft.toComponent(inline);
            if (component != null) {
                lastComponent = lastComponent.func_230529_a_(component);
                continue;
            }
            builder.add((ITextComponent)lastComponent);
            lastComponent = ImmutableTextComponent.EMPTY;
            if (inline instanceof JParseDown.InlineLineBreak) continue;
            if (inline instanceof JParseDown.InlineHorizontalRule) {
                builder.add(ErrorsEntryListWidget.HorizontalRuleEntry::new);
                continue;
            }
            if (!(inline instanceof JParseDown.InlineImage) || (stream = builder.getClass().getClassLoader().getResourceAsStream(((JParseDown.InlineImage)inline).src)) == null) continue;
            try {
                DynamicTexture texture = new DynamicTexture(NativeImage.func_195713_a((InputStream)stream));
                ResourceLocation id = Minecraft.func_71410_x().func_110434_K().func_110578_a("rei_md_image_", texture);
                builder.add(width -> new ErrorsEntryListWidget.ImageEntry((int)width, texture, id));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (lastComponent != ImmutableTextComponent.EMPTY) {
            builder.add((ITextComponent)lastComponent);
        }
    }
}

