/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.credits;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicSmoothScrollingEntryListWidget;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CreditsEntryListWidget
extends DynamicSmoothScrollingEntryListWidget<CreditsItem> {
    private boolean inFocus;

    public CreditsEntryListWidget(Minecraft client, int width, int height, int startY, int endY) {
        super(client, width, height, startY, endY, AbstractGui.field_230663_f_);
    }

    public boolean func_231049_c__(boolean boolean_1) {
        if (!this.inFocus && this.getItemCount() == 0) {
            return false;
        }
        boolean bl = this.inFocus = !this.inFocus;
        if (this.inFocus && this.getFocused() == null && this.getItemCount() > 0) {
            this.moveSelection(1);
        } else if (this.inFocus && this.getFocused() != null) {
            this.moveSelection(0);
        }
        return this.inFocus;
    }

    public void creditsClearEntries() {
        this.clearItems();
    }

    private CreditsItem rei_getEntry(int index) {
        return (CreditsItem)((Object)this.func_231039_at__().get(index));
    }

    public void creditsAddEntry(CreditsItem entry) {
        this.addItem(entry);
    }

    public int getItemWidth() {
        return this.width - 80;
    }

    protected int getScrollbarPosition() {
        return this.width - 40;
    }

    public static abstract class CreditsItem
    extends DynamicEntryListWidget.Entry<CreditsItem> {
    }

    public static class LinkItem
    extends CreditsItem {
        private ITextComponent text;
        private List<IReorderingProcessor> textSplit;
        private String link;
        private boolean contains;
        private boolean rainbow;

        public LinkItem(ITextComponent text, String link, int width, boolean rainbow) {
            this.text = text;
            this.textSplit = Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)text, width);
            this.link = link;
            this.rainbow = rainbow;
        }

        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            boolean bl = this.contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (this.contains) {
                Minecraft.func_71410_x().field_71462_r.func_238652_a_(matrices, (ITextComponent)new StringTextComponent("Click to open link."), mouseX, mouseY);
                int yy = y;
                for (IReorderingProcessor textSp : this.textSplit) {
                    IReorderingProcessor underlined = characterVisitor -> textSp.accept((charIndex, style, codePoint) -> characterVisitor.accept(charIndex, style.func_240721_b_(TextFormatting.UNDERLINE), codePoint));
                    if (this.rainbow) {
                        underlined = TextTransformations.applyRainbow(underlined, x + 5, yy);
                    }
                    Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, underlined, (float)(x + 5), (float)yy, -14695425);
                    yy += 12;
                }
            } else {
                int yy = y;
                for (IReorderingProcessor textSp : this.textSplit) {
                    if (this.rainbow) {
                        textSp = TextTransformations.applyRainbow(textSp, x + 5, yy);
                    }
                    Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, textSp, (float)(x + 5), (float)yy, -14695425);
                    yy += 12;
                }
            }
        }

        public int getItemHeight() {
            return 12 * this.textSplit.size();
        }

        public boolean func_231049_c__(boolean boolean_1) {
            return false;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.contains && button == 0) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                try {
                    Util.func_110647_a().func_195642_a(new URI(this.link));
                    return true;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    public static class TranslationCreditsItem
    extends CreditsItem {
        private ITextComponent language;
        private List<IReorderingProcessor> translators;
        private int maxWidth;

        public TranslationCreditsItem(ITextComponent language, ITextComponent translators, int width, int maxWidth) {
            this.language = language;
            this.translators = Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)translators, width);
            this.maxWidth = maxWidth;
        }

        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, this.language.func_241878_f(), (float)(x + 5), (float)(y + 5), -1);
            int yy = y + 5;
            for (IReorderingProcessor translator : this.translators) {
                Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, translator, (float)(x + 5 + this.maxWidth), (float)yy, -1);
                yy += 12;
            }
        }

        public int getItemHeight() {
            return 12 * this.translators.size();
        }

        public boolean func_231049_c__(boolean boolean_1) {
            return false;
        }
    }

    public static class TextCreditsItem
    extends CreditsItem {
        private ITextComponent text;

        public TextCreditsItem(ITextComponent text) {
            this.text = text;
        }

        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, this.text.func_241878_f(), (float)(x + 5), (float)(y + 5), -1);
        }

        public int getItemHeight() {
            return 12;
        }

        public boolean func_231049_c__(boolean boolean_1) {
            return false;
        }
    }
}

