/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.performance.entry;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.impl.client.gui.performance.PerformanceScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SubCategoryListEntry
extends PerformanceScreen.PerformanceEntry
implements Expandable {
    private static final ResourceLocation CONFIG_TEX = new ResourceLocation("cloth-config2", "textures/gui/cloth_config.png");
    private final List<PerformanceScreen.PerformanceEntry> entries;
    private final CategoryLabelWidget widget;
    private final List<IGuiEventListener> children;
    private final ITextComponent name;
    private final long totalTime;
    private boolean expanded;

    public SubCategoryListEntry(ITextComponent name, List<PerformanceScreen.PerformanceEntry> entries, long totalTime, boolean defaultExpanded) {
        this.name = name;
        this.entries = entries;
        this.totalTime = totalTime;
        this.expanded = defaultExpanded;
        this.widget = new CategoryLabelWidget();
        this.children = Lists.newArrayList((Object[])new IGuiEventListener[]{this.widget});
        this.children.addAll(entries);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CONFIG_TEX);
        RenderHelper.func_74518_a();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((CategoryLabelWidget)this.widget).rectangle.x = x + 3;
        ((CategoryLabelWidget)this.widget).rectangle.y = y;
        ((CategoryLabelWidget)this.widget).rectangle.width = entryWidth - 6;
        ((CategoryLabelWidget)this.widget).rectangle.height = 24;
        this.func_238474_b_(matrices, x + 3, y + 5, 24, (this.widget.rectangle.contains(mouseX, mouseY) ? 18 : 0) + (this.expanded ? 9 : 0), 9, 9);
        Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, this.name.func_241878_f(), (float)x + 3.0f + 15.0f, (float)(y + 6), this.widget.rectangle.contains(mouseX, mouseY) ? -1638890 : -1);
        for (PerformanceScreen.PerformanceEntry performanceEntry : this.entries) {
            performanceEntry.setParent(this.getParent());
        }
        if (this.expanded) {
            int yy = y + 24;
            for (PerformanceScreen.PerformanceEntry entry : this.entries) {
                entry.render(matrices, -1, yy, x + 3 + 15, entryWidth - 15 - 3, entry.getItemHeight(), mouseX, mouseY, isHovered && this.func_241217_q_() == entry, delta);
                yy += entry.getItemHeight();
            }
        }
        IReorderingProcessor timeText = PerformanceScreen.formatTime(this.totalTime, true);
        Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, timeText, (float)x + (float)entryWidth - 6.0f - 4.0f - (float)Minecraft.func_71410_x().field_71466_p.func_243245_a(timeText), (float)(y + 6), -1);
    }

    public int getMorePossibleHeight() {
        if (!this.expanded) {
            return -1;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 24;
        for (PerformanceScreen.PerformanceEntry entry : this.entries) {
            i += entry.getItemHeight();
            if (entry.getMorePossibleHeight() < 0) continue;
            list.add(i + entry.getMorePossibleHeight());
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0) - this.getItemHeight();
    }

    public Rectangle getEntryArea(int x, int y, int entryWidth, int entryHeight) {
        ((CategoryLabelWidget)this.widget).rectangle.x = x;
        ((CategoryLabelWidget)this.widget).rectangle.y = y;
        ((CategoryLabelWidget)this.widget).rectangle.width = entryWidth;
        ((CategoryLabelWidget)this.widget).rectangle.height = 24;
        return new Rectangle(this.getParent().left, y, this.getParent().right - this.getParent().left, 20);
    }

    public int getItemHeight() {
        if (!this.expanded) {
            return 24;
        }
        int i = 24;
        for (PerformanceScreen.PerformanceEntry entry : this.entries) {
            i += entry.getItemHeight();
        }
        return i;
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.expanded ? this.children : Collections.singletonList(this.widget);
    }

    public class CategoryLabelWidget
    implements IGuiEventListener {
        private final Rectangle rectangle = new Rectangle();

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.rectangle.contains(mouseX, mouseY)) {
                SubCategoryListEntry.this.expanded = !SubCategoryListEntry.this.expanded;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                return true;
            }
            return false;
        }
    }
}

