/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.ButtonArea;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.screen.DefaultDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.TabWidget;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CompositeDisplayViewingScreen
extends AbstractDisplayViewingScreen {
    private final List<Widget> widgets = Lists.newArrayList();
    private final List<Button> buttonList = Lists.newArrayList();
    private final List<DisplayRenderer> displayRenderers = Lists.newArrayList();
    private final List<TabWidget> tabs = Lists.newArrayList();
    public Rectangle scrollListBounds;
    private int selectedRecipeIndex = 0;
    private final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return new Rectangle(CompositeDisplayViewingScreen.this.scrollListBounds.x + 1, CompositeDisplayViewingScreen.this.scrollListBounds.y + 1, CompositeDisplayViewingScreen.this.scrollListBounds.width - 2, CompositeDisplayViewingScreen.this.scrollListBounds.height - 2);
        }

        public int getMaxScrollHeight() {
            int i = 0;
            for (Button button : CompositeDisplayViewingScreen.this.buttonList) {
                i += button.getBounds().height;
            }
            return i;
        }
    };
    private float scrollBarAlpha = 0.0f;
    private float scrollBarAlphaFuture = 0.0f;
    private long scrollBarAlphaFutureTime = -1L;
    private int tabsPage = -1;

    public CompositeDisplayViewingScreen(Map<DisplayCategory<?>, List<DisplaySpec>> categoryMap, @Nullable CategoryIdentifier<?> category) {
        super(categoryMap, category, 8);
    }

    @Override
    public void recalculateCategoryPage() {
        this.tabsPage = -1;
    }

    public void func_231160_c_() {
        ArrayList<Widget> setupDisplay;
        super.func_231160_c_();
        boolean isCompactTabs = ConfigObject.getInstance().isUsingCompactTabs();
        int tabSize = isCompactTabs ? 24 : 28;
        this.func_231039_at__().clear();
        this.widgets.clear();
        this.buttonList.clear();
        this.displayRenderers.clear();
        this.tabs.clear();
        int largestWidth = this.field_230708_k_ - 100;
        int largestHeight = this.field_230709_l_ - 40;
        DisplayCategory<Display> category = this.getCurrentCategory();
        DisplaySpec display = (DisplaySpec)((List)this.categoryMap.get(category)).get(this.selectedRecipeIndex);
        int guiWidth = MathHelper.func_76125_a((int)(category.getDisplayWidth(display.provideInternalDisplay()) + 30), (int)0, (int)largestWidth) + 100;
        int guiHeight = MathHelper.func_76125_a((int)(category.getDisplayHeight() + 40), (int)166, (int)largestHeight);
        this.tabsPerPage = Math.max(5, MathHelper.func_76128_c((double)(((double)guiWidth - 20.0) / (double)tabSize)));
        if (this.tabsPage == -1) {
            this.tabsPage = this.selectedCategoryIndex / this.tabsPerPage;
        }
        this.bounds = new Rectangle(this.field_230708_k_ / 2 - guiWidth / 2, this.field_230709_l_ / 2 - guiHeight / 2, guiWidth, guiHeight);
        List<EntryIngredient> workstations = CategoryRegistry.getInstance().get(category.getCategoryIdentifier()).getWorkstations();
        if (!workstations.isEmpty()) {
            int ww = MathHelper.func_76141_d((float)((float)(this.bounds.width - 16) / 18.0f));
            int w = Math.min(ww, workstations.size());
            int h = MathHelper.func_76123_f((float)((float)workstations.size() / (float)ww));
            int xx = this.bounds.x + 16;
            int yy = this.bounds.y + this.bounds.height + 2;
            this.widgets.add(Widgets.createCategoryBase(new Rectangle(xx - 5, this.bounds.y + this.bounds.height - 5, 10 + w * 16, 12 + h * 16)));
            this.widgets.add(Widgets.createSlotBase(new Rectangle(xx - 1, yy - 1, 2 + w * 16, 2 + h * 16)));
            int index = 0;
            for (EntryIngredient workingStation : workstations) {
                this.widgets.add(new DefaultDisplayViewingScreen.WorkstationSlotWidget(xx, yy, workingStation));
                xx += 16;
                if (++index < ww) continue;
                index = 0;
                xx = this.bounds.x + 16;
                yy += 16;
            }
        }
        this.widgets.add(Widgets.createCategoryBase(this.bounds));
        this.scrollListBounds = new Rectangle(this.bounds.x + 4, this.bounds.y + 17, 102, guiHeight - 17 - 7);
        this.widgets.add(Widgets.createSlotBase(this.scrollListBounds));
        Rectangle recipeBounds = new Rectangle(this.bounds.x + 100 + (guiWidth - 100) / 2 - category.getDisplayWidth(display.provideInternalDisplay()) / 2, this.bounds.y + this.bounds.height / 2 - category.getDisplayHeight() / 2, category.getDisplayWidth(display.provideInternalDisplay()), category.getDisplayHeight());
        try {
            setupDisplay = this.getCurrentCategoryView(display.provideInternalDisplay()).setupDisplay(display.provideInternalDisplay(), recipeBounds);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            setupDisplay = new ArrayList();
            setupDisplay.add(Widgets.createRecipeBase(recipeBounds).color(-4521984));
            setupDisplay.add(Widgets.createLabel(new Point(recipeBounds.getCenterX(), recipeBounds.getCenterY() - 8), (ITextComponent)new StringTextComponent("Failed to initiate setupDisplay")));
            setupDisplay.add(Widgets.createLabel(new Point(recipeBounds.getCenterX(), recipeBounds.getCenterY() + 1), (ITextComponent)new StringTextComponent("Check console for error")));
        }
        this.setupTags(setupDisplay);
        this.transformFiltering(setupDisplay);
        this.transformIngredientNotice(setupDisplay, this.ingredientStackToNotice);
        this.transformResultNotice(setupDisplay, this.resultStackToNotice);
        for (EntryWidget widget2 : Widgets.walk(this.widgets, EntryWidget.class::isInstance)) {
            widget2.removeTagMatch = true;
        }
        this.widgets.addAll(setupDisplay);
        Optional<ButtonArea> supplier = CategoryRegistry.getInstance().get(category.getCategoryIdentifier()).getPlusButtonArea();
        if (supplier.isPresent() && supplier.get().get(recipeBounds) != null) {
            this.widgets.add(InternalWidgets.createAutoCraftingButtonWidget(recipeBounds, supplier.get().get(recipeBounds), (ITextComponent)new StringTextComponent(supplier.get().getButtonText()), display::provideInternalDisplay, display::provideInternalDisplayIds, setupDisplay, category));
        }
        int index = 0;
        for (DisplaySpec recipeDisplay : (List)this.categoryMap.get(category)) {
            int finalIndex = index++;
            DisplayRenderer displayRenderer = this.getCurrentCategoryView(recipeDisplay.provideInternalDisplay()).getDisplayRenderer(recipeDisplay.provideInternalDisplay());
            this.displayRenderers.add(displayRenderer);
            this.buttonList.add(Widgets.createButton(new Rectangle(this.bounds.x + 5, 0, displayRenderer.getWidth(), displayRenderer.getHeight()), NarratorChatListener.field_216868_a).onClick(button -> {
                this.selectedRecipeIndex = finalIndex;
                this.func_231160_c_();
            }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.scrollListBounds.contains(point) || button.isFocused()).onRender((matrices, button) -> button.setEnabled(this.selectedRecipeIndex != finalIndex)));
        }
        int tabV = isCompactTabs ? 166 : 192;
        for (int i = 0; i < this.tabsPerPage; ++i) {
            int j = i + this.tabsPage * this.tabsPerPage;
            if (this.categories.size() <= j) continue;
            DisplayCategory tabCategory = (DisplayCategory)this.categories.get(j);
            TabWidget tab = TabWidget.create(i, tabSize, this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.tabsPage * this.tabsPerPage, this.tabsPerPage) * tabSize / 2, this.bounds.y, 0, tabV, widget -> {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                if (widget.selected) {
                    return false;
                }
                ClientHelperImpl.getInstance().openRecipeViewingScreen(this.categoryMap, tabCategory.getCategoryIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
                return true;
            });
            this.tabs.add(tab);
            tab.setRenderer(tabCategory, tabCategory.getIcon(), tabCategory.getTitle(), j == this.selectedCategoryIndex);
        }
        this.widgets.add(Widgets.createButton(new Rectangle(this.bounds.x + 2, this.bounds.y - 16, 10, 10), (ITextComponent)new TranslationTextComponent("text.rei.left_arrow")).onClick(button -> {
            --this.tabsPage;
            if (this.tabsPage < 0) {
                this.tabsPage = MathHelper.func_76123_f((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1;
            }
            this.func_231160_c_();
        }).enabled(this.categories.size() > this.tabsPerPage));
        this.widgets.add(Widgets.createButton(new Rectangle(this.bounds.x + this.bounds.width - 12, this.bounds.y - 16, 10, 10), (ITextComponent)new TranslationTextComponent("text.rei.right_arrow")).onClick(button -> {
            ++this.tabsPage;
            if (this.tabsPage > MathHelper.func_76123_f((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1) {
                this.tabsPage = 0;
            }
            this.func_231160_c_();
        }).enabled(this.categories.size() > this.tabsPerPage));
        this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.x + 4 + this.scrollListBounds.width / 2, this.bounds.y + 6), ((DisplayCategory)this.categories.get(this.selectedCategoryIndex)).getTitle(), label -> ViewSearchBuilder.builder().addAllCategories().open()).tooltip(new ITextComponent[]{new TranslationTextComponent("text.rei.view_all_categories")}).noShadow().color(-12566464, -4473925).hoveredColor(-16760321, -17075));
        this._children().addAll(this.buttonList);
        this.widgets.addAll(this.tabs);
        this._children().addAll(this.widgets);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            this.scrollBarAlpha = 1.0f;
            return true;
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesMouse(button)) {
            ++this.selectedRecipeIndex;
            if (this.selectedRecipeIndex >= ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size()) {
                this.selectedRecipeIndex = 0;
            }
            this.func_231160_c_();
            return true;
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesMouse(button)) {
            --this.selectedRecipeIndex;
            if (this.selectedRecipeIndex < 0) {
                this.selectedRecipeIndex = ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() - 1;
            }
            this.func_231160_c_();
            return true;
        }
        if (ConfigObject.getInstance().getPreviousScreenKeybind().matchesMouse(button)) {
            if (REIRuntimeImpl.getInstance().hasLastDisplayScreen()) {
                this.field_230706_i_.func_147108_a(REIRuntimeImpl.getInstance().getLastDisplayScreen());
            } else {
                this.field_230706_i_.func_147108_a(REIRuntime.getInstance().getPreviousScreen());
            }
            return true;
        }
        for (IGuiEventListener entry : this.func_231039_at__()) {
            if (!entry.func_231044_a_(mouseX, mouseY, button)) continue;
            this.func_231035_a_(entry);
            if (button == 0) {
                this.func_231037_b__(true);
            }
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231042_a_(char char_1, int int_1) {
        for (IGuiEventListener listener : this.func_231039_at__()) {
            if (!listener.func_231042_a_(char_1, int_1)) continue;
            return true;
        }
        return super.func_231042_a_(char_1, int_1);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        int tabSize;
        double height = this.scrolling.getMaxScrollHeight();
        if (this.scrollListBounds.contains(mouseX, mouseY) && height > (double)(this.scrollListBounds.height - 2)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlphaFuture = 1.0f;
            }
            if ((float)(System.currentTimeMillis() - this.scrollBarAlphaFutureTime) > 300.0f) {
                this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            }
            return true;
        }
        REIRuntimeImpl.isWithinRecipeViewingScreen = true;
        for (IGuiEventListener listener : this.func_231039_at__()) {
            if (!listener.func_231043_a_(mouseX, mouseY, amount)) continue;
            REIRuntimeImpl.isWithinRecipeViewingScreen = false;
            return true;
        }
        REIRuntimeImpl.isWithinRecipeViewingScreen = false;
        int n = tabSize = ConfigObject.getInstance().isUsingCompactTabs() ? 24 : 28;
        if (mouseX >= (double)this.bounds.x && mouseX <= (double)this.bounds.getMaxX() && mouseY >= (double)(this.bounds.y - tabSize) && mouseY < (double)this.bounds.y) {
            if (amount < 0.0) {
                ++this.selectedCategoryIndex;
            } else if (amount > 0.0) {
                --this.selectedCategoryIndex;
            }
            if (this.selectedCategoryIndex < 0) {
                this.selectedCategoryIndex = this.categories.size() - 1;
            } else if (this.selectedCategoryIndex >= this.categories.size()) {
                this.selectedCategoryIndex = 0;
            }
            ClientHelperImpl.getInstance().openRecipeViewingScreen(this.categoryMap, ((DisplayCategory)this.categories.get(this.selectedCategoryIndex)).getCategoryIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
            return true;
        }
        if (this.bounds.contains(PointHelper.ofMouse())) {
            if (amount < 0.0 && ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.func_231160_c_();
                return true;
            }
            if (((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() - 1;
                }
                this.func_231160_c_();
                return true;
            }
        }
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (ConfigObject.getInstance().isCompositeScrollBarPermanent()) {
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 0.0f;
            this.scrollBarAlpha = 1.0f;
        } else if (this.scrollBarAlphaFutureTime > 0L) {
            long l = System.currentTimeMillis() - this.scrollBarAlphaFutureTime;
            if ((float)l > 300.0f) {
                if (this.scrollBarAlphaFutureTime == 0L) {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                    this.scrollBarAlphaFutureTime = -1L;
                } else if ((float)l > 2000.0f && this.scrollBarAlphaFuture == 1.0f) {
                    this.scrollBarAlphaFuture = 0.0f;
                    this.scrollBarAlphaFutureTime = System.currentTimeMillis();
                } else {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                }
            } else if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlpha = Math.min(this.scrollBarAlpha, 1.0f - Math.min(1.0f, (float)l / 300.0f));
            } else if (this.scrollBarAlphaFuture == 1.0f) {
                this.scrollBarAlpha = Math.max(Math.min(1.0f, (float)l / 300.0f), this.scrollBarAlpha);
            }
        }
        this.scrolling.updatePosition(delta);
        this.func_230446_a_(matrices);
        int yOffset = 0;
        for (Widget widget : this.widgets) {
            widget.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        matrices.func_227860_a_();
        ScissorsHandler.INSTANCE.scissor(this.scrolling.getBounds());
        for (Button button : this.buttonList) {
            button.getBounds().y = this.scrollListBounds.y + 1 + yOffset - this.scrolling.scrollAmountInt();
            if (button.getBounds().getMaxY() > this.scrollListBounds.getMinY() && button.getBounds().getMinY() < this.scrollListBounds.getMaxY()) {
                button.func_230430_a_(matrices, mouseX, mouseY, delta);
            }
            yOffset += button.getBounds().height;
        }
        for (int i = 0; i < this.buttonList.size(); ++i) {
            if (this.buttonList.get(i).getBounds().getMaxY() <= this.scrollListBounds.getMinY() || this.buttonList.get(i).getBounds().getMinY() >= this.scrollListBounds.getMaxY()) continue;
            this.displayRenderers.get(i).setZ(1);
            this.displayRenderers.get(i).render(matrices, this.buttonList.get(i).getBounds(), mouseX, mouseY, delta);
            Optional.ofNullable(this.displayRenderers.get(i).getTooltip(new Point(mouseX, mouseY))).ifPresent(Tooltip::queue);
        }
        this.scrolling.renderScrollBar(0, this.scrollBarAlpha, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        ScissorsHandler.INSTANCE.removeLastScissor();
        matrices.func_227865_b_();
    }

    public boolean func_231048_c_(double double_1, double double_2, int int_1) {
        for (IGuiEventListener entry : this.func_231039_at__()) {
            if (!entry.func_231048_c_(double_1, double_2, int_1)) continue;
            return true;
        }
        return super.func_231048_c_(double_1, double_2, int_1);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, int_1, double_3, double_4)) {
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 1.0f;
            return true;
        }
        for (IGuiEventListener entry : this.func_231039_at__()) {
            if (!entry.func_231045_a_(mouseX, mouseY, int_1, double_3, double_4)) continue;
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, int_1, double_3, double_4);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258 && !this.field_230706_i_.field_71474_y.field_151445_Q.func_197976_a(keyCode, scanCode)) {
            boolean boolean_1;
            boolean bl = boolean_1 = !CompositeDisplayViewingScreen.func_231173_s_();
            if (!this.func_231049_c__(boolean_1)) {
                this.func_231049_c__(boolean_1);
            }
            return true;
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesKey(keyCode, scanCode)) {
            if (((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.func_231160_c_();
                return true;
            }
            return false;
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesKey(keyCode, scanCode)) {
            if (((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = ((List)this.categoryMap.get(this.categories.get(this.selectedCategoryIndex))).size() - 1;
                }
                this.func_231160_c_();
                return true;
            }
            return false;
        }
        for (IGuiEventListener element : this.func_231039_at__()) {
            if (!element.func_231046_a_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (keyCode == 256 || this.field_230706_i_.field_71474_y.field_151445_Q.func_197976_a(keyCode, scanCode)) {
            Minecraft.func_71410_x().func_147108_a(REIRuntime.getInstance().getPreviousScreen());
            return true;
        }
        if (ConfigObject.getInstance().getPreviousScreenKeybind().matchesKey(keyCode, scanCode)) {
            if (REIRuntimeImpl.getInstance().hasLastDisplayScreen()) {
                this.field_230706_i_.func_147108_a(REIRuntimeImpl.getInstance().getLastDisplayScreen());
            } else {
                this.field_230706_i_.func_147108_a(REIRuntime.getInstance().getPreviousScreen());
            }
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }
}

