/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.function.Consumer;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import me.shedaniel.rei.impl.client.gui.widget.DynamicErrorFreeEntryListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class WarningAndErrorScreen
extends Screen {
    private Widget buttonExit;
    private StringEntryListWidget listWidget;
    private String action;
    private Screen parent;
    private List<Tuple<String, String>> warnings;
    private List<Tuple<String, String>> errors;
    private Consumer<Screen> onContinue;

    public WarningAndErrorScreen(String action, List<Tuple<String, String>> warnings, List<Tuple<String, String>> errors, Consumer<Screen> onContinue) {
        super(NarratorChatListener.field_216868_a);
        this.action = action;
        this.warnings = warnings;
        this.errors = errors;
        this.onContinue = onContinue;
    }

    public boolean func_231178_ax__() {
        return false;
    }

    public void setParent(Screen parent) {
        this.parent = parent;
    }

    private void addText(ITextComponent string) {
        for (IReorderingProcessor s : this.field_230712_o_.func_238425_b_((ITextProperties)string, this.field_230708_k_ - 80)) {
            this.listWidget.creditsAddEntry(new TextItem(s));
        }
    }

    private void addLink(ITextComponent string, String link) {
        for (IReorderingProcessor s : this.field_230712_o_.func_238425_b_((ITextProperties)string, this.field_230708_k_ - 80)) {
            this.listWidget.creditsAddEntry(new LinkItem(s, link));
        }
    }

    public void func_231160_c_() {
        int i;
        this.listWidget = new StringEntryListWidget(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, 32, this.field_230709_l_ - 32);
        this.func_230481_d_((IGuiEventListener)this.listWidget);
        this.listWidget.max = 80;
        this.listWidget.creditsClearEntries();
        this.listWidget.creditsAddEntry(new EmptyItem());
        if (!this.warnings.isEmpty()) {
            this.listWidget.creditsAddEntry(new TextItem(new StringTextComponent("Warnings:").func_240699_a_(TextFormatting.GOLD).func_241878_f()));
        }
        for (Tuple<String, String> pair : this.warnings) {
            this.addText((ITextComponent)new StringTextComponent((String)pair.func_76341_a()));
            if (pair.func_76340_b() != null) {
                this.addLink((ITextComponent)new StringTextComponent((String)pair.func_76340_b()), (String)pair.func_76340_b());
            }
            for (i = 0; i < 2; ++i) {
                this.listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        if (!this.warnings.isEmpty() && !this.errors.isEmpty()) {
            this.listWidget.creditsAddEntry(new EmptyItem());
        }
        if (!this.errors.isEmpty()) {
            this.listWidget.creditsAddEntry(new TextItem(new StringTextComponent("Errors:").func_240699_a_(TextFormatting.RED).func_241878_f()));
        }
        for (Tuple<String, String> pair : this.errors) {
            this.addText((ITextComponent)new StringTextComponent((String)pair.func_76341_a()));
            if (pair.func_76340_b() != null) {
                this.addLink((ITextComponent)new StringTextComponent((String)pair.func_76340_b()), (String)pair.func_76340_b());
            }
            for (i = 0; i < 2; ++i) {
                this.listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        for (StringItem child : this.listWidget.func_231039_at__()) {
            this.listWidget.max = Math.max(this.listWidget.max, child.getWidth());
        }
        this.buttonExit = new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 26, 200, 20, (ITextComponent)new StringTextComponent(this.errors.isEmpty() ? "Continue" : "Exit"), button -> this.onContinue.accept(this.parent));
        this.func_230480_a_(this.buttonExit);
    }

    public boolean func_231043_a_(double double_1, double double_2, double double_3) {
        return this.listWidget.func_231043_a_(double_1, double_2, double_3) || super.func_231043_a_(double_1, double_2, double_3);
    }

    public void func_230430_a_(MatrixStack matrices, int int_1, int int_2, float float_1) {
        this.func_231165_f_(0);
        this.listWidget.func_230430_a_(matrices, int_1, int_2, float_1);
        if (RoughlyEnoughItemsState.getErrors().isEmpty()) {
            WarningAndErrorScreen.func_238471_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)("Warnings during Roughly Enough Items' " + this.action), (int)(this.field_230708_k_ / 2), (int)16, (int)0xFFFFFF);
        } else {
            WarningAndErrorScreen.func_238471_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)("Errors during Roughly Enough Items' " + this.action), (int)(this.field_230708_k_ / 2), (int)16, (int)0xFFFFFF);
        }
        super.func_230430_a_(matrices, int_1, int_2, float_1);
        this.buttonExit.func_230430_a_(matrices, int_1, int_2, float_1);
    }

    private static class StringEntryListWidget
    extends DynamicErrorFreeEntryListWidget<StringItem> {
        private boolean inFocus;
        private int max = 80;

        public StringEntryListWidget(Minecraft client, int width, int height, int startY, int endY) {
            super(client, width, height, startY, endY, AbstractGui.field_230663_f_);
        }

        public boolean func_231049_c__(boolean boolean_1) {
            if (!this.inFocus && this.getItemCount() == 0) {
                return false;
            }
            boolean bl = this.inFocus = !this.inFocus;
            if (this.inFocus && this.getFocused() == null && this.getItemCount() > 0) {
                this.moveSelection(1);
            } else if (this.inFocus && this.getFocused() != null) {
                this.moveSelection(0);
            }
            return this.inFocus;
        }

        public void creditsClearEntries() {
            this.clearItems();
        }

        private StringItem rei_getEntry(int int_1) {
            return (StringItem)((Object)this.func_231039_at__().get(int_1));
        }

        public void creditsAddEntry(StringItem entry) {
            this.addItem(entry);
        }

        @Override
        public int getItemWidth() {
            return this.max;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.width - 40;
        }
    }

    private static class TextItem
    extends StringItem {
        private IReorderingProcessor text;

        public TextItem(IReorderingProcessor text) {
            this.text = text;
        }

        @Override
        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, this.text, (float)(x + 5), (float)y, -1);
        }

        @Override
        public int getItemHeight() {
            return 12;
        }

        public boolean func_231049_c__(boolean boolean_1) {
            return false;
        }

        @Override
        public int getWidth() {
            return Minecraft.func_71410_x().field_71466_p.func_243245_a(this.text) + 10;
        }
    }

    private static abstract class StringItem
    extends DynamicErrorFreeEntryListWidget.Entry<StringItem> {
        private StringItem() {
        }

        public abstract int getWidth();
    }

    private class LinkItem
    extends StringItem {
        private IReorderingProcessor text;
        private String link;
        private boolean contains;

        public LinkItem(IReorderingProcessor text, String link) {
            this.text = text;
            this.link = link;
        }

        @Override
        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            boolean bl = this.contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (this.contains) {
                WarningAndErrorScreen.this.func_238652_a_(matrices, (ITextComponent)new StringTextComponent("Click to open link."), mouseX, mouseY);
                Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, characterVisitor -> this.text.accept((charIndex, style, codePoint) -> characterVisitor.accept(charIndex, style.func_240721_b_(TextFormatting.UNDERLINE), codePoint)), (float)(x + 5), (float)y, -14695425);
            } else {
                Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, this.text, (float)(x + 5), (float)y, -14695425);
            }
        }

        @Override
        public int getItemHeight() {
            return 12;
        }

        public boolean func_231049_c__(boolean boolean_1) {
            return false;
        }

        @Override
        public int getWidth() {
            return Minecraft.func_71410_x().field_71466_p.func_243245_a(this.text) + 10;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.contains && button == 0) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                try {
                    Util.func_110647_a().func_195642_a(new URI(this.link));
                    return true;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    private static class EmptyItem
    extends StringItem {
        private EmptyItem() {
        }

        @Override
        public void render(MatrixStack matrixStack, int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
        }

        @Override
        public int getItemHeight() {
            return 5;
        }

        @Override
        public int getWidth() {
            return 0;
        }
    }
}

