/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRenderer;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class AutoCraftingEvaluator {
    public static AutoCraftingResult evaluateAutoCrafting(boolean actuallyCrafting, boolean stackedCrafting, Display display, Supplier<Collection<ResourceLocation>> idsSupplier) {
        ContainerScreen<?> containerScreen = REIRuntime.getInstance().getPreviousContainerScreen();
        AutoCraftingResult result = new AutoCraftingResult();
        ArrayList<Object> errorTooltip = new ArrayList<Object>();
        result.tooltipRenderer = (pos, sink) -> {
            Collection locations;
            ArrayList<ITextComponent> str = new ArrayList<ITextComponent>(errorTooltip);
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x && idsSupplier != null && !(locations = (Collection)idsSupplier.get()).isEmpty()) {
                str.add((ITextComponent)new StringTextComponent(" "));
                for (ResourceLocation location : locations) {
                    String t = I18n.func_135052_a((String)"text.rei.recipe_id", (Object[])new Object[]{"", location.toString()});
                    if (t.startsWith("\n")) {
                        t = t.substring("\n".length());
                    }
                    str.add((ITextComponent)new StringTextComponent(t).func_240699_a_(TextFormatting.GRAY));
                }
            }
            sink.accept(Tooltip.create(pos, str));
        };
        if (containerScreen == null) {
            errorTooltip.add(new TranslationTextComponent("error.rei.not.supported.move.items").func_240699_a_(TextFormatting.RED));
            return result;
        }
        ArrayList<TransferHandler.Result> errors = new ArrayList<TransferHandler.Result>();
        TransferHandler.Context context = TransferHandler.Context.create(actuallyCrafting, stackedCrafting, containerScreen, display);
        for (TransferHandler transferHandler : TransferHandlerRegistry.getInstance()) {
            try {
                TransferHandler.Result transferResult = transferHandler.handle(context);
                if (transferResult.isBlocking() && actuallyCrafting) {
                    if (!transferResult.isReturningToScreen()) break;
                    Minecraft.func_71410_x().func_147108_a(containerScreen);
                    REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                    break;
                }
                if (!transferResult.isApplicable()) continue;
                result.hasApplicable = true;
                result.tint = transferResult.getColor();
                TransferHandlerRenderer transferHandlerRenderer = transferResult.getRenderer(transferHandler, context);
                if (transferHandlerRenderer != null) {
                    result.renderer = transferHandlerRenderer;
                }
                if (transferResult.getTooltipRenderer() != null) {
                    BiConsumer<Point, TransferHandler.Result.TooltipSink> tooltipRenderer = transferResult.getTooltipRenderer();
                    result.tooltipRenderer = (point, tooltipConsumer) -> tooltipRenderer.accept((Point)point, tooltipConsumer::accept);
                }
                if (transferResult.isSuccessful()) {
                    errors.clear();
                    result.successful = true;
                    result.successfulHandler = transferHandler;
                    break;
                }
                errors.add(transferResult);
                if (!transferResult.isBlocking()) continue;
                break;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (!result.hasApplicable) {
            errorTooltip.clear();
            errorTooltip.add(new TranslationTextComponent("error.rei.not.supported.move.items").func_240699_a_(TextFormatting.RED));
            return result;
        }
        if (errors.isEmpty()) {
            errorTooltip.clear();
            errorTooltip.add(new TranslationTextComponent("text.auto_craft.move_items"));
        } else {
            IFormattableTextComponent colored;
            errorTooltip.clear();
            ArrayList<ITextComponent> tooltipsFilled = new ArrayList<ITextComponent>();
            for (TransferHandler.Result error : errors) {
                error.fillTooltip(tooltipsFilled);
            }
            if (errors.size() == 1) {
                for (ITextComponent tooltipFilled : tooltipsFilled) {
                    colored = tooltipFilled.func_230532_e_().func_240699_a_(TextFormatting.RED);
                    if (CollectionUtils.anyMatch(errorTooltip, ss -> ss.getString().equalsIgnoreCase(tooltipFilled.getString()))) continue;
                    errorTooltip.add(colored);
                }
            } else {
                errorTooltip.add(new TranslationTextComponent("error.rei.multi.errors").func_240699_a_(TextFormatting.RED));
                for (ITextComponent tooltipFilled : tooltipsFilled) {
                    colored = new StringTextComponent("- ").func_240699_a_(TextFormatting.RED).func_230529_a_((ITextComponent)tooltipFilled.func_230532_e_().func_240699_a_(TextFormatting.RED));
                    if (CollectionUtils.anyMatch(errorTooltip, ss -> ss.getString().equalsIgnoreCase(colored.getString()))) continue;
                    errorTooltip.add(colored);
                }
            }
        }
        return result;
    }

    public static class AutoCraftingResult {
        public int tint = 0;
        public boolean successful = false;
        public TransferHandler successfulHandler;
        public boolean hasApplicable = false;
        public TransferHandlerRenderer renderer;
        public BiConsumer<Point, Consumer<Tooltip>> tooltipRenderer;
    }
}

