/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.List;
import me.shedaniel.architectury.registry.ReloadListeners;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import org.jetbrains.annotations.Nullable;

public class CachedEntryListRender {
    public static final int RESOLUTION = 64;
    public static DynamicTexture cachedTexture;
    public static ResourceLocation cachedTextureLocation;
    public static Long2LongMap hash;

    public static void refresh() {
        RoughlyEnoughItemsCore.LOGGER.info("Refreshing cached entry list texture...");
        if (cachedTextureLocation != null) {
            Minecraft.func_71410_x().func_110434_K().func_147645_c(cachedTextureLocation);
            cachedTextureLocation = null;
        }
        if (cachedTexture != null) {
            cachedTexture.close();
            cachedTexture = null;
        }
        hash = new Long2LongOpenHashMap();
    }

    @Nullable
    public static Sprite get(EntryStack<?> stack) {
        if (stack.getType() == VanillaEntryTypes.ITEM) {
            long hashExact;
            long hashOrDefault;
            if (stack.getNullable(EntryStack.Settings.RENDERER) != null) {
                return null;
            }
            if (cachedTexture == null) {
                CachedEntryListRender.prepare();
            }
            if ((hashOrDefault = hash.getOrDefault(hashExact = EntryStacks.hashExact(stack), -1L)) != -1L) {
                int x = (int)(hashOrDefault >> 32);
                int y = (int)(hashOrDefault & 0xFFFFFFFFL);
                float width = cachedTexture.func_195414_e().func_195702_a();
                float height = cachedTexture.func_195414_e().func_195702_a();
                return new Sprite((float)(x * 64) / width, (float)((x + 1) * 64) / width, (float)(y * 64) / height, (float)((y + 1) * 64) / height);
            }
        }
        return null;
    }

    private static void prepare() {
        int side = 4;
        List<EntryStack<?>> list = EntryRegistry.getInstance().getPreFilteredList();
        while (side * side < list.size()) {
            ++side;
        }
        int width = side * 64;
        int height = side * 64;
        RoughlyEnoughItemsCore.LOGGER.info("Preparing cached texture with size %sx%s for %sx%s entries", width, height, side, side);
        hash = new Long2LongOpenHashMap(list.size() + 10);
        Minecraft minecraft = Minecraft.func_71410_x();
        MainWindow window = minecraft.func_228018_at_();
        Framebuffer target = new Framebuffer(width, height, true, false);
        target.func_147610_a(true);
        RenderSystem.viewport((int)0, (int)0, (int)window.func_198109_k(), (int)window.func_198091_l());
        RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.loadIdentity();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        RenderHelper.func_227784_d_();
        MatrixStack matrices = new MatrixStack();
        Rectangle bounds = new Rectangle();
        int index = 0;
        for (EntryStack<?> stack : list) {
            int x = index % side;
            int y = index / side;
            bounds.setBounds(x * 64, y * 64, 64, 64);
            stack.getDefinition().getRenderer().render(stack, matrices, bounds, -1, -1, 0.0f);
            hash.put(EntryStacks.hashExact(stack), CachedEntryListRender.pack(x, y));
            ++index;
        }
        NativeImage nativeImage = new NativeImage(width, height, false);
        RenderSystem.bindTexture((int)target.func_242996_f());
        nativeImage.func_195717_a(0, false);
        nativeImage.func_195710_e();
        cachedTexture = new DynamicTexture(nativeImage);
        cachedTextureLocation = minecraft.func_110434_K().func_110578_a("rei_cached_entries", cachedTexture);
        target.func_147608_a();
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
    }

    private static long pack(int x, int y) {
        return (long)x << 32 | (long)y & 0xFFFFFFFFL;
    }

    static {
        hash = new Long2LongOpenHashMap();
        ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.CLIENT_RESOURCES, (barrier, resourceManager, preparationProfiler, reloadProfiler, preparationExecutor, reloadExecutor) -> barrier.func_216872_a((Object)Unit.INSTANCE).thenRunAsync(CachedEntryListRender::refresh, reloadExecutor));
    }

    public static class Sprite {
        public final float u0;
        public final float u1;
        public final float v0;
        public final float v1;

        public Sprite(float u0, float u1, float v0, float v1) {
            this.u0 = u0;
            this.u1 = u1;
            this.v0 = v0;
            this.v1 = v1;
        }
    }
}

