/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ProgressValueAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.FloatingPoint;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.SystemFavoriteEntryProvider;
import me.shedaniel.rei.api.client.gui.AbstractContainerEventHandler;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.favorites.FavoriteEntryTypeRegistryImpl;
import me.shedaniel.rei.impl.client.gui.widget.EntryListEntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryStacksRegionWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RealRegionEntry;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionDraggableStack;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionEntryListEntry;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionListener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FavoritesListWidget
extends WidgetWithBounds
implements DraggableStackProviderWidget,
DraggableStackVisitorWidget,
OverlayListWidget,
RegionListener<FavoriteEntry> {
    private Rectangle fullBounds;
    private EntryStacksRegionWidget<FavoriteEntry> systemRegion = new EntryStacksRegionWidget<FavoriteEntry>(new RegionListener<FavoriteEntry>(){

        @Override
        @Nullable
        public FavoriteEntry convertDraggableStack(DraggingContext<Screen> context, DraggableStack stack) {
            return FavoriteEntry.fromEntryStack(stack.getStack().copy());
        }

        @Override
        public boolean canAcceptDrop(RealRegionEntry<FavoriteEntry> entry) {
            return false;
        }

        @Override
        @Nullable
        public FavoriteEntry asFavorite(RealRegionEntry<FavoriteEntry> entry) {
            return null;
        }

        @Override
        public boolean canBeDragged(RealRegionEntry<FavoriteEntry> entry) {
            return RegionListener.super.canBeDragged(entry);
        }

        @Override
        public boolean removeOnDrag() {
            return false;
        }
    });
    private EntryStacksRegionWidget<FavoriteEntry> region = new EntryStacksRegionWidget<FavoriteEntry>(this);
    private List<FavoriteEntry> lastSystemEntries = new ArrayList<FavoriteEntry>();
    public final AddFavoritePanel favoritePanel = new AddFavoritePanel(this);
    private final NumberAnimator<Double> trashBoundsHeight = ValueAnimator.ofDouble().withConvention(() -> {
        if (DraggingContext.getInstance().isDraggingStack() && this.fullBounds.contains(DraggingContext.getInstance().getCurrentPosition())) {
            return Math.min(60.0, (double)this.fullBounds.height * 0.15);
        }
        return 0.0;
    }, ValueAnimator.typicalTransitionTime());
    private final Rectangle trashBounds = new Rectangle();
    public final ToggleAddFavoritePanelButton favoritePanelButton = new ToggleAddFavoritePanelButton(this);
    private List<Widget> children = ImmutableList.of((Object)this.favoritePanel, (Object)this.favoritePanelButton, this.systemRegion, this.region);

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (this.fullBounds.contains(mouseX, mouseY)) {
            if (Screen.func_231172_r_()) {
                ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
                if (config.setEntrySize(config.getEntrySize() + amount * 0.075)) {
                    ConfigManager.getInstance().saveConfig();
                    REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                    return true;
                }
            } else if (this.favoritePanel.func_231043_a_(mouseX, mouseY, amount)) {
                return true;
            }
        }
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    @Override
    public Rectangle getBounds() {
        return this.fullBounds;
    }

    public EntryStacksRegionWidget<FavoriteEntry> getRegion() {
        return this.region;
    }

    public EntryStacksRegionWidget<FavoriteEntry> getSystemRegion() {
        return this.systemRegion;
    }

    @Override
    public void onDrop(Stream<FavoriteEntry> entries) {
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            List<FavoriteEntry> favorites = ConfigObject.getInstance().getFavoriteEntries();
            favorites.clear();
            entries.forEach(entry -> favorites.add(entry.copy()));
            ConfigManager.getInstance().saveConfig();
        }
    }

    @Override
    public void onRemove(RealRegionEntry<FavoriteEntry> entry) {
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            List<FavoriteEntry> favorites = ConfigObject.getInstance().getFavoriteEntries();
            favorites.removeIf(favoriteEntry -> Objects.equals(entry.getEntry(), favoriteEntry));
            ConfigManager.getInstance().saveConfig();
        }
    }

    @Override
    public void onConsumed(RealRegionEntry<FavoriteEntry> entry) {
        this.setSystemRegionEntries(entry);
    }

    @Override
    @Nullable
    public FavoriteEntry convertDraggableStack(DraggingContext<Screen> context, DraggableStack stack) {
        return FavoriteEntry.fromEntryStack(stack.getStack().copy());
    }

    @Override
    @Nullable
    public DraggableStack getHoveredStack(DraggingContext<Screen> context, double mouseX, double mouseY) {
        DraggableStack stack = this.region.getHoveredStack(context, mouseX, mouseY);
        if (stack != null) {
            return stack;
        }
        stack = this.systemRegion.getHoveredStack(context, mouseX, mouseY);
        if (stack != null) {
            return stack;
        }
        if (this.favoritePanel.bounds.contains(mouseX, mouseY)) {
            for (AddFavoritePanel.Row row : (List)this.favoritePanel.rows.get()) {
                if (!(row instanceof AddFavoritePanel.SectionEntriesRow)) continue;
                for (AddFavoritePanel.SectionEntriesRow.SectionFavoriteWidget widget : ((AddFavoritePanel.SectionEntriesRow)row).widgets) {
                    if (!widget.containsMouse(mouseX, mouseY + this.favoritePanel.scroller.scrollAmount())) continue;
                    RealRegionEntry<FavoriteEntry> entry = new RealRegionEntry<FavoriteEntry>(this.region, widget.entry.copy(), EntryListWidget.entrySize());
                    entry.size.setAs(EntryListWidget.entrySize() * 100);
                    return new RegionDraggableStack<FavoriteEntry>(entry, widget);
                }
            }
        }
        return null;
    }

    @Override
    public DraggedAcceptorResult acceptDraggedStackWithResult(DraggingContext<Screen> context, DraggableStack stack) {
        if (this.favoritePanel.bounds.contains(context.getCurrentPosition()) || this.trashBounds.contains(context.getCurrentPosition())) {
            context.renderToVoid(stack);
            return DraggedAcceptorResult.CONSUMED;
        }
        return Stream.of(this.region, this.systemRegion).map(visitor -> visitor.acceptDraggedStackWithResult(context, stack)).filter(result -> result != DraggedAcceptorResult.PASS).findFirst().orElse(DraggedAcceptorResult.PASS);
    }

    @Override
    public EntryStack<?> getFocusedStack() {
        Point mouse = PointHelper.ofMouse();
        EntryStack<?> stack = this.region.getFocusedStack();
        if (stack != null && !stack.isEmpty()) {
            return stack;
        }
        stack = this.systemRegion.getFocusedStack();
        if (stack != null && !stack.isEmpty()) {
            return stack;
        }
        if (this.favoritePanel.bounds.contains(mouse)) {
            for (AddFavoritePanel.Row row : (List)this.favoritePanel.rows.get()) {
                if (!(row instanceof AddFavoritePanel.SectionEntriesRow)) continue;
                for (AddFavoritePanel.SectionEntriesRow.SectionFavoriteWidget widget : ((AddFavoritePanel.SectionEntriesRow)row).widgets) {
                    if (!widget.containsMouse(mouse)) continue;
                    return ClientEntryStacks.of(widget.entry.getRenderer(false)).copy();
                }
            }
        }
        return EntryStack.empty();
    }

    @Override
    public Stream<EntryStack<?>> getEntries() {
        return this.region.getEntries();
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (this.fullBounds.isEmpty()) {
            return;
        }
        this.trashBoundsHeight.update((double)delta);
        double trashBoundsHeight = (Double)this.trashBoundsHeight.value();
        if (Math.round(trashBoundsHeight) > 0L) {
            double trashBoundsHeightTarget = Math.min(150.0, (double)this.fullBounds.height * 0.15);
            double progress = Math.pow(MathHelper.func_151237_a((double)(trashBoundsHeight / trashBoundsHeightTarget), (double)0.0, (double)1.0), 7.0);
            int y = this.fullBounds.getMaxY() - 4 - this.favoritePanel.getBounds().height;
            this.trashBounds.setBounds(this.fullBounds.x + 4, (int)Math.round((double)y - trashBoundsHeight), this.fullBounds.width - 8, (int)Math.round(trashBoundsHeight - 4.0));
            int alpha = 18 + (int)(34.0 * progress * (double)(MathHelper.func_76134_b((float)((float)((double)((float)(System.currentTimeMillis() % 2000L) / 1000.0f) * Math.PI))) + 1.0f) / 2.0);
            this.func_238468_a_(matrices, this.trashBounds.x, this.trashBounds.y, this.trashBounds.getMaxX(), this.trashBounds.getMaxY(), 0xFFFFFF | alpha << 24, 0xFFFFFF | alpha << 24);
            int lineColor = (int)(96.0 * progress) << 24 | 0xFFFFFF;
            this.func_238468_a_(matrices, this.trashBounds.x, this.trashBounds.y, this.trashBounds.getMaxX(), this.trashBounds.y + 1, lineColor, lineColor);
            this.func_238468_a_(matrices, this.trashBounds.x, this.trashBounds.getMaxY() - 1, this.trashBounds.getMaxX(), this.trashBounds.getMaxY(), lineColor, lineColor);
            this.func_238468_a_(matrices, this.trashBounds.x, this.trashBounds.y + 1, this.trashBounds.x + 1, this.trashBounds.getMaxY() - 1, lineColor, lineColor);
            this.func_238468_a_(matrices, this.trashBounds.getMaxX() - 1, this.trashBounds.y + 1, this.trashBounds.getMaxX(), this.trashBounds.getMaxY() - 1, lineColor, lineColor);
            TranslationTextComponent text = new TranslationTextComponent("text.rei.dispose_here");
            if (170.0 * progress > 4.0) {
                this.font.func_243248_b(matrices, (ITextComponent)text, (float)(this.trashBounds.getCenterX() - this.font.func_238414_a_((ITextProperties)text) / 2), (float)this.trashBounds.getCenterY() - 4.0f, (int)(170.0 * progress) << 24 | 0xFFFFFF);
            }
        } else {
            this.trashBounds.setBounds(0, 0, 0, 0);
        }
        if (!PluginManager.areAnyReloading()) {
            this.updateSystemRegion();
        }
        this.systemRegion.getBounds().setBounds(this.fullBounds.x, this.fullBounds.y + 1, this.fullBounds.width, Math.max(1, this.systemRegion.scrolling.getMaxScrollHeight()));
        int systemHeight = this.systemRegion.getBounds().getHeight();
        if (systemHeight > 1 && !this.region.isEmpty()) {
            Rectangle innerBounds = this.systemRegion.getInnerBounds();
            this.func_238468_a_(matrices, innerBounds.x + 1, this.fullBounds.y + systemHeight + 2, innerBounds.getMaxX() - 1, this.fullBounds.y + systemHeight + 3, -8947849, -8947849);
            systemHeight += 4;
        }
        if (this.favoritePanel.getBounds().height > 20) {
            this.region.getBounds().setBounds((double)this.fullBounds.x, (double)(this.fullBounds.y + systemHeight), (double)this.fullBounds.width, (double)(this.fullBounds.height - systemHeight - (this.fullBounds.getMaxY() - ((AddFavoritePanel)this.favoritePanel).bounds.y) - 4) - (Math.round(trashBoundsHeight) <= 0L ? 0.0 : trashBoundsHeight));
        } else {
            this.region.getBounds().setBounds((double)this.fullBounds.x, (double)(this.fullBounds.y + systemHeight), (double)this.fullBounds.width, (double)(this.fullBounds.height - systemHeight) - (Math.round(trashBoundsHeight) <= 0L ? 0.0 : trashBoundsHeight + 24.0));
        }
        this.systemRegion.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.region.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.renderAddFavorite(matrices, mouseX, mouseY, delta);
    }

    private void updateSystemRegion() {
        boolean updated = false;
        List<Triple<SystemFavoriteEntryProvider<?>, MutableLong, List<FavoriteEntry>>> providers = ((FavoriteEntryTypeRegistryImpl)FavoriteEntryType.registry()).getSystemProviders();
        for (Triple<SystemFavoriteEntryProvider<?>, MutableLong, List<FavoriteEntry>> pair : providers) {
            SystemFavoriteEntryProvider provider = (SystemFavoriteEntryProvider)pair.getLeft();
            MutableLong mutableLong = (MutableLong)pair.getMiddle();
            List entries = (List)pair.getRight();
            if (mutableLong.getValue() != -1L && mutableLong.getValue() >= System.currentTimeMillis()) continue;
            mutableLong.setValue(System.currentTimeMillis() + provider.updateInterval());
            List provide = provider.provide();
            if (provide.equals(entries)) continue;
            entries.clear();
            entries.addAll(provide);
            updated = true;
        }
        if (updated) {
            this.lastSystemEntries = CollectionUtils.flatMap(providers, Triple::getRight);
            this.setSystemRegionEntries(null);
        }
    }

    private void setSystemRegionEntries(@Nullable RealRegionEntry<FavoriteEntry> removed) {
        this.systemRegion.setEntries(CollectionUtils.filterToList(this.lastSystemEntries, entry -> {
            DraggableStack currentStack;
            if (this.region.has((FavoriteEntry)entry)) {
                return false;
            }
            if (DraggingContext.getInstance().isDraggingStack() && (currentStack = DraggingContext.getInstance().getCurrentStack()) instanceof RegionDraggableStack) {
                RegionDraggableStack stack = (RegionDraggableStack)currentStack;
                if (removed != null && stack.getEntry() == removed) {
                    return true;
                }
                return stack.getEntry().region != this.region || !Objects.equals(stack.getEntry().getEntry(), entry);
            }
            return true;
        }), EntryStacksRegionWidget.RemovalMode.DISAPPEAR);
    }

    @Override
    public void onSetNewEntries(List<RegionEntryListEntry<FavoriteEntry>> regionEntryListEntries) {
        this.setSystemRegionEntries(null);
    }

    private void renderAddFavorite(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.favoritePanel.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.favoritePanelButton.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.containsMouse(PointHelper.ofMouse())) {
            for (Widget widget : this.func_231039_at__()) {
                if (!widget.func_231046_a_(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateFavoritesBounds(@Nullable String searchTerm) {
        this.fullBounds = REIRuntime.getInstance().calculateFavoritesListArea();
    }

    public void updateSearch() {
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            this.region.setEntries(CollectionUtils.map(ConfigObject.getInstance().getFavoriteEntries(), FavoriteEntry::copy), EntryStacksRegionWidget.RemovalMode.DISAPPEAR);
        } else {
            this.region.setEntries(Collections.emptyList(), EntryStacksRegionWidget.RemovalMode.DISAPPEAR);
        }
    }

    public List<? extends Widget> func_231039_at__() {
        return this.children;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.systemRegion.func_231044_a_(mouseX, mouseY, button) || this.region.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        for (Widget widget : this.func_231039_at__()) {
            if (!widget.func_231044_a_(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX, mouseY)) {
            for (Widget widget : this.func_231039_at__()) {
                if (!widget.func_231048_c_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    public static class AddFavoritePanel
    extends WidgetWithBounds {
        private final FavoritesListWidget widget;
        public final ProgressValueAnimator<Boolean> expendState = ValueAnimator.ofBoolean((double)0.1, (boolean)false);
        private final Rectangle bounds = new Rectangle();
        private final Rectangle scrollBounds = new Rectangle();
        private final LazyResettable<List<Row>> rows = new LazyResettable(() -> {
            ArrayList<Row> rows = new ArrayList<Row>();
            for (FavoriteEntryType.Section section : FavoriteEntryType.registry().sections()) {
                rows.add(new SectionRow(section.getText(), (ITextComponent)section.getText().func_230532_e_().func_240700_a_(style -> style.func_244282_c(Boolean.valueOf(true)))));
                rows.add(new SectionEntriesRow(CollectionUtils.map(section.getEntries(), FavoriteEntry::copy)));
                rows.add(new SectionSeparatorRow());
            }
            if (!rows.isEmpty()) {
                rows.remove(rows.size() - 1);
            }
            rows.add(new EmptySectionRow(4));
            return rows;
        });
        private final ScrollingContainer scroller = new ScrollingContainer(){

            public Rectangle getBounds() {
                return scrollBounds;
            }

            public int getMaxScrollHeight() {
                return Math.max(1, ((List)rows.get()).stream().mapToInt(Row::getRowHeight).sum());
            }
        };

        public AddFavoritePanel(FavoritesListWidget widget) {
            this.widget = widget;
        }

        public void resetRows() {
            this.rows.reset();
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            this.bounds.setBounds(this.updatePanelArea(this.widget.fullBounds));
            this.scrollBounds.setBounds(this.bounds.x + 4, this.bounds.y + 4, this.bounds.width - 8, this.bounds.height - 20);
            this.expendState.update((double)delta);
            int buttonColor = 0xFFFFFF | Math.round(52.0f * Math.min((float)this.expendState.progress() * 2.0f, 1.0f)) << 24;
            this.func_238468_a_(matrices, this.bounds.x, this.bounds.y, this.bounds.getMaxX(), this.bounds.getMaxY(), buttonColor, buttonColor);
            this.scroller.updatePosition(delta);
            if (((Boolean)this.expendState.value()).booleanValue()) {
                ScissorsHandler.INSTANCE.scissor(this.scrollBounds);
                matrices.func_227860_a_();
                matrices.func_227861_a_(0.0, -this.scroller.scrollAmount(), 0.0);
                int y = this.scrollBounds.y;
                for (Row row : (List)this.rows.get()) {
                    row.render(matrices, this.scrollBounds.x, y, this.scrollBounds.width, row.getRowHeight(), mouseX, mouseY + this.scroller.scrollAmountInt(), delta);
                    y += row.getRowHeight();
                }
                matrices.func_227865_b_();
                ScissorsHandler.INSTANCE.removeLastScissor();
            }
        }

        private Rectangle updatePanelArea(Rectangle fullArea) {
            int currentWidth = 16 + Math.round(Math.min((float)this.expendState.progress(), 1.0f) * (float)(fullArea.getWidth() - 16 - 8));
            int currentHeight = 16 + Math.round((float)this.expendState.progress() * ((float)fullArea.getHeight() * 0.4f - 16.0f - 8.0f + 4.0f));
            return new Rectangle(fullArea.x + 4, fullArea.getMaxY() - currentHeight - 4, currentWidth, currentHeight);
        }

        public boolean func_231043_a_(double d, double e, double f) {
            if (this.scrollBounds.contains(d, e)) {
                this.scroller.offset(ClothConfigInitializer.getScrollStep() * -f, true);
                return true;
            }
            return super.func_231043_a_(d, e, f);
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return (List)this.rows.get();
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        private static abstract class Row
        extends AbstractContainerEventHandler {
            private Row() {
            }

            public abstract int getRowHeight();

            public abstract void render(MatrixStack var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);
        }

        private static class SectionRow
        extends Row {
            private final ITextComponent sectionText;
            private final ITextComponent styledText;

            public SectionRow(ITextComponent sectionText, ITextComponent styledText) {
                this.sectionText = sectionText;
                this.styledText = styledText;
            }

            @Override
            public int getRowHeight() {
                return 11;
            }

            @Override
            public void render(MatrixStack matrices, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, float delta) {
                if (mouseX >= x && mouseY >= y && mouseX <= x + rowWidth && mouseY <= y + rowHeight) {
                    Tooltip.create(this.sectionText).queue();
                }
                Minecraft.func_71410_x().field_71466_p.func_243248_b(matrices, this.styledText, (float)x, (float)(y + 1), -1);
            }

            public List<? extends IGuiEventListener> func_231039_at__() {
                return Collections.emptyList();
            }
        }

        private class SectionEntriesRow
        extends Row {
            private final List<FavoriteEntry> entries;
            private final List<SectionFavoriteWidget> widgets;
            private int blockedCount;
            private int lastY;

            public SectionEntriesRow(List<FavoriteEntry> entries) {
                this.entries = entries;
                int entrySize = EntryListWidget.entrySize();
                this.widgets = CollectionUtils.map(this.entries, entry -> new SectionFavoriteWidget(new Point(0, 0), entrySize, (FavoriteEntry)entry));
                for (SectionFavoriteWidget widget2 : this.widgets) {
                    widget2.size.setTo(entrySize * 100, 300L);
                }
                this.lastY = ((AddFavoritePanel)AddFavoritePanel.this).scrollBounds.y;
                this.updateEntriesPosition(widget -> false);
            }

            @Override
            public int getRowHeight() {
                return MathHelper.func_76123_f((float)((float)(this.entries.size() + this.blockedCount) / ((float)((AddFavoritePanel)AddFavoritePanel.this).scrollBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
            }

            @Override
            public void render(MatrixStack matrices, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, float delta) {
                this.lastY = y;
                int entrySize = EntryListWidget.entrySize();
                boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
                this.updateEntriesPosition(entry -> true);
                for (SectionFavoriteWidget widget : this.widgets) {
                    widget.update(delta);
                    if (widget.getBounds().getMaxY() <= this.lastY || widget.getBounds().getY() > this.lastY + rowHeight || widget.getCurrentEntry().isEmpty()) continue;
                    widget.func_230430_a_(matrices, mouseX, mouseY, delta);
                }
            }

            public List<? extends IGuiEventListener> func_231039_at__() {
                return this.widgets;
            }

            public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                return super.func_231044_a_(mouseX, mouseY + AddFavoritePanel.this.scroller.scrollAmount(), button);
            }

            public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
                return super.func_231045_a_(mouseX, mouseY + AddFavoritePanel.this.scroller.scrollAmount(), button, deltaX, deltaY);
            }

            public boolean func_231048_c_(double mouseX, double mouseY, int button) {
                return super.func_231048_c_(mouseX, mouseY + AddFavoritePanel.this.scroller.scrollAmount(), button);
            }

            public void updateEntriesPosition(Predicate<SectionFavoriteWidget> animated) {
                int entrySize = EntryListWidget.entrySize();
                this.blockedCount = 0;
                int width = ((AddFavoritePanel)AddFavoritePanel.this).scrollBounds.width / entrySize;
                int currentX = 0;
                int currentY = 0;
                boolean slotIndex = false;
                block0: for (SectionFavoriteWidget widget : this.widgets) {
                    while (true) {
                        int xPos = currentX * entrySize + ((AddFavoritePanel)AddFavoritePanel.this).scrollBounds.x - 1;
                        int yPos = currentY * entrySize;
                        if (++currentX >= width) {
                            currentX = 0;
                            ++currentY;
                        }
                        if (EntryListWidget.notSteppingOnExclusionZones(xPos, yPos + this.lastY - AddFavoritePanel.this.scroller.scrollAmountInt(), entrySize, entrySize, AddFavoritePanel.this.scrollBounds)) {
                            widget.moveTo(animated.test(widget), xPos, yPos);
                            continue block0;
                        }
                        ++this.blockedCount;
                    }
                }
            }

            private class SectionFavoriteWidget
            extends EntryListEntryWidget {
                private ValueAnimator<FloatingPoint> pos;
                private NumberAnimator<Double> size;
                private FavoriteEntry entry;

                protected SectionFavoriteWidget(Point point, int entrySize, FavoriteEntry entry) {
                    super(point, entrySize);
                    this.pos = ValueAnimator.ofFloatingPoint();
                    this.size = ValueAnimator.ofDouble();
                    this.entry = entry;
                    this.entry((EntryStack)ClientEntryStacks.of(entry.getRenderer(true)));
                    this.noBackground();
                }

                public void moveTo(boolean animated, int xPos, int yPos) {
                    this.pos.setTo((Object)new FloatingPoint((double)xPos, (double)yPos), animated ? 200L : -1L);
                }

                public void update(float delta) {
                    this.pos.update((double)delta);
                    this.size.update((double)delta);
                    this.getBounds().width = this.getBounds().height = (int)Math.round(this.size.doubleValue() / 100.0);
                    double offsetSize = ((double)EntryListWidget.entrySize() - this.size.doubleValue() / 100.0) / 2.0;
                    this.getBounds().x = (int)Math.round(((FloatingPoint)this.pos.value()).x + offsetSize);
                    this.getBounds().y = (int)Math.round(((FloatingPoint)this.pos.value()).y + offsetSize) + SectionEntriesRow.this.lastY;
                }

                @Override
                @Nullable
                public Tooltip getCurrentTooltip(Point point) {
                    point = PointHelper.ofMouse();
                    if (!AddFavoritePanel.this.scrollBounds.contains(point)) {
                        return null;
                    }
                    Tooltip tooltip = super.getCurrentTooltip(point);
                    if (tooltip != null) {
                        tooltip.add((ITextComponent)ImmutableTextComponent.EMPTY);
                        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.rei.drag_to_add_favorites"));
                    }
                    return tooltip;
                }
            }
        }

        private static class SectionSeparatorRow
        extends Row {
            private SectionSeparatorRow() {
            }

            @Override
            public int getRowHeight() {
                return 5;
            }

            @Override
            public void render(MatrixStack matrices, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, float delta) {
                this.func_238468_a_(matrices, x, y + 2, x + rowWidth, y + 3, -571806998, -571806998);
            }

            public List<? extends IGuiEventListener> func_231039_at__() {
                return Collections.emptyList();
            }
        }

        private static class EmptySectionRow
        extends Row {
            private final int height;

            public EmptySectionRow(int height) {
                this.height = height;
            }

            @Override
            public int getRowHeight() {
                return this.height;
            }

            @Override
            public void render(MatrixStack matrices, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, float delta) {
            }

            public List<? extends IGuiEventListener> func_231039_at__() {
                return Collections.emptyList();
            }
        }
    }

    public static class ToggleAddFavoritePanelButton
    extends FadingFavoritePanelButton {
        public ToggleAddFavoritePanelButton(FavoritesListWidget widget) {
            super(widget);
        }

        @Override
        protected void onClick() {
            this.widget.favoritePanel.expendState.setTo((Object)((Boolean)this.widget.favoritePanel.expendState.target() == false ? 1 : 0), 1500L);
            this.widget.favoritePanel.resetRows();
        }

        @Override
        protected void queueTooltip() {
            Tooltip.create(new ITextComponent[]{new TranslationTextComponent("text.rei.add_favorite_widget")}).queue();
        }

        @Override
        protected Rectangle updateArea(Rectangle fullArea) {
            return new Rectangle(fullArea.x + 4, fullArea.getMaxY() - 16 - 4, 16, 16);
        }

        @Override
        protected boolean isAvailable(int mouseX, int mouseY) {
            boolean expended = (Boolean)this.widget.favoritePanel.expendState.value();
            return this.widget.fullBounds.contains(mouseX, mouseY) || REIRuntime.getInstance().getOverlay().orElseThrow(() -> new NoSuchElementException("No value present")).getEntryList().containsMouse(new Point(mouseX, mouseY)) || expended;
        }

        @Override
        protected void renderButtonText(MatrixStack matrices, IRenderTypeBuffer.Impl bufferSource) {
            int textColor;
            float expendProgress = (float)this.widget.favoritePanel.expendState.progress();
            if (expendProgress < 0.9f) {
                textColor = 0xFFFFFF | Math.round(255.0f * this.alpha.floatValue() * (1.0f - expendProgress)) << 24;
                this.font.func_228079_a_("+", (float)this.bounds.getCenterX() - 2.5f, (float)(this.bounds.getCenterY() - 3), textColor, false, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)bufferSource, false, 0, 0xF000F0);
            }
            if (expendProgress > 0.1f) {
                textColor = 0xFFFFFF | Math.round(255.0f * this.alpha.floatValue() * expendProgress) << 24;
                this.font.func_228079_a_("+", (float)this.bounds.getCenterX() - 2.5f, (float)(this.bounds.getCenterY() - 3), textColor, false, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)bufferSource, false, 0, 0xF000F0);
            }
        }
    }

    public static abstract class FadingFavoritePanelButton
    extends WidgetWithBounds {
        protected final FavoritesListWidget widget;
        public boolean wasClicked = false;
        public final NumberAnimator<Double> alpha = ValueAnimator.ofDouble((double)0.0);
        public final Rectangle bounds = new Rectangle();

        public FadingFavoritePanelButton(FavoritesListWidget widget) {
            this.widget = widget;
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            this.bounds.setBounds(this.updateArea(this.widget.fullBounds));
            boolean hovered = this.containsMouse(mouseX, mouseY);
            switch (ConfigObject.getInstance().getFavoriteAddWidgetMode()) {
                case ALWAYS_INVISIBLE: {
                    this.alpha.setAs(0);
                    break;
                }
                case AUTO_HIDE: {
                    this.alpha.setTo(hovered ? 1.0f : (this.isAvailable(mouseX, mouseY) ? 0.5f : 0.0f), 260L);
                    break;
                }
                case ALWAYS_VISIBLE: {
                    this.alpha.setAs(hovered ? 1.0f : 0.5f);
                }
            }
            this.alpha.update((double)delta);
            int buttonColor = 0xFFFFFF | Math.round(116.0f * this.alpha.floatValue()) << 24;
            this.func_238468_a_(matrices, this.bounds.x, this.bounds.y, this.bounds.getMaxX(), this.bounds.getMaxY(), buttonColor, buttonColor);
            if (this.isVisible()) {
                IRenderTypeBuffer.Impl bufferSource = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                this.renderButtonText(matrices, bufferSource);
                bufferSource.func_228461_a_();
            }
            if (hovered) {
                this.queueTooltip();
            }
        }

        protected abstract boolean isAvailable(int var1, int var2);

        protected abstract void renderButtonText(MatrixStack var1, IRenderTypeBuffer.Impl var2);

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        public boolean isVisible() {
            return Math.round(18.0f * this.alpha.floatValue()) > 0;
        }

        protected boolean wasClicked() {
            boolean tmp = this.wasClicked;
            this.wasClicked = false;
            return tmp;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.isVisible() && this.containsMouse(mouseX, mouseY)) {
                this.wasClicked = true;
            }
            return false;
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int button) {
            if (this.wasClicked() && this.isVisible() && this.containsMouse(mouseX, mouseY)) {
                this.onClick();
                return true;
            }
            return false;
        }

        protected abstract void onClick();

        protected abstract void queueTooltip();

        protected abstract Rectangle updateArea(Rectangle var1);
    }
}

