/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.region;

import me.shedaniel.math.FloatingPoint;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.entry.region.RegionEntry;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.EntryStacksRegionWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RealRegionEntry;

public class RegionDraggableStack<T extends RegionEntry<T>>
implements DraggableStack {
    private RealRegionEntry<T> entry;
    private EntryStack<?> stack;
    private WidgetWithBounds showcaseWidget;
    private int previousIndex = -1;

    public RegionDraggableStack(RealRegionEntry<T> entry, WidgetWithBounds showcaseWidget) {
        this.entry = entry;
        this.stack = entry.getEntry().toStack();
        this.showcaseWidget = showcaseWidget;
    }

    @Override
    public EntryStack<?> getStack() {
        return this.stack;
    }

    @Override
    public void drag() {
        if (this.showcaseWidget == null && this.entry.region.listener.removeOnDrag()) {
            this.previousIndex = this.entry.region.indexOf(this.entry);
            this.entry.region.remove(this.entry, EntryStacksRegionWidget.RemovalMode.MIGRATED);
        }
    }

    public RealRegionEntry<T> getEntry() {
        return this.entry;
    }

    @Override
    public void release(DraggedAcceptorResult result) {
        if (result != DraggedAcceptorResult.CONSUMED) {
            if (!this.entry.region.listener.removeOnDrag()) {
                DraggingContext.getInstance().renderBackToPosition((DraggableStack)this, DraggingContext.getInstance().getCurrentPosition(), () -> ((FloatingPoint)this.entry.pos.value()).getLocation());
            } else if (this.showcaseWidget != null) {
                DraggingContext.getInstance().renderBackToPosition((DraggableStack)this, DraggingContext.getInstance().getCurrentPosition(), () -> new Point(this.showcaseWidget.getBounds().x, this.showcaseWidget.getBounds().y));
            } else if (result == DraggedAcceptorResult.ACCEPTED) {
                DraggingContext<?> context = DraggingContext.getInstance();
                double x = context.getCurrentPosition().x;
                double y = (double)context.getCurrentPosition().y + this.entry.region.getScrollAmount();
                this.entry.region.drop(this.entry, x, y, this.previousIndex);
            } else {
                this.entry.region.drop(this.entry);
            }
        } else {
            this.entry.region.listener.onConsumed(this.entry);
        }
    }

    public WidgetWithBounds getShowcaseWidget() {
        return this.showcaseWidget;
    }
}

