/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.view;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.client.view.Views;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplayMerger;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.craftable.CraftableFilter;
import me.shedaniel.rei.impl.client.gui.widget.AutoCraftingEvaluator;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ViewsImpl
implements Views {
    public static Map<DisplayCategory<?>, List<DisplaySpec>> buildMapFor(ViewSearchBuilder builder) {
        LinkedHashSet<Display> set;
        if (PluginManager.areAnyReloading()) {
            RoughlyEnoughItemsCore.LOGGER.info("Cancelled Views buildMap since plugins have not finished reloading.");
            return Maps.newLinkedHashMap();
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        Set<CategoryIdentifier<?>> categories = builder.getCategories();
        List<EntryStack<?>> recipesForStacks = builder.getRecipesFor();
        List<EntryStack<?>> usagesForStacks = builder.getUsagesFor();
        recipesForStacks = Stream.concat(recipesForStacks.stream(), recipesForStacks.stream().map(EntryStack::wildcard)).distinct().collect(Collectors.toList());
        usagesForStacks = Stream.concat(usagesForStacks.stream(), usagesForStacks.stream().map(EntryStack::wildcard)).distinct().collect(Collectors.toList());
        DisplayRegistry displayRegistry = DisplayRegistry.getInstance();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Object categoryConfiguration : CategoryRegistry.getInstance()) {
            DisplayCategory displayCategory = categoryConfiguration.getCategory();
            if (CategoryRegistry.getInstance().isCategoryInvisible(displayCategory)) continue;
            CategoryIdentifier<?> categoryIdentifier = categoryConfiguration.getCategoryIdentifier();
            List<?> list = displayRegistry.get(categoryIdentifier);
            set = Sets.newLinkedHashSet();
            if (categories.contains(categoryIdentifier)) {
                for (Display display2 : list) {
                    if (!displayRegistry.isDisplayVisible(display2)) continue;
                    set.add(display2);
                }
                if (set.isEmpty()) continue;
                CollectionUtils.getOrPutEmptyList(result, displayCategory).addAll(set);
                continue;
            }
            for (Display display3 : list) {
                if (!displayRegistry.isDisplayVisible(display3)) continue;
                if (!recipesForStacks.isEmpty() && ViewsImpl.isRecipesFor(recipesForStacks, display3)) {
                    set.add(display3);
                    continue;
                }
                if (usagesForStacks.isEmpty() || !ViewsImpl.isUsagesFor(usagesForStacks, display3)) continue;
                set.add(display3);
            }
            for (EntryStack entryStack : usagesForStacks) {
                if (!ViewsImpl.isStackWorkStationOfCategory(categoryConfiguration, entryStack)) continue;
                set.addAll(CollectionUtils.filterToSet(list, displayRegistry::isDisplayVisible));
                break;
            }
            if (set.isEmpty()) continue;
            CollectionUtils.getOrPutEmptyList(result, displayCategory).addAll(set);
        }
        int generatorsCount = 0;
        for (Map.Entry entry : displayRegistry.getCategoryDisplayGenerators().entrySet()) {
            CategoryIdentifier categoryIdentifier = (CategoryIdentifier)entry.getKey();
            DisplayCategory displayCategory = CategoryRegistry.getInstance().get(categoryIdentifier).getCategory();
            if (CategoryRegistry.getInstance().isCategoryInvisible(displayCategory)) continue;
            set = new LinkedHashSet<Display>();
            generatorsCount += ((List)entry.getValue()).size();
            for (DynamicDisplayGenerator dynamicDisplayGenerator : (List)entry.getValue()) {
                ViewsImpl.generateLiveDisplays(displayRegistry, dynamicDisplayGenerator, builder, set::add);
            }
            if (set.isEmpty()) continue;
            CollectionUtils.getOrPutEmptyList(result, displayCategory).addAll(set);
        }
        Consumer<Display> displayConsumer = display -> CollectionUtils.getOrPutEmptyList(result, CategoryRegistry.getInstance().get(display.getCategoryIdentifier()).getCategory()).add(display);
        for (DynamicDisplayGenerator<?> dynamicDisplayGenerator : displayRegistry.getGlobalDisplayGenerators()) {
            ++generatorsCount;
            ViewsImpl.generateLiveDisplays(displayRegistry, dynamicDisplayGenerator, builder, displayConsumer);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap(result);
        if (ConfigObject.getInstance().doMergeDisplayUnderOne()) {
            for (Map.Entry entry : result.entrySet()) {
                DisplayMerger merger = ((DisplayCategory)entry.getKey()).getDisplayMerger();
                if (merger == null) continue;
                class Wrapped
                implements DisplaySpec {
                    private Display display;
                    private List<ResourceLocation> ids = null;
                    final /* synthetic */ DisplayMerger val$merger;

                    public Wrapped(Display display2) {
                        this.val$merger = display2;
                        this.display = display;
                    }

                    public boolean equals(Object o) {
                        if (this == o) {
                            return true;
                        }
                        if (!(o instanceof Wrapped)) {
                            return false;
                        }
                        Wrapped wrapped = (Wrapped)o;
                        return this.val$merger.canMerge(this.display, wrapped.display);
                    }

                    public int hashCode() {
                        return this.val$merger.hashOf(this.display);
                    }

                    @Override
                    public Display provideInternalDisplay() {
                        return this.display;
                    }

                    @Override
                    public Collection<ResourceLocation> provideInternalDisplayIds() {
                        if (this.ids == null) {
                            this.ids = new ArrayList<ResourceLocation>();
                            Optional<ResourceLocation> location = this.display.getDisplayLocation();
                            if (location.isPresent()) {
                                this.ids.add(location.get());
                            }
                        }
                        return this.ids;
                    }

                    public void add(Display display) {
                        Optional<ResourceLocation> location = display.getDisplayLocation();
                        if (location.isPresent()) {
                            this.provideInternalDisplayIds().add(location.get());
                        }
                    }
                }
                LinkedHashMap<Wrapped, Wrapped> wrappedSet = new LinkedHashMap<Wrapped, Wrapped>();
                ArrayList<Wrapped> arrayList = new ArrayList<Wrapped>();
                for (Display display3 : ViewsImpl.sortAutoCrafting((List)entry.getValue())) {
                    Wrapped wrapped = new Wrapped(display3, merger);
                    if (wrappedSet.containsKey(wrapped)) {
                        ((Wrapped)wrappedSet.get(wrapped)).add(display3);
                        continue;
                    }
                    wrappedSet.put(wrapped, wrapped);
                    arrayList.add(wrapped);
                }
                linkedHashMap.put((DisplayCategory)entry.getKey(), arrayList);
            }
        }
        String string = String.format("Built Recipe View in %s for %d categories, %d recipes for, %d usages for and %d live recipe generators.", stopwatch.stop(), categories.size(), recipesForStacks.size(), usagesForStacks.size(), generatorsCount);
        if (ConfigObject.getInstance().doDebugSearchTimeRequired()) {
            RoughlyEnoughItemsCore.LOGGER.info(string);
        } else {
            RoughlyEnoughItemsCore.LOGGER.trace(string);
        }
        return linkedHashMap;
    }

    public static boolean isRecipesFor(List<EntryStack<?>> stacks, Display display) {
        return ViewsImpl.checkUsages(stacks, display, display.getOutputEntries());
    }

    public static boolean isUsagesFor(List<EntryStack<?>> stacks, Display display) {
        return ViewsImpl.checkUsages(stacks, display, display.getInputEntries());
    }

    private static boolean checkUsages(List<EntryStack<?>> stacks, Display display, List<EntryIngredient> entries) {
        for (EntryIngredient results : entries) {
            for (EntryStack otherEntry : results) {
                for (EntryStack<?> recipesFor : stacks) {
                    if (!EntryStacks.equalsFuzzy(otherEntry, recipesFor)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static Iterable<Display> sortAutoCrafting(List<Display> displays) {
        LinkedHashSet<Display> successfulDisplays = new LinkedHashSet<Display>();
        LinkedHashSet<Display> applicableDisplays = new LinkedHashSet<Display>();
        for (Display display2 : displays) {
            AutoCraftingEvaluator.AutoCraftingResult result = AutoCraftingEvaluator.evaluateAutoCrafting(false, false, display2, null);
            if (result.successful) {
                successfulDisplays.add(display2);
                continue;
            }
            if (!result.hasApplicable) continue;
            applicableDisplays.add(display2);
        }
        return Iterables.concat(successfulDisplays, applicableDisplays, (Iterable)Iterables.filter(displays, display -> !successfulDisplays.contains(display) && !applicableDisplays.contains(display)));
    }

    private static <T extends Display> void generateLiveDisplays(DisplayRegistry displayRegistry, DynamicDisplayGenerator<T> generator, ViewSearchBuilder builder, Consumer<T> displayConsumer) {
        for (EntryStack<?> stack : builder.getRecipesFor()) {
            Optional<List<T>> recipeForDisplays = generator.getRecipeFor(stack);
            if (!recipeForDisplays.isPresent()) continue;
            for (Display display : recipeForDisplays.get()) {
                if (!displayRegistry.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
        for (EntryStack<?> stack : builder.getUsagesFor()) {
            Optional<List<T>> usageForDisplays = generator.getUsageFor(stack);
            if (!usageForDisplays.isPresent()) continue;
            for (Display display : usageForDisplays.get()) {
                if (!displayRegistry.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
        Optional<List<T>> displaysGenerated = generator.generate(builder);
        if (displaysGenerated.isPresent()) {
            for (Display display : displaysGenerated.get()) {
                if (!displayRegistry.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
    }

    @Override
    public Collection<EntryStack<?>> findCraftableEntriesByMaterials() {
        if (PluginManager.areAnyReloading()) {
            return Collections.emptySet();
        }
        final Container menu = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        HashSet craftables = new HashSet();
        for (final Map.Entry<CategoryIdentifier<?>, List<Display>> entry : DisplayRegistry.getInstance().getAll().entrySet()) {
            List<Display> displays = entry.getValue();
            for (Display display : displays) {
                final MenuInfo<Container, Display> info = menu != null ? MenuInfoRegistry.getInstance().getClient(display, menu) : null;
                class InfoContext
                implements MenuInfoContext<Container, ClientPlayerEntity, Display> {
                    private Display display;

                    public InfoContext(Display display) {
                        this.display = display;
                    }

                    @Override
                    public Container getMenu() {
                        return menu;
                    }

                    @Override
                    public ClientPlayerEntity getPlayerEntity() {
                        return Minecraft.func_71410_x().field_71439_g;
                    }

                    @Override
                    public MenuInfo<Container, Display> getContainerInfo() {
                        return info;
                    }

                    @Override
                    public CategoryIdentifier<Display> getCategoryIdentifier() {
                        return (CategoryIdentifier)entry.getKey();
                    }

                    @Override
                    public Display getDisplay() {
                        return this.display;
                    }
                }
                InfoContext context = new InfoContext(display);
                Set<SlotAccessor> inputSlots = info != null ? info.getInputSlots(context) : Collections.emptySet();
                int slotsCraftable = 0;
                List<EntryIngredient> requiredInput = display.getRequiredEntries();
                block2: for (EntryIngredient slot : requiredInput) {
                    if (slot.isEmpty()) {
                        ++slotsCraftable;
                        continue;
                    }
                    for (EntryStack slotPossible : slot) {
                        if (!CraftableFilter.INSTANCE.matches(slotPossible, inputSlots)) continue;
                        ++slotsCraftable;
                        continue block2;
                    }
                }
                if (slotsCraftable != display.getRequiredEntries().size()) continue;
                display.getOutputEntries().stream().flatMap(Collection::stream).collect(Collectors.toCollection(() -> craftables));
            }
        }
        return craftables;
    }

    private static <T> boolean isStackWorkStationOfCategory(CategoryRegistry.CategoryConfiguration<?> category, EntryStack<T> stack) {
        for (EntryIngredient ingredient : category.getWorkstations()) {
            if (!EntryIngredients.testFuzzy(ingredient, stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startReload() {
    }
}

